/**
 * @author Dharmendra.Prajapati
 * Research Type Form 
 */
Ext.define('Academia.view.personinfo.common.pasthistory.ResearchTypeForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.researchtypeform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    cls:'x-form-fixed-footer-parent',
    items: [{
        xtype: 'hidden',
        itemId: 'research_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('RESEARCH_TYPE1'),
            store:'personinfo.common.pasthistory.ResearchTypeStr', //'common.MedicalConditionTypeStore',
            valueField: 'id',
            displayField: 'value',
            name: 'researchType',
            editable: false,
            allowBlank:false
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('RESEARCH_TITLE'),
            name: 'researchTitle',
            allowBlank:false
        },{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('RESEARCH_DATE'),
            name: 'researchDate',
            itemId:'researchDate',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange',
			endDateField : 'yearOfPublication',
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('ISSN_ISBN_NO'),
            name: 'isbnNumber'
        }, {
			xtype: 'multiselectcombofield',
			name: 'publicationIds',
			itemId: 'publicationIds',
			width: 536,
			fieldLabel: getPersonModuleTranslation('PUBLICATION_INDEX'),
			store:'personinfo.common.pasthistory.PublicationIndexStr',//'coursetransaction.coursereading.AssignCourseMultiSelect',
			displayField:'code',
			valueField:'id',
			typeAhead:true,
			forceSelection:true,
			height: 'auto',
            style:{
                marginBottom: 5
            }
			
		}]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            name: 'authorName',
            fieldLabel: getPersonModuleTranslation('AUTHOR')
        },{
            xtype: 'textfield',
            name: 'otherAuthorName',
            width: 536,
            fieldLabel: getPersonModuleTranslation('OTHER_AUTHOR')
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('PAGE_NO'),
            name: 'pageNumber',
            maskRe: /[0-9-]/,
            /*validator: function(v) {
                return /^\d{1,1}(-\d{1,5})?$/.test(v)? true : 'hyphen allowed in middle of number';
            },*/
            maxLength : 9,
           /* minValue : 0,
			mouseWheelEnabled :false,
			maxLength : 10,
			hideTrigger :true,
			allowDecimals:false,*/
            allowBlank:false
        },{
            xtype: 'textfield',
            name: 'volumeNo',
            maxLength : 10,
            fieldLabel: getPersonModuleTranslation('VOLUME_NO')
        },{
            xtype: 'textfield',
            name: 'issueNo',
            fieldLabel: getPersonModuleTranslation('ISSUE_NO')
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            name: 'impactFactor',
            fieldLabel: getPersonModuleTranslation('IMPACT_FACTOR')
        },{
        	xtype: 'datefield',
        	name: 'yearOfPublication',
        	itemId:'yearOfPublication',
        	listeners: {
        		render: function(field) {
        			return dateFormatRender(field);
        		}
        	},
        	//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
        	vtype: 'daterange',
        	//endDateField: 'todate',
        	editable:false,
        	allowBlank:false,
        	fieldLabel: getPersonModuleTranslation('PUBLICATION_YEAR'),
        	startDateField : 'researchDate',
        	/*xtype: 'nestedJsonCombo',
            name: 'publicationYear',
            fieldLabel: getPersonModuleTranslation('PUBLICATION_YEAR'),
            store:'personinfo.common.pasthistory.PublicationYearStr',
            valueField:'id',
            displayField:'value',
			typeAhead:true,
			forceSelection:true*/
        },{
            xtype: 'nestedJsonCombo',
            name: 'conferenceJournalType',
            fieldLabel: getPersonModuleTranslation('CONFERENCE_JOURNAL_TYPE'),
            store:'personinfo.common.pasthistory.ConferenceJournalTypeStr',
            valueField:'id',
            displayField:'value',
			typeAhead:true,
			forceSelection:true
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            name: 'journalName',
            fieldLabel: getPersonModuleTranslation('JOURNAL_NAME')
        },{
            xtype: 'textfield',
            name: 'publisherName',
            fieldLabel: getPersonModuleTranslation('PUBLISHER_NAME')
        },{
            xtype: 'textfield',
            name: 'researchGroup',
            fieldLabel: getPersonModuleTranslation('RESEARCH_GROUP')
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            name: 'url',
            width: 536,
            fieldLabel: getPersonModuleTranslation('LINK_URL')
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'projectType',
            fieldLabel: getPersonModuleTranslation('PROJECT_TYPE'),
            store:'personinfo.common.pasthistory.ProjectTypeStr',
            valueField : 'id',
    		displayField : 'value',
        },{
            xtype: 'numberfield',
            name: 'amountGranted',
            fieldLabel: getPersonModuleTranslation('AMOUNT_GRANTED'),
            mouseWheelEnabled :false,
			hideTrigger :true,
			allowExponential:false,
			maxLength : 8,
			decimalPrecision: 2,
			allowDecimals:true
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype: 'textfield',
        	name: 'fundingAgencyName',
        	fieldLabel: getPersonModuleTranslation('FUNDING_AGENCY_NAME')
        },{
            xtype: 'textfield',
            name: 'fundType',
            fieldLabel: getPersonModuleTranslation('FUND_TYPE')
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype: 'textfield',
        	name: 'tenure',
        	fieldLabel: getPersonModuleTranslation('TENURE')
        },{
    		xtype : 'radiogroup',
    		itemId:'whetherInstituteAffiliationId',
    		fieldLabel: getPersonModuleTranslation('INSTITUTE_AFFILIATION'),
    		 defaults: {
        		 flex: 1
        	 },
        	 items: [{
        		 boxLabel  : getCommonTranslation('YES'),
        		 name      : 'whetherInstituteAffiliation',
        		 itemId    : 'whetherInstituteAffiliationTrue',
        		 inputValue: true,
        		 checked   : true
        	 },{
        		 boxLabel  : getCommonTranslation('NO'),
        		 name      : 'whetherInstituteAffiliation',
        		 itemId    : 'whetherInstituteAffiliationFalse',
        		 inputValue: false		                     
        	 }]
    	}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	 xtype:'panel',
 			 cls: 'panelNoSpace',
 			 defaults: {
 				labelAlign: 'top'
 			},
        	 items:[{
    		xtype : 'radiogroup',
    		itemId:'whetherUCSubmittedId',
    		fieldLabel: getPersonModuleTranslation('IS_UC_SUBMITTED'),
    		 defaults: {
        		 flex: 1
        	 },
        	 items: [{
        		 boxLabel  : getCommonTranslation('YES'),
        		 name      : 'whetherUCSubmitted',
        		 itemId      : 'whetherUCSubmittedTrue',
        		 inputValue: true,
        		 checked   : true
        	 },{
        		 boxLabel  : getCommonTranslation('NO'),
        		 name      : 'whetherUCSubmitted',
        		 itemId      : 'whetherUCSubmittedFalse',
        		 inputValue: false		                     
        	 }]
    	}
        	 ]},{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_UC_SUBMISSION'),
            name: 'dateOfUCSubmission',
            itemId:'dateOfUCSubmission',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange'
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 536
        },
        items: [{
            xtype: 'textareafield',
            name: 'researchDetails',
            fieldLabel: getPersonModuleTranslation('RESEARCH_DETAILS')
        }]
    },{
		xtype:'researchtypedocument',
		itemId:'researchTypeDocument',
		minHeight: 0,
		cls: 'no-empty-placeholder-grid',
		isFixHeightGrid: true,
		isFixWidthColums: true,
		style:{marginTop:'10px',marginLeft:'0px'},
		width:250
	},{
        xtype: 'fieldcontainer',
        width: '100%',
        cls:'form-fixed-footer',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelResetId',
            scale: CONSTANTS.BUTTONSIZE

        },{
			 xtype: 'button',
			 //width: 536,
//			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadDocItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
