Ext.define('Academia.view.personinfo.common.pasthistory.StudentLanguageDetailForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.studentlanguagedetailform',
	border : false,
	frame : false,
	plugins: "formlabelrequired",
	items: [{
        xtype: 'hidden',
        itemId: 'language_detail_hidden_field',
        name: 'id'
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 240
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'nestedJsonCombo',
    		fieldLabel: getCommonTranslation('LANGUAGE'),
    		store: 'personinfo.common.personalinfo.LanguageStore',
    		valueField: 'id',
    		displayField: 'value',
    		name: 'language',
    		itemId: 'language',
    		allowBlank:false,
    		editable: false,
    		fourceSelection: true,
    	},{
        	xtype: 'numberfield',
            name: 'yearOfEducation',
            itemId: 'yearOfEducation',
            fieldLabel: getCommonTranslation('YEARS_OF_EDUCATION'),
            allowBlank: true,
            minValue: 1,
            maxValue: 99999,
            maxLength: 5,
            allowExponential:false,
            keyNavEnabled: false,
            allowDecimals:false
        }]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 240
    	},
    	layout: {
    		type: 'hbox'
    	},items: [{
    		xtype: 'nestedJsonCombo',
    		fieldLabel:getCommonTranslation('LANGUAGE_EXAM_TYPE'),
    		store: 'personinfo.common.personalinfo.LanguageExamTypeStore',
    		valueField: 'id',
    		displayField: 'value',
    		name: 'languageExamType',
    		itemId: 'languageExamType',
    		allowBlank:true,
    		editable: false,
    		fourceSelection: true,
    	},{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('OTHER_LANGUAGE_EXAM_TYPE'),
            itemId: 'otherLanguageExamType',
            name: 'otherLanguageExamType',
            allowBlank: true,
            hidden:true
        },]
    	},{
        	xtype: 'fieldcontainer',
        	width: 'auto',
        	defaults: {
        		labelAlign: 'top',
        		width: 240
        	},
        	layout: {
        		type: 'hbox'
        	},
        	items: [{
        		xtype: 'datefield',
        		fieldLabel: getCommonTranslation('LANGUAGE_EXAM_DATE'),
        		listeners: {
        			render: function(field) {
        				return dateFormatRender(field);
        			}
        		},
        		vtype : 'daterange',
        		name: 'languageExamDate',
        		itemId: 'languageExamDate'
        	},{
            	xtype: 'textfield',
            	fieldLabel: getCommonTranslation('OVERALL_SCORE'),
                itemId: 'overAllScore',
                name: 'overAllScore',
                allowBlank: true
            }]
    	     },{
    	        	xtype: 'fieldcontainer',
    	        	width: 'auto',
    	        	defaults: {
    	        		labelAlign: 'top',
    	        		width: 240
    	        	},
    	        	layout: {
    	        		type: 'hbox'
    	        	},
    	        	items: [{
    	        		xtype: 'checkboxfield',
    	    			itemId : 'isPrimaryLanguage',
    	    			labelAlign: 'right',
    	    			region: 'south',
    	    			boxLabel: getCommonTranslation('PRIMARY_LANGUAGE'),
    	    			name: 'isPrimaryLanguage',
    	    			hidden : false,
    	    			checked:false,
    	    			inputValue: true,
    	    			uncheckedValue: false,
    	    			style:{marginTop:'20px'}
    	            }]
    	    	     }
    	,{
    	    	         xtype: 'fieldcontainer',    
    	    	         layout : {
    	    	             type : 'vbox'
    	    	         },
    	    	         cls:'horizontal-scrolling-fix',
    	    	         defaults : {
    	    	             width: 536,
    	    	             labelAlign : 'top'
    	    	         },
    	    	         items : [{
    	    	             xtype:'studentlanguagedocumentgrid',
    	    	             itemId:'studentlanguagedocumentgrid',
    	    	             hidden:true,
    	    	             minHeight: 0,
    				         cls: 'no-empty-placeholder-grid',
    	    	             style:{
    	    	                 marginLeft:'0px',
    	    	             },
    	    	             flex:.1
    	    	         }]
    	    	     
    	    	     },{
    	    	         xtype: 'fieldcontainer',    
    	    	         layout : {
    	    	             type : 'vbox'
    	    	         },
    	    	         cls:'horizontal-scrolling-fix',
    	    	         defaults : {
    	    	             width: 536,
    	    	             labelAlign : 'top'
    	    	         },
    	    	         items : [{
    	    	             xtype:'studentlanguageurlgrid',
    	    	             itemId:'studentlanguageurlgrid',
    	    	             minHeight: 0,
		                     cls: 'no-empty-placeholder-grid',
    	    	             hidden:true,
    	    	             style:{
    	    	                 marginLeft:'0px',
    	    	             },
    	    	             flex:.1
    	    	         }]
    	    	     
    	    	     },{
        	    	         xtype: 'fieldcontainer',    
        	    	         layout : {
        	    	             type : 'vbox'
        	    	         },
        	    	         cls:'horizontal-scrolling-fix',
        	    	         defaults : {
        	    	             width: 536,
        	    	             labelAlign : 'top'
        	    	         },
        	    	         items : [{
        	    	             xtype:'applicantlanguagedocdetailgrid',
        	    	             itemId:'applicantlanguagedocdetailgrid',
        	    	             minHeight: 0,
	                             cls: 'no-empty-placeholder-grid',
        	    	             hidden:true,
        	    	             style:{
        	    	                 marginLeft:'0px',
        	    	             },
        	    	             flex:.1
        	    	         }]
        	    	     
        	    	     },{
        	    	         xtype: 'fieldcontainer',    
        	    	         layout : {
        	    	             type : 'vbox'
        	    	         },
        	    	         cls:'horizontal-scrolling-fix',
        	    	         defaults : {
        	    	             width: 536,
        	    	             labelAlign : 'top'
        	    	         },
        	    	         items : [{
        	    	             xtype:'applicantlangurlgrid',
        	    	             itemId:'applicantlangurlgrid',
        	    	             minHeight: 0,
	                             cls: 'no-empty-placeholder-grid',
        	    	             hidden:true,
        	    	             style:{
        	    	                 marginLeft:'0px',
        	    	             },
        	    	             flex:.1
        	    	         }]
        	    	     
        	    	     },{
    	    xtype: 'fieldcontainer',
    	    items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SUBMIT'),
    		itemId: 'submitButtonId',
    		buttonAlign: 'right',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	}, {
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		ui: 'CustomBtnCancel',
    		itemId: 'cancelButtonId',
    		scale: CONSTANTS.BUTTONSIZE
    	},{
			 xtype: 'button',
			 name: 'languageUploadFile',
			 text:getCommonTranslation('UPLOAD_DOCUMENT'),
			 itemId: 'languageUploadFileItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		},{
			 xtype: 'button',
			 name: 'languageUploadURL',
			 text:getCommonTranslation('UPLOAD_URL'),
			 itemId: 'languageURLItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]

});