/**
 *  @Dharmendra.Prajapati
 *  Patent Details Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.TrainingPersonDetailsGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.trainingpersondetailsgrid',
    title: getPersonModuleTranslation('TRAINING_DETAILS'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
    columns: [{
        header: getPersonModuleTranslation('TRAINING_TYPE'),
        dataIndex: 'trainingType',
        sortable: true,
        flex: .2,
        renderer : function(obj){
        	return columnObjRender(obj, "value");
        }
    }, {
        header: getPersonModuleTranslation('TRAINING_SPECIALIZATION_STREAM'),
        dataIndex: 'trainingSpecialization',
        sortable:true,
        flex: .3
    }, {
        header: getPersonModuleTranslation('ORGANISATION_NAME'),
        dataIndex: 'organisationName',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('ORGANISATION_ADDRESS'),
        dataIndex: 'address',
        //sortable:true,
        flex: .2,
        renderer:function(value){
        	if (!isNullOrEmpty(value)) {
        		return "<a href='#'>"+getPersonModuleTranslation('VIEW')+"</a>";
        	}
		}
    }, {
        header: getPersonModuleTranslation('TRAINING_STATUS'),
        dataIndex: 'trainingStatus',
        sortable:true,
        flex: .2,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ON_GOING' || value == 'On going'){
					return getPersonModuleTranslation('ON_GOING');
				}else if(value == 'COMPLETED' || value == 'Completed'){
					return getPersonModuleTranslation('COMPLETED');
				}else{
					return "";
				} 
			}
		}
    },{
        header: getPersonModuleTranslation('NO_OF_HOURS'),
        dataIndex: 'noOfHours',
        sortable:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('FROM_DATE'),
        dataIndex: 'fromDate',
        sortable:true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getPersonModuleTranslation('To_Date'),
        dataIndex: 'toDate',
        sortable:true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getPersonModuleTranslation('DOCUMENT'),
        dataIndex: 'noOfdocument',
        sortable:true,
        flex: .2,
        renderer : function(val){
        	if (!isNullOrEmpty(val) && val > 0) {
        		return '<a href="#">'+val+'</a>';
        	}
		}
    }, {
        header: getCommonTranslation('TRAINING_DETAILS'),
        dataIndex: 'trainingDetails',
        sortable:true,
        hidden: true,
        flex: .2
    }, {
        header: getCommonTranslation('REMARKS'),
        dataIndex: 'remarks',
        sortable:true,
        hidden: true,
        flex: .2
    }],

   initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.pasthistory.PersonTrainingTypeGridStr');
    }

});