/**
 *  @Deepak.Nigam
 *  Transport Details Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.TransportPersonDetailsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.transportpersondetailsgrid',
	title: getTransportTranslation('TRANSPORT_DETAILS'),
	border: true,
	viewConfig: {
		stripeRows: true
	},
	columns: [{
		header: getTransportTranslation('SERVICE_ROUTE_NAME'),
		dataIndex: 'serviceRouteName',
		sortable: true,
		flex: .2
	},{
		header : getTransportTranslation('ROUTE_NAME'),
		dataIndex: 'routeName',
		sortable: true,
		flex: .2
	},{
		header: getTransportTranslation('START_FROM'),
		dataIndex: 'startFrom',
		sortable: true,
		flex: .2,
		hidden:true
	},{
		header: getTransportTranslation('START_TIME'),
		dataIndex: 'startTime',
		sortable: true,
		flex: .2,
		hidden:true,
		renderer:function(value,record){
			if(!isNullOrEmpty(value)){
				return timeRender(value);
			}
		}
	},{
		header: getTransportTranslation('ENDS_AT'),
		dataIndex: 'endsAt',
		sortable: true,
		flex: .2,
		hidden:true
	},{
		header: getTransportTranslation('END_TIME'),
		dataIndex: 'endTime',
		sortable: true,
		flex: .2,
		hidden:true,
		renderer:function(value,record){
			if(!isNullOrEmpty(value)){
				return timeRender(value);
			}
		}
	},{
		header: getTransportTranslation('SERVICE_ROUTE_STOP'),
		dataIndex: 'serviceRouteStop',
		sortable: true,
		flex: .2
	},{
		header: getTransportTranslation('VEHICLE_NUMBER'),
		dataIndex: 'vehicleNumber',
		sortable: true,
		flex: .2
	},{
		header: getTransportTranslation('DISTANCE_COVERRED'),
		dataIndex: 'distanceCovered',
		sortable: true,
		flex: .2
	},{
		header: getTransportTranslation('RESPONSIBLE_PERSON'),
		dataIndex: 'responsiblePersonName',
		sortable: true,
		flex: .2,
		renderer: function(value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(record.get("responsiblePersonId"))) {
				return record.get("responsiblePersonN");
			}else{
				return value;
			}
		}
	}],

	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.pasthistory.TransportDetailsGridStore');
	}

});
