/**
 *  Vaccination Grid
 */

Ext.define('Academia.view.personinfo.common.pasthistory.VaccinationGridForApplicantFaculty', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.vaccinationgridforapplicantfaculty',
    title: getPersonModuleTranslation('VACCINATION_DETAILS'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
  //  isGridConfigurable:  true,
    //enableColumnHide: false,
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
    columns: [/*{
        header: getCommonTranslation('STUDENT_STATUS'),
        dataIndex: 'studentStatus.',
        sortable: true,
       // hidden: false,
        flex: .2
    },*/{
        header: getPersonModuleTranslation('VACCINATION_NAME'),
        dataIndex: 'name',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('PURPOSE'),
        dataIndex: 'purpose',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('VACCINATION_DATE'),
        dataIndex: 'vaccinationDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getPersonModuleTranslation('REMARKS'),
        dataIndex: 'remarks',
        sortable: true,
        flex: .2
    }, {
		header:  getPersonModuleTranslation('DOCUMENTS'),
		dataIndex: 'documents',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				if(record.data.documents.length>1) {					
					return '<a href=#>'+record.data.documents.length+'<a>';
				} else if(record.data.documents.length==1) {
					return '<a href=#>'+record.data.documents[0].name+'<a>';
				} 
			}                        
		}
	}],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.pasthistory.VaccinationStore');
    }
});