/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.FundingAndMonitoringDetailsWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.fundingandmonitoringdetailswin',
	title: getPersonModuleTranslation('FUNDING_AND_MONITORING'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		plugins : "formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype:'hidden',
			itemId:'recordId',
			name:'recordId'
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'customcombobox',
				editable:false,
				forceSelection: true,
			},
			items:[{
				name: 'program',
				itemId:'programItemId',
				store: 'personinfo.common.paymentandrefund.FundingAndMonitoringProgramStore',
				fieldLabel: getCommonTranslation('PROGRAM'),
				allowBlank:false,
				valueField: 'programId',
				displayField: 'programCodeName',
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			},{
				name: 'fundingBody',
				itemId:'fundingBodyItemId',
				store:'personinfo.common.paymentandrefund.FundingBodyStore',
				valueField: 'id',
				displayField: 'value',
				fieldLabel: getCommonTranslation('FUNDING_BODY'),
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'customcombobox',
				editable:false,
				forceSelection: true,
			},
			items:[{
				name: 'nonRegulatedFeeFlag',
				itemId:'nonRegulatedFeeFlagItemId',
				store: 'personinfo.common.paymentandrefund.NonRegulatedFeeFlagStore',
				fieldLabel: getCommonTranslation('NON-REGULATED_FEE_FLAG'),
				valueField: 'id',
				displayField: 'value',
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			},{
				name: 'fundingLength',
				itemId:'fundingLengthItemId',
				store:'personinfo.common.paymentandrefund.FundingLengthStore',
				valueField: 'id',
				displayField: 'value',
				fieldLabel: getCommonTranslation('FUNDING_LENGTH'),
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'customcombobox',
				editable:false,
				forceSelection: true,
			},
			items:[{
				name: 'fundingCompletion',
				itemId:'fundingCompletionItemId',
				store: 'personinfo.common.paymentandrefund.FundingCompletionStore',
				fieldLabel: getCommonTranslation('FUNDING_COMPLETION'),
				valueField: 'id',
				displayField: 'value',
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			},{
				name: 'equivalentOrLowerQualification',
				itemId:'equivalentOrLowerQualificationItemId',
				store:'personinfo.common.paymentandrefund.EquOrLowerQualificationStore',
				valueField: 'id',
				displayField: 'value',
				fieldLabel: getCommonTranslation('EQUIVALENT_OR_LOWER_QUALIFICATION'),
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'fundMonitoringDetailSave',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'fundMonitoringDetailCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});
