/**
 * This view is used for refund history
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.RefundHistoryGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.refundhistorygrid',
	title: getPersonModuleTranslation('REFUNDS'),
	border: true,
	viewConfig: {
		stripeRows: true
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	columns: [{
		header: getPersonModuleTranslation('PAYMENT_DATE'),
		dataIndex: 'paymentDate',
		sortable: true,
		flex: .2,
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}
		}, 
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(portalId==1){
				if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
					return getFeeAndPaymentCommonTranslation('TOTAL')+" ("+"In "+store.data.items[0].data.baseCurrencyName+")";
				} else {
					return getFeeAndPaymentCommonTranslation('TOTAL');
				}
			}else{
				if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
					return getFeeAndPaymentCommonTranslation('TOTAL');
				}
			}
		}
	}, {
		header: getPersonModuleTranslation('PAYMENT_VOUCHER_NUMBER'),
		dataIndex: 'paymentVoucherNo',
		sortable: true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('REFUND_AMOUNT'),
		dataIndex: 'amount',
		flex: .2,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(portalId ==1){
				if(store.data.items[0].data.baseCurrencyId==null){
					return currencyRenderer(value,store.data.items[0].data.currencyId);
				}
				return " ";
			}else{
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		}
	},{
		header: getPersonModuleTranslation('CURRENCY_EXCHANGE_RATE'),
		dataIndex: 'currencyExchangeRate',
		flex: .2
	}, {
		header: getPersonModuleTranslation('CONVERTED_AMOUNT'),
		dataIndex: 'convertedAmount',
		flex: .2,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}
		},
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
		}
	},  {
		header: getPersonModuleTranslation('PAYMENT_TYPE'),
		dataIndex: 'paymentType',
		flex: .2,
		renderer: function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}
		}
	},  {
		header: getPersonModuleTranslation('PAYMENT_VIEW'),
		dataIndex: 'paymentView',
		flex: .2,
		renderer: function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}
		}
	},{
		header: getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
		dataIndex: 'voucherMode',
		flex: .2,
		renderer: function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}
		}
	},{
		header: getPersonModuleTranslation('ADJUSTMENT_DETAILS'),
		dataIndex: 'adjustment',
		flex: .2,
		align : 'center',
		renderer: function(value){
			return '<a href="#">'+getPersonModuleTranslation('VIEW')+'</a>';
		}
	}, {
		header: getPersonModuleTranslation('INSTRUMENT_DETAILS'),
		dataIndex: 'instrument',
		flex: .2,
		align : 'center',
		renderer: function(value){
			return '<a href="#">'+getPersonModuleTranslation('VIEW')+'</a>';
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.paymentandrefund.RefundHistoryStore');
	}
});