/**
 * This view is used for the student, faculty refundable payment grid.
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.RefundablePaymentGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.refundablepaymentgrid',
	title: getPersonModuleTranslation('REFUNDABLE_PAYMENT'),
	border: true,
	viewConfig: {
		stripeRows: true
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}],
	columns: [{
		header: getPersonModuleTranslation('BILL_DATE'),
		dataIndex: 'billDate',
		flex: .2,
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}
		},
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(portalId==1){
				if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
					return getFeeAndPaymentCommonTranslation('TOTAL')+" ("+"In "+store.data.items[0].data.baseCurrencyName+")";
				} else {
					return getFeeAndPaymentCommonTranslation('TOTAL');
				}
			}else{
				if(store.data.items[0].data.whetherDisplayTotal != false && !isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
					return getFeeAndPaymentCommonTranslation('TOTAL');
				}
			}
		}
	},{
		header: getPersonModuleTranslation('REFUND_NUMBER'),
		dataIndex: 'billNo',
		sortable: true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('BILL_AMOUNT'),
		dataIndex: 'feeAmount',
		flex: 0.2,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryType: 'sum',
		// align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(portalId ==1){
				if(store.data.items[0].data.baseCurrencyId==null){
					return currencyRenderer(value,store.data.items[0].data.currencyId);	
				}
				return " ";
			}else{
				if(store.data.items[0].data.whetherDisplayTotal != false){
					return currencyRenderer(value,store.data.items[0].data.currencyId);					
				}
			}
		}
	},
	{
		header: getPersonModuleTranslation('CURRENCY_EXCHANGE_RATE'),
		dataIndex: 'currencyExchangeRate',
		sortable: true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('CONVERTED_AMOUNT'),
		dataIndex: 'convertedAmount',
		flex: .2,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}
		},
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
		}
	},{
		header: getPersonModuleTranslation('BILL_TYPE'),
		dataIndex: 'raiseBillType',
		flex: .2,
		renderer: function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}
		}
	},{
		header: getPersonModuleTranslation('BILL_CURRENCY'),
		dataIndex: 'currencyName',
		flex: .2,
		hidden:true
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.paymentandrefund.RefundablePaymentStore');
	}
});
