/**
 * Address Details
 */
Ext.define('Academia.view.personinfo.common.personalinfo.AddressDetails', {
    extend: 'Ext.form.Panel',
    alias: 'widget.addressdetails',
    title: getPersonModuleTranslation('ADDRESS'),
    closable: true,
    addressTemplateData: null,
    addressPersonId: null,
    items: [{
        xtype: 'panel',
        style: {
        	'margin': '25px 0px 0px 25px !important'
        },	
        frame: false,
        width: '100%',
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('SELECT_ADDRESS'),
            store: Ext.create('Academia.store.personinfo.common.personalinfo.AddressComboStore'),
            valueField: 'id',
            width: 400,
            labelWidth:120,
            displayField: 'value',
            value: 'SELF_ADDRESS',
            itemId: 'addressCombo',
            queryMode: 'local',
            triggerAcation: 'all',
            editable: false
        }]
    }, {
        xtype: 'addressdisplaypanel',
        itemId: 'studentAddressDisplayPanel',
        style: {
        	marginTop: '50px'
        }	
    }],
    getAddressTemplateData: function() {
        return this.addressTemplateData;
    },
    setAddressTemplateData: function(addressTemplateData) {
        this.addressTemplateData = addressTemplateData;
    },
    getAddressPersonId: function() {
        return this.addressPersonId;
    },
    setAddressPersonId: function(addressPersonId) {
        this.addressPersonId = addressPersonId;
    }
});