
Ext.define('Academia.view.personinfo.common.personalinfo.EmpAdditionalDetailsForm', {
	extend :'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.empadditionaldetailsform',
	padding: '15',
	margin: 0,
	width:'auto',
	plugins: "formlabelrequired",
	standardSubmit: false,
	defaults: {
		labelAlign: 'top'
	},
	cls:'x-form-fixed-footer-parent',
	items: [{
		xtype: 'form',
		itemId:'empadditionaldetailsformWin',
		items: [{	
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			height:98,
			defaults: {
				xtype: 'numberfield',
				cls:'empDetailFormCls',
				width: 256,
				labelAlign: 'top',
				minValue:0,
			},
			items:[{
				name: 'numberOfArticlesInPeerReviewedOrRefereedJournals',
				itemId:'numberOfArticlesInPeerReviewedOrRefereedJournals',
				fieldLabel: getCommonTranslation('NUMBER_OF_ARTICLES_IN_PEER_REVIEWED_OR_REFEREED_JOURNALS'),
			},{
				name: 'numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst',
				itemId:'numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst',
				fieldLabel: getCommonTranslation('NUMBER_OF_ARTICLES_IN_PEER_REVIEWED_OR_REFEREED_JOURNALS_AS_FIRST_OR_CORRESPONDING_AUTHOR'),
			},{
				name: 'numberOfPublishedConferencePapers',
				itemId:'numberOfPublishedConferencePapers',
				fieldLabel: getCommonTranslation('NUMBER_OF_PUBLISHED_CONFERENCE_PAPERS'),
			},{
				name: 'numberOfPublishedConferencePapersAsFirst',
				itemId:'numberOfPublishedConferencePapersAsFirst',
				fieldLabel: getCommonTranslation('NUMBER_OF_PUBLISHED_CONFERENCE_PAPERS_AS_FIRST_OR_CORRESPONDING_AUTHOR'),
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			height:98,
			defaults: {
				xtype: 'numberfield',
				cls:'empDetailFormCls',
				width: 256,
				labelAlign: 'top',
				minValue:0,
			},
			items:[{
				name: 'numberOfConferencesAndSymposia',
				itemId:'numberOfConferencesAndSymposia',
				fieldLabel: getCommonTranslation('NUMBER_OF_CONFERENCE_AND_SYMPOSIA_ORAL_POSTER_PRESENTATIONS'),
			},{
				name: 'numberOfConferencesAndSymposiaAsFirst',
				itemId:'numberOfConferencesAndSymposiaAsFirst',
				fieldLabel: getCommonTranslation('NUMBER_OF_CONFERENCE_AND_SYMPOSIA_ORAL_POSTER_PRESENTATIONS_AS_FIRST_OR_CORRESPONDING_AUTHOR'),
			},{
				xtype: 'textfield',
				name: 'scopusGoogleProfileOfExternalExaminer',
				itemId:'scopusGoogleProfileOfExternalExaminer',
				fieldLabel: getCommonTranslation('SCOPUS_GOOGLE_PROFILE_OF_EXTERNAL_EXAMINER'),
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			height:98,
			defaults: {
				xtype: 'numberfield',
				cls:'empDetailFormCls',
				width: 256,
				labelAlign: 'top',
				minValue:0,
			},
			items:[{
				name: 'numberOfPhDsSupervisedOverLastFiveYears',
				itemId:'numberOfPhDsSupervisedOverLastFiveYears',
				fieldLabel: getCommonTranslation('NUMBER_OF_PHDS_SUPERVISED_OVER_THE_LAST_FIVE_YEARS'),
			},{
				name: 'numberOfCurrentPhDStudents',
				itemId:'numberOfCurrentPhDStudents',
				fieldLabel: getCommonTranslation('NUMBER_OF_CURRENT_PHD_STUDENTS'),
			},{
				name: 'numberOfPHDsCompleted',
				itemId:'numberOfPHDsCompleted',
				fieldLabel: getCommonTranslation('NUMBER_OF_PHDS_COMPLETED'),
			},{
				name: 'numberOfMasterDegreeSupervisedOverFiveYears',
				itemId:'numberOfMasterDegreeSupervisedOverFiveYears',
				fieldLabel: getCommonTranslation('NUMBER_OF_MASTERS_DEGREES_SUPERVISED_OVER_THE_LAST_FIVE_YEARS'),
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			height:98,
			defaults: {
				xtype: 'numberfield',
				cls:'empDetailFormCls',
				width: 256,
				labelAlign: 'top',
				minValue:0,
			},
			items:[{
				name: 'numberOfCurrentMasterStudents',
				itemId:'numberOfCurrentMasterStudentsDisField',
				fieldLabel: getCommonTranslation('NUMBER_OF_CURRENT_MASTERS_STUDENTS'),
			},{
				name: 'numberOfMasterDegreeCompleted',
				itemId:'numberOfMasterDegreeCompleted',
				fieldLabel: getCommonTranslation('NUMBER_OF_MASTERS_DEGREES_COMPLETED'),
			},{
				name: 'numberOfMastersExamined',
				itemId:'numberOfMastersExamined',
				maxLength:10,
				enforceMaxLength:true,
				allowDecimals:false,
				allowExponential: false,
				fieldLabel: getCommonTranslation('NUMBER_OF_MASTERS_EXAMINED'),
			},{
				name: 'numberOfPhDsExamined',
				itemId:'numberOfPhDsExamined',
				maxLength:10,
				enforceMaxLength:true,
				allowDecimals:false,
				allowExponential: false,
				fieldLabel: getCommonTranslation('NUMBER_OF_PHDS_EXAMINED'),
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			height:250,
			defaults: {
				xtype: 'textarea',
				cls:'empDetailFormCls empDetailsTexAreaCls',
				width: 305,
				labelAlign: 'top',
				maxLength:2500,
				enforceMaxLength:true
			},
			items:[{
				name: 'nominationOfInternationalExaminer',
				itemId:'nominationOfInternationalExaminer',
				fieldLabel: getCommonTranslation('NOMINATION_ON_AN_INTERNATIONAL_EXAMINER'),
			},{
				name: 'amendmentOfExaminer',
				itemId:'amendmentOfExaminer',
				fieldLabel: getCommonTranslation('AMENDMENT_OF_AN_EXAMINER'),
			},{
				name: 'nominationOfInternalExaminer',
				itemId:'nominationOfInternalExaminer',
				fieldLabel: getCommonTranslation('NOMINATION_ON_AN_INTERNAL_EXAMINER'),
			}]
		
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			height:250,
			defaults: {
				xtype: 'textarea',
				cls:'empDetailFormCls empDetailsTexAreaCls',
				width: 305,
				labelAlign: 'top',
				maxLength:2500,
				enforceMaxLength:true
			},
			items:[{
				name: 'nominationOfExternalExaminer',
				itemId:'nominationOfExternalExaminer',
				fieldLabel: getCommonTranslation('NOMINATION_ON_AN_EXTERNAL_EXAMINER'),
			},{
				name: 'deviationFromNormalRequirements',
				itemId:'deviationFromNormalRequirements',
				fieldLabel: getCommonTranslation('DEVIATION_FROM_NORMAL_REQUIREMENTS'),
			},{
				name: 'abbreviatedCurriculumVitaeInformation',
				itemId:'abbreviatedCurriculumVitaeInformation',
				fieldLabel: getCommonTranslation('ABBREVIATED_CURRICULUM_VITAE_INFORMATION'),
			}]
		
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			height:70,
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'approvalBody',
				itemId:'approvalBody',
				store: Ext.create('Academia.store.personinfo.common.personalinfo.EmployeeAdditionalInfoGridStore'),
				fieldLabel: getCommonTranslation('APPROVAL_BODY'),
				valueField: 'id',
				displayField: 'value',
			},{
				xtype: 'textfield',
				name: 'approvalBodyName',
				itemId:'approvalBodyName',
				fieldLabel: getCommonTranslation('APPROVAL_BODY_NAME'),
				hidden:true,
			},{
				xtype: 'datefield',
				name: 'approvalDate',
				itemId:'approvalDate',
				editable:false,
				fieldLabel: getCommonTranslation('APPROVAL_DATE'),
				listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                },
			}]
		},{
				xtype:'fieldcontainer',
				cls:'form-fixed-footer',
				items: [{
					xtype: 'button',
					action: 'Submit',
					text: getCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'empAdditionDetailFormSave',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getCommonTranslation('RESET'),
					ui: 'CustomBtnCancel',
					itemId: 'empAdditionDetailFormReset',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
	}]	
});
