/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.common.personalinfo.FeePayerGoogleAddressWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.feepayergoogleaddresswin',
	title: getCommonTranslation('ADDRESS_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype:'fieldcontainer',
			layout:'vbox',
			width: 'auto',
			defaults: {
				labelAlign: 'top'
			},
			items:[{
				xtype: 'checkboxfield',
				itemId : 'isSameAsStudentGoogleAddressId',
				boxLabel: getCommonTranslation('SAME_AS_STUDENT_GOOGLE_ADDRESS'),
				name: 'isSameAsStudentGoogleAddress',
				inputValue: true,
				uncheckedValue: false,
				hidden:true
			},{
				xtype: 'checkboxfield',
				itemId : 'isSameAsApplicantGoogleAddressId',
				boxLabel: getCommonTranslation('SAME_AS_APPLICANT_GOOGLE_ADDRESS'),
				name: 'isSameAsApplicantGoogleAddress',
				inputValue: true,
				uncheckedValue: false,
				hidden:true
			},{
				xtype : 'textareafield',
				fieldLabel : getCommonTranslation('ADDRESS'),
				name : 'googleAddress',
				itemId : 'googleAddressId',
				maxLength: 1000,
				allowBlank:false,
				width: 460
			}]
		},{
		    xtype: 'fieldcontainer',
		    layout:'hbox',
		    width: 'auto',
		    defaults: {
		    	labelAlign: 'top',
		    	width: 226
		    },
		    items: [{
		    	xtype: 'textfield',
		    	fieldLabel : getPersonModuleTranslation('GOOGLE_ADDRESS_COUNTRY'),
		    	name: 'googleAddressCountry',
		    	itemId: 'googleAddressCountryId'
		    },{
		    	xtype: 'textfield',
		    	fieldLabel : getPersonModuleTranslation('GOOGLE_ADDRESS_COUNTRY_REGION'),
		    	name: 'googleAddressCountryRegion',
		    	itemId: 'googleAddressCountryRegionId'
		    }]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			layout: {
				type: 'hbox'
			},
			items: [{
				xtype: 'textfield',
				fieldLabel : getPersonModuleTranslation('GOOGLE_ADDRESS_CITY'),
				name:'googleAddressCity',
				itemId: 'googleAddressCityId'
			},{
				xtype: 'textfield',
				fieldLabel : getPersonModuleTranslation('GOOGLE_ADDRESS_POSTAL_CODE'),
				name:'googlePincode',
				itemId: 'googlePincodeId'
			}] 
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'googleAddressBtnSave',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'googleAddressBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});