/**
 *  @author Amit G
 */
Ext.define('Academia.view.personinfo.common.personalinfo.LivingArrangementGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.livingarrangementgrid',
	title: getCommonTranslation('LIVING_ARRANGEMENT'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getCommonTranslation('LIVING_ARRANGEMENT'),
		dataIndex : 'livingArrangement',
		flex:1,
		renderer : function(value){
			if(value=='CATERED_RESIDENCE'){
				return getCommonTranslation('CATERED_RESIDENCE')
			}else if (value=='SELF_CATERED_RESIDENCE'){
				return getCommonTranslation('SELF_CATERED_RESIDENCE')
			}else if (value=='PRIVATE_ACCOMMODATION'){
				return getCommonTranslation('PRIVATE_ACCOMMODATION')
			}else if(value=='HOME'){
				return getCommonTranslation('HOME')
			}		
		}
	},{
		header : getCommonTranslation('ROOM_ALLOCATION'),
		dataIndex : 'roomAllocation',
		flex:1
	},{
		header : getCommonTranslation('ADDRESS'),
		dataIndex : 'address',
		flex:1
	},{
		header : getCommonTranslation('START_MONTH'),
		dataIndex : 'startMonth',
		flex : 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header : getCommonTranslation('END_MONTH'),
		dataIndex : 'endMonth',
		flex : 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header : getCommonTranslation('ACCOMMODATION_PROVIDER'),
		dataIndex : 'accommodationProvider',
		flex : 1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.accommodationProviderId)) {
				return record.data.accommodationProviderId.accommodProviderName
			}else if(!isNullOrEmpty(record.data.contactNumber)) {
				return 'Other';
			}else {
				return "";
			}                        
		}
	},{
		header : getCommonTranslation('PROVIDER_NAME'),
		dataIndex : 'providerName',
		flex : 1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.accommodationProviderId)) {
				return record.data.accommodationProviderId.contactPerson
			}else if(!isNullOrEmpty(record.data.hostelName)) {
				return record.data.hostelName
			}else{
				return value;
			}                        
		}
	},{
		header : getCommonTranslation('PROVIDER_ADDRESS'),
		dataIndex : 'contactAddress',
		hidden:true,
		flex : 1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.accommodationProviderId)) {
				return record.data.accommodationProviderId.address
			}else{
				return value;
			}                         
		}
	},{
		header : getCommonTranslation('PROVIDER_CONTACT_DETAILS'),
		dataIndex : 'contactNumber',
		flex : 1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.accommodationProviderId)) {
				if(!isNullOrEmpty(record.data.accommodationProviderId.mobileNo)){
					return record.data.accommodationProviderId.mobileCountryCode+ "-" + record.data.accommodationProviderId.mobileNo;
				}else{
					return record.data.accommodationProviderId.phoneCountryCode+ "-" + record.data.accommodationProviderId.phoneNo;
				}
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('COST'),
		dataIndex : 'cost',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('DIRECT_PAYMENT'),
		dataIndex : 'directPayment',
		hidden:true,
		flex : 1,
		renderer: function(value, metadata, record) {
			if(!isNullOrEmpty(value)) {
				if(value) {
					return getCommonTranslation('YES');
				}
				else {
					return getCommonTranslation('NO');
				}
			}else{	
				return "";
			}
		}
	},{
		header : getCommonTranslation('LEASE_AGREEMENT'),
		dataIndex : 'leaseAgreement',
		hidden:true,
		flex : 1,
		renderer: function(value, metadata, record) {
			if(!isNullOrEmpty(record.data.leaseAgreement)) {
				var pathSplit=record.data.leaseAgreement.split('/');
				var documentName=pathSplit[2];
				return '<a href=#>'+documentName+'<a>';
			}else{	
				return "";
			}
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.personalinfo.LivingArrangementGridStore');
	}
});