/**
 * @author sachin.bangar
 * Photo upload form for applicant/student/faculty
 */
Ext.define('Academia.view.personinfo.common.personalinfo.PhotoUploadForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.photouploadform',
    border: false,
    frame: false,
    cls: 'panelNoSpace',
    plugins: "formlabelrequired",
    defaults: {
        labelAlign: 'top',
        width: 256
    },
    items: [{
        xtype: 'filefield',
        fieldLabel: getPersonModuleTranslation('UPLOAD_LOGO'),
        buttonText: getPersonModuleTranslation('UPLOAD'),
        itemId: 'photoFileImage',
        ui: 'CustomBtnSubmit',
        name: 'file',
        cls:'CustomBtnSubmitToolbaar',
        style:{
    		marginTop:'-3px !important'
    	}
    }, {
    	xtype: 'button',
    	text: '',
    	itemId: 'evidenceLink',
    	hidden: true,
    	cls: 'hyperlinkBtn CustomBtnSubmitToolbaar',
    	handler: function(btn) {
    		var a = document.createElement('a');
			a.href = btn.href;
			var fileExtension = btn.fileExtension;
			a.download = btn.text.replaceAll(" ","_")+"."+fileExtension;
			document.body.appendChild(a);
			a.click();
			document.body.removeChild(a);
    	}
    }]
});