/**
 * @author sachin.bangar
 * Sibling Form
 */
Ext.define('Academia.view.personinfo.common.personalinfo.SiblingForm', {
    //extend: 'Ext.form.Panel',
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.siblingform',
	cls: 'sibling-form',
    border: false,
    frame: false,
    plugins: "formlabelrequired",
    relatedPerson: null,
    relatedPersonUserId:null,
    getRelatedPerson: function() {
        return this.relatedPerson;
    },
    setRelatedPerson: function(relatedPerson) {
    	this.relatedPerson = relatedPerson;
    },
    getRelatedPersonUserId: function() {
        return this.relatedPersonUserId;
    },
    setRelatedPersonUserId: function(relatedPersonUserId) {
    	this.relatedPersonUserId = relatedPersonUserId;
    },
    items: [{
        xtype: 'hidden',
        itemId: 'sibling_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        itemId: 'sibling_version_field',
        name: 'version'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        itemId: 'relationShipItemField',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('RELATIONSHIP'),
            name: 'relationship',
            valueField: 'name',
            displayField: 'value',
            itemId: 'relationShipField',
            store: 'common.RelationshipStore',
            editable: false,
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        itemId: 'siblingIdSearchItemField',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
          /*  xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('SIBLING_STUDENT_ID'),
            itemId: 'siblingStudentId',
            name: 'studentCode',
            allowBlank: false*/
			xtype: 'customcombobox',
			name: 'studentCode',
			itemId: 'siblingStudentId',
			fieldLabel: getPersonModuleTranslation('SIBLING_STUDENT_ID'),
			//store: 'feeandpayment.managebill.Student',
			//store: Ext.create('Academia.store.feeandpayment.managebill.Student'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listeners: {
				render: function(combo) {
                    var store = Ext.create('Academia.store.feeandpayment.managebill.Student');
                    combo.bindStore(store);
                }
			},
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
            
        },{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            ui: 'CustomBtnThird',
            scale: CONSTANTS.BUTTONSIZE,
            cls: 'btn-with-no-icon'
        }]
    }, {
    	xtype : 'form',
    	itemId : 'siblingInfoItemField',
    	margin : '0px',
    	hidden:true,
    	items : [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'nestedJsonCombo',
                fieldLabel: getCommonTranslation('SALUTATION'),
                itemId: 'salutationItemId',
                name: 'salutation',
                store: 'common.SalutationStore',
                valueField: 'id',
                displayField: 'salutationName',
                allowBlank: true,
                editable: false,
                hidden:true
            }, {
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
                name: 'firstName',
                itemId: 'firstName',
                readOnly: true,
                editable: false,
                disabled: true,
            },{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('MIDDLE_NAME'),
                readOnly: true,
                name: 'middleName',
                itemId: 'middleName',
                disabled: true
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('LAST_NAME'),
                name: 'lastName',
                readOnly: true,
                itemId: 'lastName',
                //allowBlank: false
                disabled: true
            },{
                xtype: 'customcombobox',
                itemId: 'genderCombo',
                fieldLabel: getCommonTranslation('GENDER'),
                name: 'gender',
                valueField: 'id',
                displayField: 'value',
                store: Ext.create('Academia.store.common.GenderTypeStore'),
                editable: false,
                allowBlank: false,
                queryMode: 'remote',
                disabled: true,
                listeners: {
                	render : function(combo){
                		var store = combo.getStore();
                		store.load();
                	}
                }
            }]
        }/*, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [ {
                xtype: 'datefield',
                fieldLabel: getPersonModuleTranslation('DATE_OF_BIRTH'),
                name: 'birthDate',
                submitFormat: CONSTANTS.DATE_FORMAT,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
                allowBlank: false,
                readOnly: true,
                maxValue: new Date()
            }]
        }*/, {
    		xtype: 'fieldcontainer',
    	    width: 'auto',
    	    itemId: 'emailFieldContainer',
    	    defaults: {
    	    	labelAlign: 'top',
    	    	width: 256
    	    },
    	    layout: {
    		type: 'hbox'
    	    },
    	    items: [{
                xtype: 'datefield',
                fieldLabel: getPersonModuleTranslation('DATE_OF_BIRTH'),
                name: 'birthDate',
                itemId: 'birthDate',
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
                allowBlank: false,
                readOnly: true,
                maxValue: new Date(),
                disabled: true
            },{
                		xtype : 'textfield',
                		fieldLabel : getCommonTranslation('ADDRESS_PRIMARY_EMAIL'),
                		name : 'emailId',
                		itemId : 'emailId',
                		vtype: 'email',
                		readOnly: true,
                        editable: false,
                        disabled: true
//                		allowBlank: false
                	/*}, {
                		xtype : 'textfield',
                		fieldLabel : getCommonTranslation('ADDRESS_SECONDARY_EMAIL'),
                		name : 'alternateEmailId',
                		vtype: 'email',
                		allowBlank: true*/
                	}]
    	}, {
    		xtype: 'fieldset',
    		itemId : 'contactFieldSet',
    		defaults: {
    			labelAlign: 'top'
    		},
    		style: {
    			marginTop: '30px !important',
				marginLeft:'-5px'
    		},
    		title: getAdmissionTranslation('CONTACT_INFORMATION'), // Contact Information
    		items: [{
    			html: '<i>'+getAdmissionTranslation('ENTER_ANY_ONE_CONTACT_Details')+'</i>'+'<span class="required"></span>',
    			margin: 0, marginLeft:'-19px'
    		},{
	    	xtype: 'fieldcontainer',
		    width: 'auto',
			itemId: 'cellFieldContainer',
			labelAlign: 'top',
	    	fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
	    	defaults: {
				enforceMaxLength : true,
				width: 256
    		},
    		layout : {
    			type : 'hbox'
    		},
    		items : [ {
    			xtype : 'customcombobox',
    			name : 'mobileCountryCode',
    			itemId : 'cellCountryCode',
    			valueField : 'isdCode',
    			displayField : 'isdCode',
    			store:'common.CountryStore',
    			queryMode: 'local',
    			triggerAction : 'all',
    			editable : false,
    			width: 108,
    			readOnly: true,
                editable: false,
                disabled: true
    		}, {
    			xtype : 'numberfield',
    			name : 'mobileNumber',
    			itemId : 'mobileNumber',
				minLength: 6,
				maxLength: 11,
    			// To Remove spinner buttons, and arrow key and mouse wheel listeners
    	        hideTrigger: true,
    	        keyNavEnabled: false,
    	        mouseWheelEnabled: false,
    	        allowExponential:false,
    	        readOnly: true,
                editable: false,
                disabled: true
    		} ]
    		}]
    	},{
    		xtype: 'fieldcontainer',
    	    width: 'auto',
    		labelAlign: 'top',
    		fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),	
    		itemId: 'phoneFieldContainer',
    		//allowBlank:false,
    		layout : {
    			type : 'hbox'
    		},
    		defaults: {
    			enforceMaxLength : true,
    			labelAlign: 'top',
    			width: 256
    			//cls:'inputInRow'
    		},
    		items : [ {
    			xtype : 'customcombobox',
    			hiddenName : 'phoneNumber1',
    			valueField : 'isdCode',
    			displayField : 'isdCode',
    			store:'common.CountryStore',
    			queryMode: 'local',
    			triggerAction : 'all',
    			name : 'phoneCountryCode',
    			itemId : 'phoneCountryCode',
    			editable : false,			
    			width: 108,
    			disabled: true
    		}, {
    			xtype : 'numberfield',
    			name : 'AreaCode',
    			name : 'phoneAreaCode',
    			itemId : 'phoneAreaCode',
    			width: 108,
    			maxLength: 5,
    			// To Remove spinner buttons, and arrow key and mouse wheel listeners
    	        hideTrigger: true,
    	        keyNavEnabled: false,
    	        mouseWheelEnabled: false,
    	        allowExponential:false,
    	        readOnly: true,
                editable: false,
                disabled: true
    		}, {
    			xtype : 'numberfield',
    			itemId : 'phoneNoField',
    			name : 'phoneNo',
    			//maxLength: 10,
    			// To Remove spinner buttons, and arrow key and mouse wheel listeners
    	        hideTrigger: true,
    	        keyNavEnabled: false,
    	        mouseWheelEnabled: false,
    	        allowExponential:false,
    	        readOnly: true,
                editable: false,
                disabled: true
    		} ]
    	}
        
        
        /*, {
            xtype: 'fieldcontainer',
            itemId : 'siblingEmailField',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'textfield',
                itemId : 'primaryeEmailId',
                fieldLabel: getPersonModuleTranslation('EMAIL_ID'),
                name: 'primaryeEmailId',
                
                vtype: 'email',
                allowBlank: false
            }, {
                xtype: 'filefield',
                
                fieldLabel: getPersonModuleTranslation('PHOTO'),
                buttonText: getPersonModuleTranslation('UPLOAD'),
                itemId: 'photoFileImage',
                ui: 'CustomBtnSubmit',
                name: 'photoUrl'
        	}]
        }, {
            xtype: 'fieldcontainer',
            itemId : 'siblingMobileField',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                name: 'cellCountryCode',
                itemId: 'cellCountryCode',
                fieldLabel: getPersonModuleTranslation('ADDRESS_MOBILE_NO'),
                valueField: 'isdCode',
                displayField: 'isdCode',
                store: 'common.CountryStore',
                triggerAction: 'all',
                allowBlank: false,
                editable: false,
                width: 108
            }, {
                xtype: 'numberfield',
                itemId: 'cellNo',
                name: 'cellNo',
				minLength: 6,
				maxLength: 11,
                style: {
                    marginTop: '28px'
                },
                hideTrigger: true,
                keyNavEnabled: false,
                allowBlank: false,
                mouseWheelEnabled: false
            }]
        }*/]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});