/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.personinfo.common.personalinfo.StudentJourneyCoreERPGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentjourneycoreerpgrid',
	isGridConfigurable: true,
	enableColumnHide: false,
	height:600,
	autoScroll:false,
	title: getCommonTranslation('STUDENT_JOURNEY'),
	cls: 'studentjourneycoreerpgridCls',
	border: true,
	viewConfig: {
		stripeRows: true,
		rowTpl: [
			'{%',
			'var dataRowCls = values.recordIndex === -1 ? "" : " ' + Ext.baseCSSPrefix + 'grid-data-row";',
			'%}',
			'<tr role="row" {[values.rowId ? ("id=\\"" + values.rowId + "\\"") : ""]} ',
			'data-boundView="{view.id}" ',
			'data-recordId="{record.internalId}" ',
			'data-recordIndex="{recordIndex}" ',
			'class="{[values.itemClasses.join(" ")]} {[values.rowClasses.join(" ")]}{[dataRowCls]}" ',
			'{rowAttr:attributes} tabIndex="-1">',
			'<tpl for="columns">' +
			'{%',
			'parent.view ? parent.view.renderCell(values, parent.record, parent.recordIndex, xindex - 1, out, parent) : ""',
			'%}',
			'</tpl>',
			'</tr>',
			{
				priority: 0
			}
			],
	},
	style:{ 
		marginLeft:'0px !important'
	},
	tbar: [{
		xtype: 'button',
		itemId: 'modifyEnrollmentBtnItemId',
		text: getCommonTranslation('MODIFY_ENROLLMENT'),
		disabled: true
	},{
		xtype: 'button',
		itemId: 'changeProgressionStatusId',
		text: getCommonTranslation('CHANGE_PROGRESSION_STATUS')
		//ui: 'CustomBtnSubmit',
		//scale: CONSTANTS.BUTTONSIZE,
	},
	{
		xtype : 'splitbutton',
        itemId:'spBtnMoreActionsSJ',
        text : getProgramandcourseTranslation('STUDENT_JOURNEY_MORE_ACTION'),
        menu:[{
            text:getProgramandcourseTranslation('STUDENT_JOURNEY_ADD_ENROLLMENT'),
            itemId:'addEnrollmentSJ',
            value :'ADD_ENROLLMENT',
            disabled: true
        },{
        	text : getProgramandcourseTranslation('STUDENT_JOURNEY_REMOVE_ENROLLMENT'),
        	itemId:'removeEnrollmentSJ',
            disabled: true
        },
        {
        	text : getProgramandcourseTranslation('ADD_ENROLLMENT_FOR_THE_NEXT_LINE'),
        	itemId:'addEnrollmentForLastLine',
            disabled: true
        }],
        listeners: {click: function() {this.showMenu();}}	
		},

		{
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),  
			itemId: 'cancelButtonId',  
			disabled: true 
		},
	{
		xtype: 'button',
		itemId: 'btnRefresh',
		cls: 'CustomToolbarBtnExport',
		iconCls:'gridRefreshBtnIcon',
		tooltip :getCommonTranslation('CLICK_TO_REFRESH'),
		icon: 'resources/images/icon-refresh.svg'
	}],
	enableColumnHide: false,
	columns: [{
		header: getCommonTranslation('ACADEMIC_TERM'),
		dataIndex: 'academicTermCode',
		sortable: false,
		flex: .15,
		getEditor: function(record){
			return Ext.create('Ext.grid.CellEditor', {
				field: Ext.create( 'Academia.utilities.ux.CustomComboBox', {
					name:'academicTermId',
					itemId:'academicTermCode',
					store: Ext.create('Academia.store.common.AcademicTermStoreByAdmId', {
                    listeners: {
                        beforeload: function(store, operation, eOpts) {
                            var admissionId = record.get('admissionId'); 
                            if (admissionId) {
                                store.getProxy().extraParams = store.getProxy().extraParams || {};
                                store.getProxy().extraParams.admissionId = admissionId;
                            }
                        }
                    }
                }),
					valueField:'value',
					displayField:'value',
					editable:true,
					  listeners: {
                    select: function(combo, records, eOpts) {
                        var selectedRecord = records[0];
                        record.set('academicTermId', selectedRecord.get('id'));
                        record.set('academicTermSeq', selectedRecord.get('sequence'));
                    }
                }
				})
			});
		}
	},
	{
        header: getCommonTranslation('PERIOD_STATUS'),
        dataIndex: 'periodStatus',
        sortable: false,
        flex: .2,
        /*editor: {
			xtype: 'customcombobox',
			name:'periodStatus',
			itemId:'periodStatus',
			store:'personinfo.common.personalinfo.StudentJourneyPeriodStatusStore',
			valueField:'id',
			displayField:'value',
			editable:false
		},*/
		renderer:function(val,rec){

			if(rec.record.data.resultStatus == "Exempt"){
        		rec.tdCls = 'hideGridDataCls';
        	}

			if(isNullOrEmpty(val)){
				return "";
				//rec.tdCls = 'gridInputCustomStyle'; 
				//return getExaminationTranslation('CLICK_TO_SELECT');
			}else{
				if(rec.record.data.resultStatus == "Suspended" || rec.record.data.resultStatus.indexOf("Suspended")!=-1){
					return "Suspended";
				}else if(rec.record.data.periodStatus == 'ADD_ENROLLMENT'){
				     return getProgramandcourseTranslation('STUDENT_JOURNEY_ADD_ENROLLMENT'); 	
				}else{
				return getCommonTranslation(rec.record.data.periodStatus);
				}
			}
		}
    },
	{
		header: getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academicLocationName',
		sortable: false,
		flex: .2,
		editor: {
			xtype: 'customcombobox',
			name:'alName',
			itemId:'alName',
			store:'common.AcademyLocationNameSeparated',
			valueField:'value',
			displayField:'value',
			editable:false
		},
		renderer:function(val,rec){
			if(rec.record.data.resultStatus == "Exempt"){
				rec.tdCls = 'hideGridDataCls';
			}
			var alStore = Ext.getStore('common.AcademyLocationNameSeparated');
			var recIdx = alStore.findExact('value',val);
			if(recIdx != -1){
				var alRecord = alStore.getAt(recIdx);
				setTimeout(function(){
					rec.record.set('academicLocationId',alRecord.data.id);
				},1);
			}
			return val;
		}
	},
	/*{
		header: getCommonTranslation('CAMPUS'),
		dataIndex: 'campusName',
		sortable: false,
		flex: .15,
		editor: false,
		renderer:function(val,rec){
			if(rec.record.data.resultStatus == "Exempt"){
				rec.tdCls = 'hideGridDataCls';
			}
			return val;
		}
	},*/
	{
		header: getCommonTranslation('CAMPUS'),
		dataIndex: 'campusName',
		sortable: false,
		flex: .15,
		getEditor: function(record){
			return Ext.create('Ext.grid.CellEditor', {
				field: Ext.create( 'Academia.utilities.ux.CustomComboBox', {
					name:'campusName',
					itemId:'campusName',
					store:Ext.create('Academia.store.program.ProgramCampusStore',{
						listeners:{
							beforeload: function(store){
								var studentjourneycoreerpgrid = this$.getActiveTabfromContentPanel().down('studentjourneycoreerpgrid');
								var id = studentjourneycoreerpgrid.getSelectionModel().getSelection()[0].data.id;
								var periodId = studentjourneycoreerpgrid.getSelectionModel().getSelection()[0].data.periodId;
								var alId = studentjourneycoreerpgrid.getSelectionModel().getSelection()[0].data.academicLocationId;
								store.getProxy().extraParams = {
									academyLocationId:alId,
								//	periodId : periodId
								}
							}
						}
					}),
					valueField:'value',
					displayField:'value',
					editable:false
				})
			});
		}
	}, {
		header: getCommonTranslation('PROGRAM_NAME'),
		dataIndex: 'programName',
		sortable: false,
		flex: .25,
		getEditor: function(record){
			return Ext.create('Ext.grid.CellEditor', {
				field: Ext.create( 'Academia.utilities.ux.CustomComboBox', {
					name:'programName',
					itemId:'programName',
					store:Ext.create('Academia.store.facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore',{
						listeners:{
							beforeload: function(store){
								var studentjourneycoreerpgrid = this$.getActiveTabfromContentPanel().down('studentjourneycoreerpgrid');
								var alId = studentjourneycoreerpgrid.getSelectionModel().getSelection()[0].data.academicLocationId;
								store.getProxy().extraParams = {
									academyLocationIds: alId
								}
							}
						}
					}),
					valueField:'value',
					displayField:'value',
					editable:false
				})
			});
		},
		renderer:function(val,rec){
			var programStore = this.columns[rec.cellIndex].getEditor().items.items[0].getStore();
			var recIdx = programStore.findExact('value',val);
			if(recIdx != -1){
				var progRecord = programStore.getAt(recIdx);
				rec.record.set('programId',progRecord.data.id);
			}
			return val;
		}
	}, {
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		sortable: false,
		flex: .15,
		getEditor: function(record){
			return Ext.create('Ext.grid.CellEditor', {
				field: Ext.create( 'Academia.utilities.ux.CustomComboBox', {
					name:'batchName',
					itemId:'batchName',
					store:Ext.create('Academia.store.common.BatchesByProgramId',{
						listeners:{
							beforeload: function(store){
								var studentjourneycoreerpgrid = this$.getActiveTabfromContentPanel().down('studentjourneycoreerpgrid');
								var programId = studentjourneycoreerpgrid.getSelectionModel().getSelection()[0].data.programId;
								store.getProxy().extraParams = {
									id: programId
								}
							}
						}
					}),
					valueField:'value',
					displayField:'value',
					editable:false
				})
			});
		},
		renderer:function(val,rec){
			if(rec.record.data.periodStatus == "LEAVE_OF_ABSENCE"){
				rec.tdCls = 'hideGridDataCls';
			}
			return val;
		}
	}, {
		header: getCommonTranslation('PERIOD_NAME'),
		dataIndex: 'periodName',
		sortable: false,
		flex: .15,
		getEditor: function(record){
			return Ext.create('Ext.grid.CellEditor', {
				field: Ext.create( 'Academia.utilities.ux.CustomComboBox', {
					name:'periodName',
					itemId:'periodName',
					store:Ext.create('Academia.store.facilitiesresources.resourcebooking.CurrentAndFuturePeriodStore',{
						listeners:{
							beforeload: function(store){
								var studentjourneycoreerpgrid = this$.getActiveTabfromContentPanel().down('studentjourneycoreerpgrid');
								var id = studentjourneycoreerpgrid.getSelectionModel().getSelection()[0].data.id;
								var admissionId = studentjourneycoreerpgrid.getSelectionModel().getSelection()[0].data.admissionId;
								var batchId = studentjourneycoreerpgrid.getSelectionModel().getSelection()[0].data.batchId;
								var programPeriodSeq = studentjourneycoreerpgrid.getSelectionModel().getSelection()[0].data.programPeriodSeq;
								var isMoreActionButtonOperation = false;
								var isOutOfSequence = false;
						        if(record.data.periodStatus == "OUT_OF_SEQUENCE"){
									isOutOfSequence = true;
								}
						        if(record.data.periodStatus == "ADD_ENROLLMENT" ||  record.data.periodStatus == getProgramandcourseTranslation('STUDENT_JOURNEY_ADD_ENROLLMENT')){
							    isMoreActionButtonOperation = true;
						        }
								store.getProxy().extraParams = {
									id:id,
									admissionId : admissionId,
									batchId: batchId,
									programPeriodSeq:programPeriodSeq,
									isMoreActionButtonOperation : isMoreActionButtonOperation,
									isOutOfSequence : isOutOfSequence
								}
							},
						}
					}),
					valueField:'value',
					displayField:'value',
					editable:false
				})
			});
		},
		renderer:function(val,rec){
			if(rec.record.data.periodStatus == "LEAVE_OF_ABSENCE"){
				rec.tdCls = 'hideGridDataCls';
			}
			return val;
		}
	}, {
		header: getCommonTranslation('SEAT_TYPE'),
		dataIndex: 'seatType',
		sortable: false,
		flex: .15,
		getEditor: function(record){
			return Ext.create('Ext.grid.CellEditor', {
				field: Ext.create( 'Academia.utilities.ux.CustomComboBox', {
					name:'seatTypeName',
					itemId:'seatTypeName',
					store:Ext.create('Academia.store.facilitiesresources.resourcebooking.SeatTypeByBatchStore',{
						listeners:{
							beforeload: function(store){
								var studentjourneycoreerpgrid = this$.getActiveTabfromContentPanel().down('studentjourneycoreerpgrid');
								var batchId = studentjourneycoreerpgrid.getSelectionModel().getSelection()[0].data.batchId;
								if(batchId){
									store.getProxy().extraParams = {
										batchId: batchId
									}
								}
								else{
									store.removeAll();
									return false;
								}
							}
						}
					}),
					valueField:'value',
					displayField:'value',
					editable:false
				})
			});
		},
		renderer:function(val,rec){
			if(rec.record.data.periodStatus == "LEAVE_OF_ABSENCE"){
				rec.tdCls = 'hideGridDataCls';
			}
			var seatTypeStore = this.columns[rec.cellIndex].getEditor().items.items[0].getStore();
			var recIdx = seatTypeStore.findExact('value',val);
			if(recIdx != -1){
				var stRecord = seatTypeStore.getAt(recIdx);
				rec.record.set('seatTypeId',stRecord.data.id);
			}
			return val;
		}
	}, {
		header: getCommonTranslation('ENROLLMENT_STATUS'),
		dataIndex: 'resultStatus',
		sortable: false,
		flex: .15,
		renderer: function(val, rec) {
        if (val && val.length > 30) {
            return '<div data-qtip="' + val + '">' + val.substring(0, 30) + '...</div>';
        }
        return val;
    }
	}, {
		header: getCommonTranslation('PROGRESSION_STATUS'),
		dataIndex: 'progressionStatus',
		sortable: false,
		flex: .15,
		/*renderer:function(val,rec){
        	if(rec.record.data.periodStatus == "LEAVE_OF_ABSENCE"){
        		rec.tdCls = 'hideGridDataCls';
        	}
        	return val;
        }*/
	},{
		header: getCommonTranslation('LIKELY_TO_RETURN'),
		dataIndex: 'likelytoReturn',
		sortable: false,
		flex: .15
	},{
		header: getCommonTranslation('ADDED_STATUS'),
		dataIndex: 'addedStatus',
		sortable: false,
		flex:0.15,
		editor: {
			xtype: 'multiselectcombofield',
			name:'addedStatus',
			itemId:'addedStatus',
			store:'personinfo.common.personalinfo.StudentJourneyAddedStatusStore',
			valueField:'id',
			displayField:'value',
			editable:false,
			width:'100%',
			height: 40,
			style:{
				width: '100% !important;',
				'max-width': '100% !important;',
				height: '40px !important;',
				'max-height': '40px !important;'
			},
			listConfig: {
				cls: 'addedStatusBoundList',
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			},
			listeners:{
				afterrender: function(cmp){
					var column = cmp.up();
					var columnEl = column.boundEl.el;
					var columnWidth = columnEl.getWidth();
					setTimeout(function(){
						cmp.el.dom.style.width = columnWidth+'px';
					},500);
				}
			}
		},
		renderer:function(val, rec){
			if(isNullOrEmpty(val)){
				rec.tdCls = 'gridInputCustomStyle'; 
				return "";
			}else{
				if(rec.record.data.addedStatus && rec.record.data.addedStatus.length){
					if(typeof rec.record.data.addedStatus == "object" && !isNullOrEmpty(rec.record.data.addedStatus[0])){
						return Ext.Array.pluck(Ext.Array.pluck(rec.record.data.addedStatus,'data'),'value').join();
					}
					else{
						return rec.record.data.addedStatus;
					}
				}
				else{
					return "";
				}
			}
		}
	},{
		header: getCommonTranslation('STUDENT_JOURNEY_ATTRIBUTE_VALUE'),
		dataIndex: 'attributeValue',
		sortable: false,
		flex: .15
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(ed,e){
				var thisGrid = ed.view.up('grid');
				var cellDataIndex = ed.view.getGridColumns()[e.colIdx].dataIndex;
				var selectedRecord = thisGrid.getSelectionModel().getSelection()[0];
				var selectedRow = thisGrid.view.getNode(selectedRecord);
				if(selectedRow.classList.contains("fadeOutRowCls")){
					return false;
				}
				if(e.record.data.resultStatus == "Completed" || e.record.data.resultStatus == "Exempt"){
					return false;
				}
				//-- START - MANAGING MULTIPLE PROGRAMS CASE
				var isPreviousProgramCompleted = true;
				var allRecords = thisGrid.store.getRange();
				Ext.each(allRecords, function(cAllRecords){
					if(cAllRecords.data.programJourneySeq < e.record.data.programJourneySeq){
						if(cAllRecords.data.resultStatus == "Completed" || cAllRecords.data.resultStatus == "Exempt"){
							//-- Do nothing
						}
						else{
							isPreviousProgramCompleted = false;
						}
					}
				});
				if(isPreviousProgramCompleted == false && selectedRecord.data.resultStatus != 'Pre-Enrolled' && selectedRecord.data.resultStatus != 'Enrolled'){
					return false;
				}
				//-- END - MANAGING MULTIPLE PROGRAMS CASE

				if(cellDataIndex == 'academicTermCode'){ 
					if(!isNullOrEmpty(e.record.data.isAcademicTermEditable) && e.record.data.isAcademicTermEditable == true && 
							!isNullOrEmpty(e.record.data.isperiodEditable) && e.record.data.isperiodEditable == true){
						return true;
					}
					else{
						return false;
					}
				}
				if(cellDataIndex == 'periodName'){ 
					if(!isNullOrEmpty(e.record.data.isAcademicTermEditable) && e.record.data.isAcademicTermEditable == true){
						return true;
					}
					else{
						return false;
					}
				}
				if(cellDataIndex == 'addedStatus'){ //ADDED_STATUS
					if(!isNullOrEmpty(e.record.data.addedStatus) && e.record.data.addedStatus.length){
						if(typeof e.record.data.addedStatus == "object"){
							var addedStatusAr = Ext.Array.pluck(Ext.Array.pluck(e.record.data.addedStatus,'data'),'id');
						}
						else{
							var addedStatusAr = e.record.data.addedStatus;
						}
						e.column.getEditor().store.load({
							callback: function(){
								e.column.getEditor().setValue(addedStatusAr);
							}
						});
					}
					return true;
				}
				else if(cellDataIndex == 'academicLocationName'){ //ACADEMY_LOCATION
					if (e.record.modified && e.record.modified.periodStatus && (e.record.data.periodStatus == "EXCHANGE_SEMESTER" || e.record.data.periodStatus == "PROGRAM_TRANSFER")){
						return true;
					}
					else{
						return false;
					}
				}
				else if(cellDataIndex == 'campusName'){ //CAMPUS
					//return false;
					if (e.record.data.isAcademicTermEditable == true){
						return false;
					}
					else{
						var currentPeriodId = e.record.data.periodId;
						var academicLocationId = e.record.data.academicLocationId;
						var campusNameStore = ed.grid.columns[e.colIdx].getEditor().items.items[0].getStore();
						if(campusNameStore.getProxy().extraParams.periodId != currentPeriodId){
							campusNameStore.getProxy().extraParams = {
								academyLocationId: academicLocationId,
								periodId:currentPeriodId
							};
						}
						return true;
					}
				}
				else if(cellDataIndex == 'programName'){ //PROGRAM
					if (e.record.modified && e.record.modified.periodStatus && (e.record.data.periodStatus == "EXCHANGE_SEMESTER" || e.record.data.periodStatus == "PROGRAM_TRANSFER")){
						//debugger;
						var currentALId = e.record.data.academicLocationId;
						var programStore = ed.grid.columns[e.colIdx].getEditor().items.items[0].getStore();
						if(programStore.getProxy().extraParams.academyLocationIds != currentALId){
							programStore.getProxy().extraParams = {
								academyLocationIds: currentALId
							};
						}
						return true;
					}
					else{
						return false;
					}
				}
				else if(cellDataIndex == 'seatType'){
					if (e.record.modified && e.record.modified.periodStatus && (e.record.data.periodStatus == "EXCHANGE_SEMESTER" || e.record.data.periodStatus == "PROGRAM_TRANSFER")){
						var currentBatchId = e.record.data.batchId;
						var seatTypeStore = ed.grid.columns[e.colIdx].getEditor().items.items[0].getStore();
						if(seatTypeStore.getProxy().extraParams.batchId != currentBatchId){
							seatTypeStore.getProxy().extraParams = {
								batchId: currentBatchId
							};
						}
						return true;
					}
					else{
						return false;
					}
				}
				else if(cellDataIndex == 'periodName'){
					if (e.record.modified && e.record.modified.periodStatus && (e.record.data.periodStatus == "OUT_OF_SEQUENCE" || e.record.data.periodStatus == "PROGRAM_TRANSFER" ||e.record.data.periodStatus == "ADD_ENROLLMENT")
					|| e.record.data.periodStatus == getProgramandcourseTranslation('STUDENT_JOURNEY_ADD_ENROLLMENT')){
						var currentBatchId = e.record.data.batchId;
						var programPeriodSeq = e.record.data.programPeriodSeq;
						var isMoreActionButtonOperation = false;
						var admissionId = e.record.data.admissionId;
						if(e.record.data.periodStatus == "ADD_ENROLLMENT"  ||  e.record.data.periodStatus == getProgramandcourseTranslation('STUDENT_JOURNEY_ADD_ENROLLMENT')){
							isMoreActionButtonOperation = true;
						}
						var periodStore = ed.grid.columns[e.colIdx].getEditor().items.items[0].getStore();
						if(periodStore.getProxy().extraParams.batchId != currentBatchId){
							periodStore.getProxy().extraParams = {
								id : e.record.data.id,
								batchId: currentBatchId,
								programPeriodSeq:programPeriodSeq,
								admissionId : admissionId,
								isMoreActionButtonOperation :isMoreActionButtonOperation
							};
						}
						return true;
					}
					else{
						return false;
					}
				}
				else if(cellDataIndex == 'batchName'){
					if (e.record.modified && e.record.modified.periodStatus && (e.record.data.periodStatus == "PROGRAM_TRANSFER")){
						var currentProgramId = e.record.data.programId;
						var batchStore = ed.grid.columns[e.colIdx].getEditor().items.items[0].getStore();
						if(batchStore.getProxy().extraParams.id != currentProgramId){
							batchStore.getProxy().extraParams = {
								id: currentProgramId
							};
						}
						return true;
					}
					else{
						return false;
					}
				}
			}
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store
		});
		this$.addExportToolBarItems(this$, false);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.personalinfo.StudentJourneyStore');
	}
});
