/**
 * @Author Harshit patidar 
 */
Ext.define('Academia.view.personinfo.common.personalinfo.StudentPassportDetailsForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.studentpassportdetailsform',
	border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
    items: [{
        xtype: 'hidden',
        itemId: 'Student_Passport_Details_hidden_field',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('PASSPORT_NUMBER'),
            itemId : "passportNumber",
            name: 'passportNumber',
            allowBlank: false,
            maxLength:30,
		},{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('PASSPORT_NAME'),
            itemId : "passportName",
            name: 'passportName',
            allowBlank: true,
            maxLength:100,
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
    		xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('COUNTRY_OF_ISSUE'),
    		itemId : 'countryOfIssue',
    		store:'common.CountryStore',
    		valueField : 'id',
    		displayField : 'countryName',
    		name : 'countryOfIssue',
			queryParam:'countryName', 
			forceSelection :true,
			editable : false,
			typeAhead : false,
			hideTrigger:false,
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{countryName}'  +
	                    '</div>';
	                }
	            }
    	},{
			xtype: 'datefield',
			fieldLabel: getCommonTranslation('PASSPORT_EXPIRATION_DATE'),
			itemId : "passportExpirationDate",
            name: 'passportExpirationDate',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype : 'daterange'
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
			xtype: 'datefield',
			fieldLabel: getCommonTranslation('FILE_MODIFIED_DATE'),
			itemId : "fileModifiedDate",
            name: 'fileModifiedDate',
            editable : false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype : 'daterange'
		},{
	    	xtype: 'checkboxfield',
			itemId : 'isPrimary',
			labelAlign: 'right',
			region: 'south',
			style:{marginTop:'25px'},
			boxLabel: getCommonTranslation('IS_PRIMARY'),
			name: 'isPrimary',
			checked:false,
			inputValue: true,
			uncheckedValue: false
	    }]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studentpassportdocumentgrid',
			itemId:'studentpassportdocumentgrid',
			minHeight: 0,
			cls: 'no-empty-placeholder-grid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studentpassporturlgrid',
			itemId:'studentpassporturlgrid',
			minHeight: 0,
			cls: 'no-empty-placeholder-grid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'applicantpassportdocumentgrid',
			itemId:'applicantpassportdocumentgrid',
			hidden:true,
			minHeight: 0,
			cls: 'no-empty-placeholder-grid',
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'applicantpassporturlgrid',
			itemId:'applicantpassporturlgrid',
			minHeight: 0,
			cls: 'no-empty-placeholder-grid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },{
			 xtype: 'button',
			 name: 'uploadPassportDoc',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadPassportDocItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		},{
			 xtype: 'button',
			 name: 'uploadPassportUrl',
			 text:getCommonTranslation('UPLOAD_URL'),
			 itemId: 'uploadPassportUrlItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
