/**
 * @Author Suraj Chouhan
 */
Ext.define('Academia.view.personinfo.common.personalinfo.VisaForm', {
//	extend: 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.visaform',
	border : false,
	frame : false,
	plugins: "formlabelrequired",
	items: [{
        xtype: 'hidden',
        itemId: 'visa_detail_hidden_field',
        name: 'id'
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 240
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'nestedJsonCombo',
    		fieldLabel: getPersonModuleTranslation('VISA_TYPE'),
    		store: 'personinfo.common.personalinfo.VisaTypeStore',
    		valueField: 'id',
    		displayField: 'value',
    		name: 'visaType',
    		itemId: 'visaTypeItemId',
    		allowBlank:true,
    		editable: false,
    		fourceSelection: true,
    	}, {

    		xtype : 'customcombobox',
    		fieldLabel : getPersonModuleTranslation('COUNTRY_OF_ISSUE'),
    		hiddenName : 'country',
    		itemId : 'countryOfIssueItemId',
    		store:'common.CountryStore',
    		valueField : 'id',
    		displayField : 'countryName',
    		name : 'countryOfIssue',
    		editable : false,
    		//valueNotFoundText:"",     
			queryParam:'countryName',   		        						
			forceSelection :true,
			typeAhead : false,
			minChars:3,
//			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			hideTrigger:false,
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{countryName}'  +
	                    '</div>';
	                }
	            }
    	
    	},{
    		xtype: 'nestedJsonCombo',
    		fieldLabel: getPersonModuleTranslation('VISA_STATUS'),
    		store: 'personinfo.common.personalinfo.VisaStatusStore',
    		valueField: 'id',
    		displayField: 'value',
    		name: 'visaStatus',
    		itemId: 'visaStatusItemId',
    		editable: false,
    		fourceSelection: true
    	}]
    }, {
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 240
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'datefield',
    		fieldLabel: getPersonModuleTranslation('VISA_APPLIED_DATE'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		vtype : 'daterange',
    		name: 'visaAppliedDate',
    		itemId: 'visaAppliedDateItemId'
    	},{
    		xtype: 'datefield',
    		fieldLabel: getPersonModuleTranslation('VISA_ISSUED_DATE'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		vtype : 'daterange',
    		name: 'visaIssuedDate',
    		itemId: 'visaIssuedDateItemId'
    	},{
    		xtype: 'datefield',
    		fieldLabel: getPersonModuleTranslation('VISA_COLLECTED_DATE'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		vtype : 'daterange',
    		name: 'visaCollectedDate',
    		itemId: 'visaCollectedDateItemId'
    	}]

    }, {
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 240
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'datefield',
    		fieldLabel: getPersonModuleTranslation('VISA_EXPIRY_DATE'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		vtype : 'daterange',
    		name: 'visaExpiryDate',
    		itemId: 'visaExpiryDateItemId'
    	},{
    		xtype: 'datefield',
    		fieldLabel: getPersonModuleTranslation('DATE_OF_COUNTRY_ENTRY_ALLOWANCE'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		vtype : 'daterange',
    		name: 'dateOfCountryEntryAllowance',
    		itemId: 'dateCountryEntAllowanceItemId'
    	
    	
    	},{
    		xtype: 'datefield',
    		fieldLabel: getPersonModuleTranslation('VISA_CANCELLATION_DATE'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		vtype : 'daterange',
    		name: 'visaCancellationDate',
    		itemId: 'visaCancellationDateItemId'
    	}]

    },{

    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 240
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype : 'textareafield',
    		fieldLabel : getPersonModuleTranslation('REASON_FOR_A_VISA_BEING_REFUSED'),
    		name : 'reasonForVisaRefused',
    		itemId : 'reasonForVisaRefusedItemId',
    		width: 240,
    		allowBlank: true,
    		maxLength:500,
    		listener:{
    			blur:function(){}
    		}
    	},{
			xtype: 'checkboxfield',
			itemId : 'visaIsPrimaryItemId',
			labelAlign: 'right',
			region: 'south',
			boxLabel: getPersonModuleTranslation('IS_PRIMARY'),
			name: 'visaIsPrimary',
			hidden : false,
			checked:false,
			inputValue: true,
			uncheckedValue: false,
			style:{marginTop:'20px'}
		}]

    
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studentvisadocumentgrid',
			itemId:'studentvisadocumentgrid',
			minHeight: 0,
			cls: 'no-empty-placeholder-grid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studentvisaurlgrid',
			itemId:'studentvisaurlgrid',
			minHeight: 0,
			cls: 'no-empty-placeholder-grid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},,{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'applicantvisadocumentgrid',
			itemId:'applicantvisadocumentgrid',
			minHeight: 0,
			cls: 'no-empty-placeholder-grid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'applicantvisaurlgrid',
			itemId:'applicantvisaurlgrid',
			minHeight: 0,
			cls: 'no-empty-placeholder-grid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	}, {
    	xtype: 'fieldcontainer',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SUBMIT'),
    		itemId: 'submitButtonId',
    		buttonAlign: 'right',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	}, {
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		ui: 'CustomBtnCancel',
    		itemId: 'cancelButtonId',
    		scale: CONSTANTS.BUTTONSIZE
    	},{
			 xtype: 'button',
			 name: 'visaUploadFile',
			 text:getCommonTranslation('UPLOAD_DOCUMENT'),
			 itemId: 'visaUploadFileItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		},{
			 xtype: 'button',
			 name: 'visaUploadURL',
			 text:getCommonTranslation('UPLOAD_URL'),
			 itemId: 'visaUploadURLItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});