/**
 * @author priyanshi Sharma
 *
 */
Ext.define('Academia.view.personinfo.common.request.RequestPendingDocumentListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.requestpendingdocumentlistgrid',
	store :'personinfo.common.request.RequestPendingDocumentListGridStore',
	border: true,
//	autoScroll: true,
	height:'80%',
	frame:false,
	enableColumnHide :false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	title : getCommonTranslation('LIST_OF_DOCUMENTS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.common.request.RequestPendingDocumentListGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
	this.callParent(arguments);
	},
	
	tbar: [{
		xtype : 'button',
		itemId : 'downloadDocumentItemId',
		tooltip : getCommonTranslation('DOWNLOAD_ALL'),
		text : getCommonTranslation('DOWNLOAD_ALL'),
		formBind:true,
	}],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		align: 'left',
		flex: 0.5,
		renderer: function(value, metaData, record, rowIndex){
			return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
		}
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'documentName',
		flex:1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record)) {
				return "<a href='#'>"+record.data.value+"</a>";
			}
		}
	}]
});