/**
 * @author <a href="phool.gour@serosoft.in">Phool Singh  Gour</a>
 *
 */
Ext.define('Academia.view.personinfo.common.request.RequestRaisedHistoryDocumentListGrid', {
	extend: 'Ext.grid.Panel',
	alias : 'widget.requestraisedhistorydocumentlistgrid',
	store :'personinfo.common.request.ServiceRequestDocumentDocumentListStore',
	border: true,
	autoScroll: true,
	height:'80%',
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	title : getCommonTranslation('LIST_OF_DOCUMENTS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.common.request.ServiceRequestDocumentDocumentListStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	
	columns :[{
		header : getCommonTranslation('DOCUMENT_NAME'),
		dataIndex : 'name',
		flex:1,
		renderer:function(value,rec){
			if(value){
				return "<a href='#'>"+value+"</a>";
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_BY'),
		dataIndex : 'uploadedBy',
		flex:1,
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	}]
});