/**
 * Personal Information Form
 */
Ext.define('Academia.view.personinfo.faculty.EmployeePersonalInformationForm', {
	extend :'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.employeepersonalinformationform',
	padding: '15',
	margin: 0,
	autoScroll:true,
	cls:'x-form-fixed-footer-parent',
	//width:1000,
	plugins: "formlabelrequired",
	defaults: {
		labelAlign: 'top'
	},
	height:'auto',
	standardSubmit: false,
	initComponent: function() {
		var detailsArray = new Array();
		var itemsArray = new Array();
		this.getHiddenFormField(itemsArray);
		this.getFacultyAcademicFormField(detailsArray);
		this.getPersonalCommonFormField(itemsArray, this.personType, detailsArray);
		this.getFacultypersonalFormField(itemsArray);
		this.getContactDetailsFormField(itemsArray);
		this.getPersonalDetailFormExtSysRefField(itemsArray);
		this.getOtherFacultyDetailsFormField(itemsArray);
		this.getBankDetailFormField(itemsArray);
		this.getSaveFormField(itemsArray);
		var customFieldPosition=itemsArray.length-1;
		if(this.personType === 'FACULTY'){
			Ext.apply(this,{
				customFieldEntity:CONSTANTS.PERSON_CD,
				customFieldEntityType:CONSTANTS.EMPLOYEE_PERSON_CF_ENTITY_TYPE,
				columns:1,
				addPosition: customFieldPosition
			});
		}
		this.items = itemsArray;
		this.callParent(arguments);
	},
	getHiddenFormField: function(itemsArray) {
		itemsArray.push({
			xtype: 'hidden',
			itemId: 'user_Id',
			name: 'id'
		}, {
			xtype: 'hidden',
			itemId: 'user_version',
			name: 'version'
		}, {
			xtype: 'hidden',
			itemId: 'person_Id',
			name: 'personId'
		}, {
			xtype: 'hidden',
			itemId: 'person_version',
			name: 'personVersion'
		}, {
			xtype: 'hidden',
			itemId: 'isEmployeeOfOrganization_Id',
			name: 'isEmployeeOfOrganization'
		}, {
			xtype: 'hidden',
			name: 'bankDetailsId'
		}, {
			xtype: 'hidden',
			name: 'bankDetailsVersion'
		}, {
			xtype: 'hidden',
			name: 'phyId'
		}, {
			xtype: 'hidden',
			name: 'phyVersion'
		}, {
			xtype: 'hidden',
			itemId: 'checkboxDropdown',
			name: 'checkboxDropdown'
		});
		return itemsArray;
	},
	getFacultyAcademicFormField: function(itemsArray) {
		itemsArray.push({
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID'),
				itemId : 'personCodeField',
				name: 'code',
				readOnly: false,
				allowBlank: false
			}, {
				xtype: 'photouploadform',
				itemId: 'facultyPhotoUploadForm',
				name:'facultyPhotoUploadForm'
			}]
		});
		return itemsArray;
	},
	getFacultypersonalFormField: function(objArray) {
		objArray.push({
			xtype: 'fieldset',
			itemId: 'facultyDeptDetails',
			//style:{'padding':'0px !important','margin-top':'-14px !important','margin-left': '10px','margin-bottom':'35px'},
			items: [{ 
				xtype: 'fieldcontainer',
				allowBlank:false,
				layout : {
					type : 'hbox'
				},
				defaults: {
					labelAlign: 'top',
					width: 256
				},         	  
				items: [{
					xtype: 'nestedJsonCombo',
					fieldLabel: getPersonModuleTranslation('DESIGNATION'),
					store: 'common.DesignationTypeStore',
					valueField: 'id',
					displayField: 'value',        
					name : 'designation',
					//allowBlank: false,
					editable: false,
					triggerAcation: 'all',
					fourceSelection: true,
					hidden:true,
					itemId:'designationCombo',
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
							},
						}
					}
				}, {
					xtype: 'nestedJsonCombo',
					fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
					store: 'department.DepartmentComboStore',
					itemId : 'departmentCombo',
					valueField: 'id',
					displayField: 'name',     
					name : 'department',
					allowBlank: false,
					editable: false,
					triggerAcation: 'all',
					fourceSelection: true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
							},
						}
					}
				},{
					xtype: 'datefield',
					fieldLabel: getPersonModuleTranslation('DATE_OF_JOIN'),
					name: 'joiningDate',
					itemId :'startDate',
					vtype: 'daterange',
					endDateField: 'endDate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					allowBlank: false
				}]},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 256
					},
					items: [{
						xtype: 'numberfield',
						fieldLabel: getPersonModuleTranslation('YEAR_OF_EXPERIENCE_MONTHS'),
						allowBlank: true,
						minValue : 0,
						maxLength : 3,
						value : 0,
						decimalPrecision : 2,
						editable: false,
						readOnly: true,
						name: 'yearsOfExperience',
						itemId : 'yearsOfExperience'
					},{
						xtype: 'customcombobox',
						name:'leaveCategory',
						itemId:'leaveCategory',
						fieldLabel: getCommonTranslation('LEAVE_CATEGORY'),
						store:'securitysetup.LeaveCategorTypeStore',
						valueField: 'id',
						displayField: 'value',
						forceSelection: true,
						editable: false,
					}]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 256
					},
					items: [{
						xtype : 'textfield',
						fieldLabel : getPersonModuleTranslation('EXPERIENCE_YEAR'),
						width: 125,
						readOnly:true,
						name:'experienceInYear',
						itemId : 'experienceInYear',
					},{
						xtype : 'textfield',
						fieldLabel : getPersonModuleTranslation('EXPERIENCE_MONTH'),
						width: 125,
						readOnly:true,
						name:'experienceInMonth',
						itemId : 'experienceInMonth',
					}]
				}]});
		return objArray;
	},
	getPersonalCommonFormField: function(itemsArray, personType, detailsArray) {
		var objArray = new Array();
		for(var i = 0; i< detailsArray.length;i++){
			objArray.push(detailsArray[i]);
		}
		objArray.push({
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'nestedJsonCombo',
				fieldLabel: getCommonTranslation('SALUTATION'),
				itemId:'salutationId',
				name: 'salutation',
				store: 'common.SalutationStore',
				valueField: 'id',
				displayField: 'salutationName',
				allowBlank: false,
				editable: false
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
				name: 'firstName',
				itemId:'firstNameId',
				maxLength : 100,
				enforceMaxLength :true,
				allowBlank: false,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('FIRST_NAME_OTHER_LANGUAGE'),
				name: 'firstNameOtherLanguage',
				itemId:'firstNameOtherLnguageId',
				maxLength : 100,
				enforceMaxLength :true,
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('MIDDLE_NAME'),
				name: 'middleName',
				itemId:'middleNameId',
				maxLength : 53,
				enforceMaxLength :true,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('MIDDLE_NAME_OTHER_LANGUAGE'),
				name: 'middleNameOtherLanguage',
				itemId:'middleNameOtherLnguageId',
				maxLength : 53,
				enforceMaxLength :true,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('LAST_NAME'),
				name: 'lastName',
				itemId: 'lastNameId',
				maxLength : 100,
				enforceMaxLength :true,
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'textfield',
				fieldLabel:getPersonModuleTranslation('LAST_NAME_OTHER_LANGUAGE'),
				name: 'lastNameOtherLanguage',
				itemId: 'lastNameOtherLnguageId',
				maxLength : 100,
				enforceMaxLength :true,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('SHORT_NAME'),
				name: 'shortName',
				itemId: 'shortNameId',
				maxLength : 255,
				enforceMaxLength :true,
				allowBlank: false,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('SHORT_NAME_OTHER_LANGUAGE'),
				name: 'shortNameOtherLanguage',
				itemId: 'shortNameOtherLnguageId',
				maxLength : 255,
				enforceMaxLength :true,
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PERSON_INITIALS'),
				name: 'initials',
				itemId: 'initialsId',
				maxLength : 5,
				enforceMaxLength :true,
				allowBlank: true,
				stripCharsRe: /[^0-9a-zA-Z]/g,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PRINT_NAME'),
				minLength: 3,
				name: 'printName',
				itemId: 'printNameId',
				allowBlank: false
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PRINT_NAME_OTHER_LANGUAGE'),
				minLength: 3,
				name: 'printNameOtherLanguage',
				itemId: 'printNameOtherLnguageId',
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'nestedJsonCombo',
				fieldLabel: getCommonTranslation('GENDER'),
				itemId: 'genderId',
				name: 'genderCSM',
				valueField: 'id',
				displayField: 'value',
				store: 'Academia.store.common.GenderTypeStore',
				editable: false,
				allowBlank: false
			}, {
				xtype: 'datefield',
				fieldLabel: getPersonModuleTranslation('DATE_OF_BIRTH'),
				itemId: 'birthDateId',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				/*listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},*/
				name: 'birthDate',
				maxValue: new Date(),
				allowBlank: false,
				listeners: {
					render : function(dateField){
						dateField = dateFormatRender(dateField);
						var date = new Date();
						date.setFullYear(date.getFullYear()-18);
						dateField.setMaxValue(date);
						return dateField;
					}/*,
					afterrender : function(date) {
						return dateFormatRender(date);
					}*/
				}
			},{
				xtype: 'textfield',
				name: 'placeOfBirth',
				itemId: 'placeOfBirthItemId',
				hidden:true,
				fieldLabel: getPersonModuleTranslation('BIRTH_PLACE'),
			},{
				xtype: 'textfield',
				name: 'placeOfBirthOtherLang',
				itemId: 'placeOfBirthOtherLangId',
				hidden:true,
				fieldLabel: getPersonModuleTranslation('BIRTH_PLACE_LANGUAGE'),
			}]
		}, { 
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'nestedJsonCombo',
				fieldLabel: getPersonModuleTranslation('COUNTRY'),
				store: 'common.CountryStore',
				itemId: 'countryCombo',
				valueField: 'id',
				displayField: 'countryName',
				name: 'country',
				editable: false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						},
					}
				}
			},{
				xtype: 'nestedJsonCombo',
				fieldLabel: getPersonModuleTranslation('NATIONALITY'),
				itemId: 'nationalityCombo',
				store: 'common.NationalityStore',
				valueField: 'id',
				displayField: 'value',
				name: 'nationality',
				editable: false
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('ID_TYPE'),
				itemId: 'idTypeCombo',
				store: Ext.create('Academia.store.common.IDTypeStore'),
				valueField: 'id',
				displayField: 'idTypeName',
				name: 'idtype',
				hidden:true,
				editable: false
			},{
				xtype: 'textfield',
				name: 'nationalID',
				itemId: 'nationalIDItemId',
				fieldLabel: getPersonModuleTranslation('PP_NATIONAL_ID'),
				maxLength: 50,
			},{
				xtype: 'button',
				text: getPersonModuleTranslation('VERIFY_DETAILS'),
				ui: 'CustomBtnThird',
				itemId:'employeeVerifyDetail',
				hidden: true,
				cls: 'btn-with-no-icon btn-top-margin'
			},{
				xtype: 'datefield',
				name: 'identityExpiryDate',
				itemId: 'identityExpiryDateItemId',
				fieldLabel: getPersonModuleTranslation('IDENTITY_EXPIRY_DATE'),
				allowBlank: true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'multiselectcombofield',
				name: 'haveDisabilities',
				itemId:'haveDisabilities',
				addAllSelector: false,
				store:'personinfo.common.personalinfo.HaveDisibilitiesStore',
				fieldLabel: getPersonModuleTranslation('DOES_HAVE_DISABILITIES'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
				hidden:true,
				disableKeyFilter: false,
				cls:'commonAutoHeightMultiselectField',
				forceSelection:true ,
				maxLength:1000,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						},
						refresh: function( boundList, eOpts ){
							try{
								var combo = boundList.up('combo');
								var newValue = combo.getValue();
								if(!isNullOrEmpty(newValue[0])){
									var allItems = combo.listKeyNav.boundList.all.elements;
									var selectedId = 0;
									var comboStore = combo.getStore();
									if(typeof combo.getValue() == "string"){
										selectedId = combo.getValue();
									}
									else{
										selectedId = combo.getValue()[0].get('id');
									}
									if(selectedId){
										var selectedRecord = comboStore.findRecord('id',selectedId);
									}
									if(selectedRecord.data.value =='none' || selectedRecord.data.value =='None'){
										Ext.each(allItems, function(currentItem){
											var currentNoneId = currentItem.viewRecordId;
											var currentNoneRecord = comboStore.findRecord('id',currentNoneId);
											if(currentNoneRecord.get('value') == 'none' || currentNoneRecord.get('value')  == 'None'){
												currentItem.classList.remove("disabledComboItem")
											}
											else{
												currentItem.classList.add("disabledComboItem");
											}
										});
									}
								}
							}
							catch(e){
								console.log(e);
							}
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				},
				listeners:{
					beforeselect:function(selModel,record,index){
						var combo = selModel.view.field;
						var comboStore = selModel.getStore();
						if(record.data.value == 'none' || record.data.value == 'None'){
							var allItems = selModel.listKeyNav.boundList.all.elements;
							Ext.each(allItems, function(currentItem){
								var noneRecordId = currentItem.viewRecordId;
								var nonRecordList = comboStore.findRecord('id',noneRecordId);
								if(nonRecordList.get('value') == 'none' || nonRecordList.get('value') == 'None'){
									currentItem.classList.remove("disabledComboItem")
								}
								else{
									currentItem.classList.add("disabledComboItem");
								}
							});
						}

						if(!isNullOrEmpty(combo.getValue()) && combo.getValue() != "") {
							var value = combo.getValue();
							if(record.data.value == 'none' || record.data.value == 'None'){
								combo.setValue('');
							}
							var selectedValue;
							if(isArray(value)){
								if( value[0]){
									selectedValue = value[0].get('value');
								}

							}else{
								selectedValue = value;
							}
							//var topS = selModel.getHeight();
							//selModel.up('personalinformationform').up().body.setScrollTop(topS);
							if(!isNullOrEmpty(selectedValue)){
								if(selectedValue == 'none' || selectedValue == 'None'){
									return false;
								}
							}
						}else{
							//var topS = selModel.getHeight();
							//selModel.up('personalinformationform').up().body.setScrollTop(topS);
						}
					},
					change: function(combo, newValue, oldValue) {
						var comboStore = combo.getStore();
						if(!isNullOrEmpty(combo.listKeyNav)){
							var allItems = combo.listKeyNav.boundList.all.elements;
							var value=combo.getDisplayValue();
							if(value.length == 0 ){
								Ext.each(allItems, function(currentItem) {
									currentItem.classList.remove("disabledComboItem");
								});
							}else if(value == "None" || value == "none"){
								var noneId=combo.getValue();
								Ext.each(allItems, function(currentItem) {
									if(noneId[0]!=currentItem.viewRecordId){
										currentItem.classList.add("disabledComboItem");
									}
								});  
							}
						}
					} 
				}
			},{
				xtype: 'nestedJsonCombo',
				name: 'homeLanguage',
				itemId:'homeLanguage',
				store:'personinfo.common.personalinfo.HomeLanguageStore',
				fieldLabel: getPersonModuleTranslation('HOME_LANGUAGE'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
				hidden:true,
				disableKeyFilter: false
			}, {
				xtype: 'nestedJsonCombo',
				name: 'secondLanguage',
				itemId:'secondLanguage',
				store:'personinfo.common.personalinfo.SecondLanguageStore',
				fieldLabel: getPersonModuleTranslation('SECOND_LANGUAGE'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
				hidden:true,
				disableKeyFilter: false,
				forceSelection:true 
			}]
		},{

			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'nestedJsonCombo',
				fieldLabel: getPersonModuleTranslation('DOMICILE'),
				itemId: 'domicileCombo',
				store: 'common.DomicileStore',
				valueField: 'id',
				displayField: 'value',
				name: 'domicile',
				editable: false
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('HIGHEST_QUALIFICATION'), 
				itemId: 'highestQualification',
				name: 'highestQualification',
				enforceMaxLength:true,
				maxLength:100
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('AWARDING_INSTITUTION'), 
				itemId: 'awardingInstitution',
				name: 'awardingInstitution',
				enforceMaxLength:true,
				maxLength:100
			}]

		});
		itemsArray.push({
			xtype: 'fieldset',
			itemId : 'personalFormField',
			title: getPersonModuleTranslation('PERSONAL_FORM_DETAILS'),
			collapsed: false,
			items: objArray
		});

		return itemsArray;
	},

	getContactDetailsFormField: function(itemsArray) {
		var obj ={
				xtype: 'fieldset',
				title : getAdmissionTranslation('CONTACT_INFORMATION'),
				itemId : 'contactFieldSet',
				defaults: {
					labelAlign: 'top'
				},
				items: [{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					hidden: true,
					defaults: {
						labelAlign: 'top'
					},
					items: [{
						xtype: 'radiogroup',
						fieldLabel: getCommonTranslation('IMAGE_MARKETING_CONSENT'),
						itemId: 'imageMarketingCheckbox',
						name: 'imageMarketingCheckbox',
						hidden: true,
						labelAlign: 'left', // Align the label to the left
						labelWidth: 180, // Adjust the width of the label to your needs
						layout: 'hbox',
						items: [{
							boxLabel: getCommonTranslation('YES'),
							name: 'imageMarketingCheckbox',
							inputValue: true,
							checked: false,
							style: 'margin-right: 10px;' // Adjust margin between buttons if needed
						},{
							boxLabel: getCommonTranslation('NO'),
							name: 'imageMarketingCheckbox',
							inputValue: false,
							checked: false
						}]
					}
					],
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 270
					},
					hidden: true,
					items: [{
						xtype: 'multiselectcombofield',
						fieldLabel: getCommonTranslation('CONSENTED_COMMUNICATION_CHANNEL'),
						name: 'consentedCommunicationChannel',
						itemId: 'consentedCommunicationChannel',
						store: 'personinfo.common.personalinfo.CommunicationChannelStore',
						valueField: 'id',
						displayField: 'value',
						editable: false,
						allowBlank: true,
						disableKeyFilter: false,
						forceSelection:true,
						hidden: true,
						cls:'commonAutoHeightMultiselectField'
					}]
				}, {
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 256
					},
					hidden: true,
					items: [{
						xtype: 'checkboxfield',
						boxLabel: getCommonTranslation('CONSENT_STATEMENT_ACCEPTED'),
						name: 'consentStatementAccepted',
						itemId : 'consentStatementAccepted',
						labelAlign: 'left',
						region: 'south',
						hidden: true,
						inputValue: true,
						uncheckedValue: false,
						checked: false
					}]
				},{
					itemId : 'lblOneContactDetail',
					html: '<div class="alert-box warning"><i class="warningIconCls ph-fill ph-warning"></i><span class="alert-text">' +getAdmissionTranslation('ENTER_ANY_ONE_CONTACT_Details')+'</span><span class="required">*</span></div>',
					margin: 0,
					height:40,
					width:700
				},{
					xtype: 'fieldcontainer',
					itemId : 'phoneNoFldItemId',
					cls:'removeFieldLlblCls', 
					layout : {
						type : 'hbox'
					},
						height:80,
					items : [ {
						xtype: 'fieldcontainer',
						fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),	
						labelAlign: 'top',
						layout : {
							type : 'hbox'
						},
						cls:'showFieldLblcls', 
						height:70,
						items : [{
							xtype : 'customcombobox',
							hiddenName : 'phoneNumber1',
							valueField : 'isdCode',
							displayField : 'isdCode',
							store:Ext.create('Academia.store.common.CountryStore'),
							triggerAction : 'all',
							name : 'phoneCountryCode',
							itemId : 'phoneCountryCode',
							forceSelection:true,
							width:100,
							minChars: 1,
							cls:'removeFieldLlblCls', 
							emptyText:getCommonTranslation('ISD')
						}, {
							xtype : 'numberfield',
							name : 'phoneAreaCode',
							width: 108,
							enforceMaxLength : true,
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowExponential:false,
							itemId : 'phoneAreaCode',
							margin:'0 0 0 -25',
							cls:'removeFieldLlblCls', 
							emptyText:getCommonTranslation('STD')
						}, {
							xtype : 'numberfield',
							itemId : 'phoneNoField',
							name : 'phoneNo',
							enforceMaxLength : true,
							hideTrigger: true,
							width: 256,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowExponential:false,
							cls:'removeFieldLlblCls', 
							margin:'0 0 0 -50',
							emptyText:getCommonTranslation('ADDRESS_PHONE_NUMBER_1')
						}]
					}, {
						xtype: 'fieldcontainer',
						itemId : 'mobileNoFldItemId',
						fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
						cls:'showFieldLblcls', 
						labelAlign: 'top',
						layout : {
							type : 'hbox'
						},
						defaults: {
							enforceMaxLength: true,
							labelAlign: "top",
							width: 256
						},
						height:70,
						//margin:'0 0 0 -120',
						items : [{
							xtype : 'customcombobox',
							name : 'mobileCountryCode',
							itemId : 'cellCountryCode',
							valueField : 'isdCode',
							displayField : 'isdCode',
							store:Ext.create('Academia.store.common.CountryStore'),
							triggerAction : 'all',
							forceSelection:true,
							width:  100,
							cls:'removeFieldLlblCls', 
							minChars: 1,
							emptyText:getCommonTranslation('ISD')
						}, {
							xtype : 'numberfield',
							name : 'mobileNumber',
							itemId : 'mobileNumber',
							minLength: 0,
							maxLength: 15,
							enforceMaxLength : true,
							cls:'removeFieldLlblCls', 
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowExponential:false,
							width: 256,
							margin:'0 0 0 -25',
							emptyText:getCommonTranslation('ADDRESS_MOBILE_NO')
						}]
					} ]
				},{
					xtype: 'fieldcontainer',
					itemId : 'alternateNoFldItemId',
					//name: 'alternateNoFldItem',
					//fieldLabel: getCommonTranslation('ALTERNATE_MOBILE_NO'),
					layout : {
						type : 'hbox'
					},
					defaults: {
						enforceMaxLength: true,
						labelAlign: "top"
					},
					cls:'removeFieldLlblCls', 
					height:80,
					items : [{
						xtype: 'fieldcontainer',
						itemId : 'alternateNoFldItemId',
						name: 'alternateNoFldItem',
						cls:'showFieldLblcls', 
						fieldLabel: getCommonTranslation('ALTERNATE_MOBILE_NO'),
						height:70,
						layout : {
							type : 'hbox'
						},items:[{
							xtype : 'customcombobox',
							name : 'alternateMobileCountryCode',
							itemId : 'alternateCellCountryCode',
							valueField : 'isdCode',
							cls:'removeFieldLlblCls', 
							displayField : 'isdCode',
							store:Ext.create('Academia.store.common.CountryStore'),
							triggerAction : 'all',
							forceSelection:true,
							cls:'removeFieldLlblCls', 
							width:  100,
							minChars: 1,
							emptyText:getCommonTranslation('ISD')
						}, {
							xtype : 'numberfield',
							name : 'alternateMobileNo',
							cls:'removeFieldLlblCls', 
							itemId : 'alternateMobileNumber',
							minLength: 6,
							maxLength: 15,
							enforceMaxLength : true,
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowExponential:false,
							width: 256,
							margin:'0 0 0 -25',
							emptyText: getCommonTranslation('ALTERNATE_MOBILE_NO')
						}]}, {
							xtype: 'textfield',
							fieldLabel: getAdmissionTranslation('EMAIL_ID'), //Email ID
							name: 'emailId',
							vtype: 'myemail',
							itemId: 'emailId',
							maxLength: '100',
							cls:'showFieldLblcls', 
							margin:'0 0 0 20',
							allowBlank: false,
							width: 256
						},{
							xtype:'textfield',	
							fieldLabel:getCommonTranslation('ALTERNATE_EMAIL_ID'),
							name:'alternateEmailId',
							itemId : 'alternateEmailId',
							vtype: 'myemail',
							cls:'showFieldLblcls', 
							maxLength: '100',
							width: 256,
							margin:'0 0 0 10'
								//allowBlank: false
						}]
				},/*{
						xtype: 'fieldcontainer',
						labelAlign: 'top',
						layout: {
							type: 'hbox'
						},
						defaults: {
							labelAlign: 'top',
							width: 256
						},
						items: []
					},*/ {
					xtype: 'fieldcontainer',
					labelAlign: 'top',
					layout: {
						type: 'hbox'
					},
					defaults: {
						enforceMaxLength: true,
						labelAlign: "top"
					},
					height:80,
					items: [ {
						xtype: 'textfield',
						fieldLabel: getCommonTranslation('EMERGENCY_FIRST_NAME'),
						name: 'emergencyFirstName',
						itemId: 'emergencyFirstNameId',
						maxLength: '100',
						enforceMaxLength :true,
						width: 256
					},{
						xtype:'textfield',	
						fieldLabel:getCommonTranslation('EMERGENCY_LAST_NAME'),
						name:'emergencyLastName',
						itemId : 'emergencyLastNameId',
						maxLength: '100',
						enforceMaxLength :true,
						width: 256
					}, {
						xtype: 'fieldcontainer',
						itemId : 'emergencyMobileNoFldItemId',
						fieldLabel: getCommonTranslation('EMERGENCY_CONTACT_NUMBER'),
						layout : {
							type : 'hbox'
						},
						defaults: {
							enforceMaxLength: true,
							labelAlign: "top",
							width: 256
						},
						height:70,
						items : [ {
							xtype : 'customcombobox',
							name : 'emergencyMobileCountryCode',
							itemId : 'emergencyMobileCountryCode',
							valueField : 'isdCode',
							displayField : 'isdCode',
							store:Ext.create('Academia.store.common.CountryStore'),
							triggerAction : 'all',
							forceSelection:true,
							width:  100,
							minChars: 1,
							emptyText:getCommonTranslation('ISD')
						}, {
							xtype : 'numberfield',
							name : 'emergencyMobileNumber',
							itemId : 'emergencyMobileNumberId',
							maxLength: 10,
							enforceMaxLength : true,
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowExponential:false,
							width: 256,
							margin:'0 0 0 -25',
							emptyText:  getCommonTranslation('EMERGENCY_CONTACT_NUMBER')
						}]
					}]
				}]
		}
		itemsArray.push(obj);
		return itemsArray;
	},
	getPersonalDetailFormExtSysRefField: function(itemsArray) {
		itemsArray.push({
			xtype: 'form',
			style:{'padding':'0px !important','margin-top':'-21px !important','margin-left': '10px','margin-bottom':'35px'},		
			items: [{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 256,
					labelAlign:'top'
				},
				items: [{
					xtype:'textfield',
					fieldLabel:getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_1'),
					name:'externalSysRefOne',
					itemId : 'externalSysRefOne',
					maxLength : 50,
					hidden:true
				},{
					xtype:'textfield',
					fieldLabel:getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_2'),
					name:'externalSysRefTwo',
					itemId : 'externalSysRefTwo',
					maxLength : 50,
					hidden:true
				},{
					xtype:'textfield',
					fieldLabel:getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_3'),
					name:'externalSysRefThree',
					itemId : 'externalSysRefThree',
					hidden:true,
					maxLength : 50

				}]
			}]});
		return itemsArray;
	},
	getOtherFacultyDetailsFormField: function(itemsArray) {

		itemsArray.push({
		    xtype: 'fieldset',
		    name: 'otherDetailsFacultyFieldSet',
		    itemId: 'otherDetailsFacultyFieldSet',
		    collapsible: true,
		    width: 900,
		    collapsed: false,
		    title: getCommonTranslation('OTHER_DETAILS'),
		    titleCollapse: true,
		    defaults: {
		        labelAlign: 'top',
		        anchor: '100%',
		        tdAttrs: { style: 'padding: 5px;' }
		    },
		    items: [{
		        xtype: 'fieldcontainer',
		        layout: 'hbox',
		        defaults: {
		            labelAlign: 'top',
		            width: 256,
		            margin: '0 15 0 0'
		        },
		        items: [{
		            xtype: 'nestedJsonCombo',
		            fieldLabel: getPersonModuleTranslation('SUB_DEPARTMENT'),
		            store: 'department.SubDepartmentComboStore',
		            itemId: 'subDepartmentCombo',
		            valueField: 'id',
		            displayField: 'name',
		            name: 'subDepartment',
		            editable: false,
		            triggerAcation: 'all',
		            fourceSelection: true,
		            listConfig: {
		                listeners: {
		                    beforeshow: function (picker) {
		                        picker.width = picker.up('combobox').getSize().width;
		                    }
		                }
		            }
		        }, {
		            xtype: 'customcombobox',
		            fieldLabel: getCommonTranslation('BLOOD_GROUP'),
		            name: 'bloodGroup',
		            store: 'enquiry.studentDetail.BloodGroupStore',
		            valueField: 'id',
		            displayField: 'value',
		            editable: false
		        }, {
		            xtype: 'customcombobox',
		            fieldLabel: getPersonModuleTranslation('MARITAL_STATUS'),
		            store: 'common.MaritalStatusStore',
		            valueField: 'id',
		            displayField: 'value',
		            name: 'maritalStatus',
		            editable: false,
		            margin: '0'  // last item → no right margin
		        }]
		    }, {
		        xtype: 'fieldcontainer',
		        layout: 'hbox',
		        defaults: {
		            labelAlign: 'top',
		            width: 256,
		            margin: '0 15 0 0'
		        },
		        items: [{
		            xtype: 'nestedJsonCombo',
		            fieldLabel: getPersonModuleTranslation('RELIGION'),
		            store: 'common.ReligionStore',
		            itemId: 'religionCombo',
		            valueField: 'id',
		            displayField: 'value',
		            name: 'religion',
		            editable: false
		        }, {
		            xtype: 'nestedJsonCombo',
		            fieldLabel: getPersonModuleTranslation('CASTE_CATEGORY'),
		            store: 'common.CastCategoryStore',
		            itemId: 'castCategoryCombo',
		            valueField: 'id',
		            displayField: 'value',
		            name: 'castCategory',
		            editable: false
		        }, {
		            xtype: 'textfield',
		            fieldLabel: getPersonModuleTranslation('CATEGORY'),
		            name: 'category',
		            itemId: 'categoryItemId',
		            margin: '0'
		        }]
		    }, {
		        xtype: 'fieldcontainer',
		        layout: 'hbox',
		        defaults: {
		            labelAlign: 'top',
		            width: 256,
		            margin: '0 15 0 0'
		        },
		        items: [{
		            xtype: 'datefield',
		            fieldLabel: getPersonModuleTranslation('DATE_OF_EXIT'),
		            name: 'exitDate',
		            itemId: 'endDate',
		            vtype: 'daterange',
		            startDateField: 'startDate',
		            listeners: {
		                render: function (field) {
		                    return dateFormatRender(field);
		                }
		            }
		        }, {
		            xtype: 'textfield',
		            fieldLabel: getPersonModuleTranslation('ACCOUNTING_KEY'),
		            name: 'accountingKey',
		            maxLength: 255,
		            margin: '0'
		        }]
		    }, {
		        xtype: 'fieldcontainer',
		        itemId: 'serviceStopPanelId',
		        width: 800,
		        items: [{
		            xtype: 'fieldcontainer',
		            width: 800,
		            itemId: 'serviceStopContainer',
		            layout: 'hbox',
		            defaults: {
		                labelAlign: 'top',
		                margin: '0 15 0 0'
		            },
		            items: [{
		                xtype: 'hidden',
		                itemId: 'langItemId',
		                name: 'langId'
		            }, {
		                xtype: 'customcombobox',
		                name: 'employeeLanguage',
		                itemId: 'employeeLanguage',
		                fieldLabel: getCommonTranslation('LANGUAGE'),
		                store: Ext.create('Academia.store.common.EmployeeLanguageStore'),
		                valueField: 'id',
		                displayField: 'value',
		                 editable: false,
		                 width: 256,
		                disableKeyFilter: false,
		                forceSelection: true
		            }, {
		                xtype: 'customcombobox',
		                name: 'read',
		                itemId: 'readItemId',
		                width: 105,
		                fieldLabel: getCommonTranslation('READ'),
		                store: Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
		                valueField: 'id',
		                displayField: 'value',
		                editable: false
		            }, {
		                xtype: 'customcombobox',
		                name: 'write',
		                itemId: 'writeItemId',
		                store: Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
		                fieldLabel: getCommonTranslation('WRITE'),
		                valueField: 'id',
		                displayField: 'value',
		                editable: false,
		                width: 105
		            }, {
		                xtype: 'customcombobox',
		                name: 'speak',
		                itemId: 'speakItemId',
		                store: Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
		                fieldLabel: getCommonTranslation('SPEAK'),
		                valueField: 'id',
		                displayField: 'value',
		                editable: false,
		                width: 105
		            }, {
		                xtype: 'button',
		                itemId: 'stopBtn',
		                cls: 'CustomBodyBtnSettings',
		                text: getCommonTranslation('ADDBUTTONTEXT'),
		                tooltip: getCommonTranslation('ADD'),
		                margin: '24 0 0 0'
		            }]
		        }]
		    }]
		}

);
		return itemsArray;
	},
	getBankDetailFormField: function(itemsArray) {
		itemsArray.push({
			xtype: 'fieldset',
			collapsed: true,
			collapsible : true,
			title: getPersonModuleTranslation('BANK_DETAILS'),
			titleCollapse: true,
			name : 'bankDetailsFieldSet',
			itemId : 'bankDetailsFieldSet',
			items: [{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 256,
					tdAttrs: { style: 'padding: 5px;' }
				},
				items: [{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('BENEFICIARY_NAME'),
					name: 'beneficiaryName',
					maxLength: 50,
					itemId:'beneficiaryName'
				}, {
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('BENEFICIARY_NAME_OTHER_LANGUAGE'),
					name: 'beneficiaryNameOtherLanguage',
					maxLength : 50,
					hidden:true,
					itemId:'beneficiaryNameOtherLanguageId'
				},{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('ACCOUNT_NUMBER'),
					maxLength : 50,
					enforceMaxLength : true,
					name: 'accountNumber',
					itemId: 'accountNumber'
				}, {
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('ACCOUNT_TYPE'),
					name: 'accountTypeId',
					valueField: 'id',
					displayField: 'value',
					store: 'user.AccountTypeStore',
					editable: false,
					itemId: 'accountTypeId',
				}]
			}, {
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 256
				},
				items: [{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('BANK_NAME'),
					name: 'bankName',
					maxLength : 30,
					itemId: 'bankName',
				},{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('BRANCH_NAME'),
					name: 'branchName',
					maxLength: 100,
					itemId: 'branchName',
				},{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('IFSC_CODE'),
					itemId: 'ifsCode',
					name: 'ifsCode',
					maxLength : 11,
					minLength : 6,
					enforceMaxLength : true
					//allowBlank: false
				}]
			}]
		});
		return itemsArray;
	},
	getSaveFormField: function(itemsArray) {
		itemsArray.push({
			xtype:'fieldcontainer',
			cls:'form-fixed-footer',
			items:[{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				buttonAlign: 'left',
				itemId: 'personalInfoSaveButtonId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,         
				formBind: true,
				hasDisableForProfileViewMode:true,
			}]
		});

		return itemsArray;
	}
});
