/**
 * This view is used for the faculty profile.
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.faculty.FacultyProfile', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.facultyprofile',
	cls: 'panelNoSpace',
	width: '98%',
	style:{
		'top':'-12.5px !important'
	},
   defaults: {
		autoScroll: true
	},
	layout: {
		type: 'border'
	},
	initComponent: function() {

		this.items = [{
			xtype: 'panel',
			region: 'center',
			cls: 'panelNoSpace',
			autoScroll: true,
			width:'95%',
			layout: {
				type: 'vbox'
			},
			items: [{
				xtype: 'panel',
				height:110,
			    layout: {
			        type: 'hbox'
			    },
			    style:{
			    	'border':'1px solid #e0e0e0;',
			    	'marginTop':'30px !Important',
			    	'border-radius': '5px;'
			    },
			    width: '100%',
			    //minWidth: 500,
                items: [ {
	                xtype: 'panel',
	                style: {
	                    marginTop: '0px !important'
	                },
	                layout: {
				        type: 'hbox'
				    },
				    width: '100%',
	                items: [{
		            	xtype:'image',
		                itemId: 'profile_image',
		                border: 1,
		                style: {
		                    borderColor: '#e0e0e0',
		                    borderStyle: 'solid',
		                    borderRadius:'50%',
		                    marginTop: '15px !important'
		                },
		                width: 80,
		                height: 70
		            },{
					    xtype: 'container', // Using container to manage custom HTML
					    itemId: 'profile_image_icon',
					    width: 50,
					    height: 50,
					    style: {
					        marginTop: '25px',
					        marginLeft: '13px'
					    },
					    html: '<span class="hoverElement" style="display: inline-block; width: 25px; height: 25px; border: 1px solid #e0e0e0; border-radius: 50%; overflow: hidden; padding: 5px; position: absolute; left: -32px; background-color: #fff; top: 35px;">' +
					          '<img src="resources/images/Edit_Pro.svg" class="hoverImage" style="width: 100%; height: 100%; object-fit: cover;">' +
					          '</span>'
					},{
		                xtype: 'panel',
		                style:{
		                	 marginTop: '25px !important',
		                	 marginLeft: '15px !important',
		                },
			               /* cls: 'panelNoSpace',
			                style: {
			                	marginLeft: '-10px !important',
			                    marginTop: '0px !important'
			                },*/
			                width: '80%',
			                height:100,
			                items: [this.getFacultyProfileView()]
			            }]
	            }]
			},{ 
				xtype:'panel',
				layout:'hbox',
				width:'100%',
				style:{
					marginTop: '-10px'
				},
				items:[
				{
				xtype: 'personinfopanel',
				minWidth: 800,
				//width:'77%',
				defaults: {
					border: false
				}
			}]
			}]
		}, {
			xtype:'panel',
			width: '20%',
			region: 'east',
			itemId: 'facultyProfileEastPanel',
			layout:'vbox',
			cls: 'panelNoSpace facultyProfileCls',
			collapsible: true,
			border: true,
			margin:'13 0 0 0',
			defaults: {
				bodyStyle: 'padding:5px'
			},
			header:{
				layout:
			    {
			        type: 'hbox',
			        pack: 'end'
			    },
				items:[
					{
						
			        	xtype: 'combo',
			        	itemId: 'facultyDetailLinkSearchComboBox',
			        	cls: 'searchComboBoxCls profileLeftMenuCls',
			            store: Ext.create('Academia.view.personinfo.common.PersonDetailsLinkSearchStore'),
			            displayField: 'searchText',
			            valueField: 'menuId',
			            hideLabel: true,
			            width:'85%',
			            hideTrigger:true,
			        	enableKeyEvents: true,
			        	allowCollapse: false,
			        	minChars: 0,
			        	style:{
							'margin-top':'24px !important'
						},
			        	queryMode: 'local',
			        	emptyCls: 'search-empty-text-field',
			        	emptyText: getCommonTranslation('SEARCH'),
			        	anyMatch:    true,
			        	matchFieldWidth: true,
			            listConfig: {
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_MATCH'),
			                cls: 'personProfileSearchMenuListCls',
			                getInnerTpl: function() {
			                    return '<a class="searchItemCls">' +
			                        '<span class="displayPathCls" style="margin-left: 10px;">{displayPath}</span><span class="titleCls" style="left: 10px;">{title}</span>' +
			                    '</a>';
			                }
			            },
			            listeners: {
			            	select: function(combo, record){
			            		var parentPanelSelector = record[0].get('parentPanelSelector'),
			            			currentElementSelector = record[0].get('currentElementSelector'),
			            			currentItemIndex = record[0].get('currentItemIndex');
			            		
			            		Ext.getCmp(parentPanelSelector).up().expand();
			            		if(Ext.query('#'+parentPanelSelector)[0].querySelectorAll(currentElementSelector).length == 0) {
			            			setTimeout(function(){
			            				Ext.query('#'+parentPanelSelector)[0].querySelectorAll(currentElementSelector)[currentItemIndex].click();
			            			},500);
			            		}
			            		else {
				            		Ext.query('#'+parentPanelSelector)[0].querySelectorAll(currentElementSelector)[currentItemIndex].click();
			            		}
			            		combo.clearValue();
			            	},
			            	beforequery: function(record){  //Added for sorting & any match
			            		this.getStore().sort([{
			                    	property : 'title',
			                    	direction: 'ASC'
			                    }]);
			                }
			            }
			        }
				]
			},
			hideHeaders : false,
			animate : true,
			animCollapse: true,
			titleCollapse : true,
			items:[{
				xtype: 'persondetailslinkpanel',
				flex:1,
				collapsible: false,
				itemId : 'facultyPersonDetailsLinkPanel',
				width: '100%',
				personType : 'FACULTY',
				cls: 'panelNoSpace manageIcon',
				border:false,
			}]
		
	}];

		this.callParent(arguments);
	},
	getFacultyProfileView: function() {

		var facultyProfile = new Ext.XTemplate('<tpl for="."><div>', 
				
		
				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
				 '<tr style = "line-height: 30px;">',
                 '<th style ="font-weight: 500;width:20%;text-align: left;">Employee ID</th>',
                 '<th style ="font-weight: 500;width:20%;text-align: left;">Employee Name</th>',
                 '<th style ="font-weight: 500;width:20%;text-align: left;">Mob. No.</th>',
                 '<th style ="font-weight: 500;width:25%;text-align: left;">Email ID</th>',
               '</tr>',
				'<tr>', 
				'<td style ="text-align: left;width:20%;">','<div>',
				'<span style ="font-weight: 600;">{personId}</span></div></td>',
				
				'<td style ="text-align: left;width:20%;">','<div>',
				'<img src="resources/images/student_profile_icon.png" style="width:16px;height:19px;">',

				'<span style ="margin-left: 13px;font-weight: 600;">{firstName} {middleName} {lastName}</span></div></td>', 
				
				'<td style ="text-align: left;width:20%;">','<div>',
				'<img src="resources/images/call_icon.png" style="width:16px;height:19px;position: absolute;">',
				/*'<span style ="margin-left: 25px;font-weight: 600;">',
				'<tpl if="phoneCountryCode != null">{phoneCountryCode}-</tpl>',
				'{phoneNo}</span>',  */
			
				'<span style ="margin-left: 20px;font-weight: 600;">{mobileCountryCode}-{mobileNumber}</span></div></td>',  
				
				'<td style ="text-align: left;width:20%;">','<div>',
				'<img src="resources/images/email_icon.png" style="width:16px;height:19px;position: absolute;">','<span style ="margin-left: 25px;font-weight: 600;">{emailId}</span></div></td>',
				
				'</tr>',
			
				'</table>', 
		
				/***
				 * hidden by nilesh 
				 */
				/*		'<td>', 
        				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
	        				'<tr>', 
								'<td><b>' + getPersonModuleTranslation('UNPAID_FACULTY_BILLS')+ '</b></td>', 
							'</tr>', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('NO_OF_PENDING_BILLS')+ ': {noOfPendingBills}</td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('TOTAL_PENDING_AMOUNT')+ ': {totalPendingAmount}</td>', 
        					'</tr>',
        					'<tr>', 
    							'<td>' + getPersonModuleTranslation('TOTAL_UNBILLED_SESSION')+ ': {unbilledSession}</td>', 
    						'</tr>',
    						'<tr>', 
								'<td><b>' + getPersonModuleTranslation('PENDING_BILLS')+ '</b></td>', 
							'</tr>',
							'<tr>', 
								'<td>' + getPersonModuleTranslation('NO_OF_PENDING_BILLS')+ ': {noOfPendingBills}</td>', 
							'</tr>',
							'<tr>', 
								'<td>' + getPersonModuleTranslation('TOTAL_PENDING_AMOUNT')+ ': {totalPendingAmount}</td>', 
							'</tr>',
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('NO_OF_PDC_DUE_FOR_SUBMISSION')+ ': {noOfPDCDue}</td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('PENDING_DOCUMENTS')+ ': {pendingDocuments}</td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('REQUEST_PENDING_DECISION')+ ': {requestPendingDescision}</td>', 
        					'</tr>',
        					'<tr>', 
    							'<td>' + getPersonModuleTranslation('REQUEST_PENDING_ACTION')+ ': {requestPendingAction}</td>', 
    						'</tr>', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('SMS_FAILURE')+ ': {smsFailure}</td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('EMAIL_FAILURE')+ ': {emailFailure}</td>', 
        					'</tr>', 
        				'</table>', 
        			'</td>', */	
			
		'</div></tpl>');

		var facultyProfileView = {
				xtype: 'dataview',
				alias: 'widget.facultyprofileview',
				itemId: 'facultyProfileView',
				width: '100%',
				height:100,
				store: Ext.create('Academia.store.personinfo.faculty.FacultyProfileStore'),
				tpl: facultyProfile,
				itemSelector: 'div.thumb-wrap'
		};
		return facultyProfileView;
	}

});
