/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.personinfo.faculty.employeeReference.EmployeeReferenceForm', {
	 extend: 'Academia.view.common.IdGeneratorCustomForm',
   itemId: 'employeereferenceform',
    plugins: "formlabelrequired",
    customFieldEntity:CONSTANTS.EMPLOYEE_REFERENCES,
    alias: 'widget.employeereferenceform',
    standardSubmit: false,
    defaults : {
		labelAlign:'top',
		enforceMaxLength : true,
		width: 256
	},
    items: [{
        xtype: 'hidden',
        itemId: 'referenceHiddenField',
        name: 'id'
    }/* {
        xtype: 'hidden',
        itemId: 'referenceOrder',
        name: 'referenceOrder'
    },{
        xtype: 'hidden',
        itemId: 'encryptedReferenceId',
        name: 'encryptedReferenceId'
    },*/ , {
    	xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
		    	xtype: 'customcombobox',
				name: 'salutation',
				fieldLabel:getAdmissionTranslation('SALUTATION'),
				store: 'common.SalutationStore',
				queryMode: 'remote',
				valueField: 'id',
				displayField: 'salutationName',
				//width: 100,
				allowBlank:false,
				itemId:'salutation',
				forceSelection:true,
				editable: false
		  	},{
		  		fieldLabel: getAdmissionTranslation('FULL_NAME'), //References Name
	            xtype: 'textfield',
	            itemId: 'referenceName',
	            name: 'referenceName',
	            labelAlign: 'top',
	            allowBlank: false,
	            width: 256,
	            maxLength:255
		  	  }]
		},{
	    	xtype: 'fieldcontainer',
		    width: 'auto',
		    defaults: {
		    	labelAlign: 'top',
		    	width: 256
		    },
		    layout: {
			type: 'hbox'
		    },
		    items: [{
	            fieldLabel: getAdmissionTranslation('CONTACT_NO'), //Contact No.
	            xtype: 'numberfield',
	            itemId: 'contactNo',
	            name: 'contactNo',
	            labelAlign: 'top',
	            maxLength: 10,
				minLength:10,
				// To Remove spinner buttons, and arrow key and mouse wheel listeners
		        hideTrigger: true,
		        keyNavEnabled: false,
		        mouseWheelEnabled: false,
	            allowExponential:false,
	            width: 256
		    },{
		    	xtype: 'textfield',
				name: 'emailId',
				itemId:'emailId',
				fieldLabel: getAdmissionTranslation('EMAIL'),
				vtype:'email',
				allowBlank:false,
				maxLength:100,
				//enforceMaxLength : true
		    }] 
		},{
	    	xtype: 'fieldcontainer',
		    width: 'auto',
		    defaults: {
		    	labelAlign: 'top',
		    	width: 256
		    },
		    layout: {
			type: 'hbox'
		    },
		    items: [{
		    	fieldLabel: getAdmissionTranslation('AFFILIATION'), //References Name
	            xtype: 'textfield',
	            itemId: 'affiliation',
	            name: 'affiliation',
	            labelAlign: 'top',
	            width: 256,
	            maxLength:255
		    },{
		    	fieldLabel: getAdmissionTranslation('DESIGNATION'), //Designation
	            xtype: 'textfield',
	            itemId: 'designation',
	            name: 'designation',
	            labelAlign: 'top',
	            width: 256,
	            maxLength:255
		    }] 
		},{
	    	xtype: 'fieldcontainer',
		    width: 'auto',
		    defaults: {
		    	labelAlign: 'top',
		    	width: 256
		    },
		    layout: {
			type: 'hbox'
		    },
		    items: [{
		    	xtype: 'customcombobox',
				name: 'waived',
				fieldLabel:getAdmissionTranslation('WAIVED'),
				store: 'common.YesNoClientSideComboStore',
				queryMode: 'remote',
				valueField: 'name',
				displayField: 'value',
				//width: 100,
				itemId:'waived',
				forceSelection:true,
				editable: false
		    },{
		    	fieldLabel: getAdmissionTranslation('REMARK'), //Reference Remark
	            xtype: 'textfield',
	            itemId: 'remark',
	            name: 'remark',
	            labelAlign: 'top',
	            width: 256,
	            maxLength:255
		    }] 
		},{
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            itemId: 'btnSaveReferencesForm',
            text: getCommonTranslation('SUBMIT'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'btnCancelReferencesMasterForm',
            text: getCommonTranslation('CANCEL'), //Cancel
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});