/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.personinfo.faculty.uploaddownload.FacultyDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.facultydownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
//	plugins:"formlabelrequired",
	items : [{

		xtype: 'customcombobox',
		fieldLabel: getCommonTranslation('TEMPLATE_IMPORT_TYPE'),
		itemId: 'templateTypeFacultyId',
		name: 'templateTypeFacultyId', 
		width: 256,
		store:Ext.create('Ext.data.Store', {
			fields: ['id', 'value'],
			data : [
				{"id":"IMPORT_EMPLOYEES", "value":getCommonTranslation('IMPORT_EMPLOYEES')},
				{"id":"IMPORT_BULK_EMPLOYEE_OTHER_DETAILS", "value":getCommonTranslation('IMPORT_EMPLOYEE_OTHER_DETAILS')}
				]
		}),
		valueField: 'id',
		displayField: 'value',
		forceSelection: true,
		allowBlank:false,
		labelAlign: 'top'
	
	},{
		xtype:'fieldcontainer',
		layout : 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items:[{
			xtype : 'multiselectcombofield',
			width: 920,
			//height:58,
			name : 'academyLocation',
			itemId:'academyLocationId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			allowBlank : false,
			valueField : 'id',
			forceSelection : true,
			cls:'multiBrandCampusCls',
			displayField : 'value'				
		},{
			xtype : 'multiselectcombofield',
			width: 256,
			//height:58,
			name : 'deparmentalId',
			itemId:'deparmentalId',
			fieldLabel : getProgramandcourseTranslation('DEPARTMENT'),
			store:Ext.create('Ext.data.Store', {
				model: 'Academia.model.common.IdValueCodeDataModel',
					    autoLoad: false,
					    proxy: {
					        type: 'rest',
					        api: {
					            read: SERVERURL.PATH_FIND_PARENT_DEPARTMENT_BY_AL_AND_PROGRAM
					        },
					        method: 'GET',
					        reader: {
					            type: 'json'
					        }
					    }
			}),
			allowBlank : false,
			valueField : 'id',
			forceSelection : true,
			cls:'multiBrandCampusCls',
			displayField : 'value',
			hidden:true,
			disabled:true
		}]
	},{
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items:[{
			xtype: 'fieldcontainer',
			width: 'auto',
			items: [{
				xtype: 'button',
				text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
				itemId: 'downoladBtnId',
				formBind : true,
				ui: 'CustomBtnSubmit'
			}]
		}]
	}]
});
