/**
 * @author <a href="vyabha.thakur@serosoft.in">Vyabha Thakur</a>
 *
 */
Ext.define('Academia.view.personinfo.student.NominateExaminersForm', {
    extend: 'Ext.form.Panel',
    extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.nominateexaminersform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
    items: [{
        xtype: 'hidden',
        itemId: 'nominate_examiners_hidden_field',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [ {
        	xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('EXAMINER_TYPE'),
			store: 'common.ExaminerTypeStore',
			itemId: 'examinerType',
			name: 'examinerType',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank: false
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('EXAMINER_NAME'),
            itemId: 'examinerName',
            name: 'examinerName',
            store: 'common.AllUserBySmartSearchNE',
            allowBlank: false,
            queryParam:'codeOrName',
            triggerAction: 'all',
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            enableKeyEvents  : 'true',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			minChars:3,
			displayField: 'value', 
			valueField: 'id',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        }]
    
    }, {

    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
        	xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('EXAM_TYPE'),
			store: 'common.ExamTypeStore',
			itemId: 'examType',
			name: 'examType',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank: true
        },{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('EMAIL_ID'),            
            itemId: 'emailId',
            readOnly: true,
            name: 'emailId',
            allowBlank: false
        }]
    },{

    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
            xtype: 'fieldcontainer',
            fieldLabel: getCommonTranslation('MOBILE_NO'), 
            name: 'mobileNumberLabelId',
            height: 58,
            itemId: 'mobileNumberLabelId',
            readOnly: true,
            allowBlank: false,
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'textfield',
                name: 'mobileCountryCode',
                itemId: 'mobileCountryCode',
                valueField: 'isdCode',
                displayField: 'isdCode',
                //store: Ext.create('Academia.store.common.CountryStore'),
                //triggerAction: 'all',
                readOnly: true,
                //forceSelection:true ,
                width: 80,
                minChars: 1
            }, {
                xtype: 'numberfield',
                name: 'mobileNumber',
                itemId: 'mobileNumber',
                minLength: 0,
                maxLength: 11,
                enforceMaxLength: true,
                hideTrigger: true,
                keyNavEnabled: false,
                readOnly: true, 	
                mouseWheelEnabled: false,
                allowExponential: false,
                width: 146
            }]
        }]
    },{

    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textareafield',
            fieldLabel: getPersonModuleTranslation('DESCRIPTION'),            
            itemId: 'description',
            name: 'description',
            allowBlank: true,
            width: 536,                
			maxLength:255
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        
        items: [ {
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('AUDIT_DATE'),
            itemId: 'auditDate',
            name: 'auditDate',
            editable : false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
            vtype : 'daterange'
        },{
        	xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('AUDIT_ID'),            
            itemId: 'auditId',
            name: 'auditId',
            readOnly : true,
            allowBlank: false
        }]
    },{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});
