/**
 * @author Bhartendu Bhaskar
 * 
 */
Ext.define('Academia.view.personinfo.student.StudentAcademicTopicDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentacademictopicdownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype:'fieldcontainer',
		items:[{
			xtype : 'fieldcontainer',
			width : '100%',
			itemId:'templateTopicContainer',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('TEMPLATE_IMPORT_TYPE'),
				itemId: 'templateTypeId',
				name: 'templateType', 
				width: 256,
				store:'student.studentprofile.StudentTemplateTypeStore',
				valueField: 'name',
				displayField: 'value',
				forceSelection: true,
				allowBlank:false						
			},{
	    		xtype: 'customcombobox',
	    		name: 'academicTopicId',
	            itemId: 'academicTopicItemId',
	            fieldLabel: getCommonTranslation('TEMPLATE_SUB_TYPE'),
	            editable: false,
                width: 256,
	            valueField: 'id',
	            displayField: 'value',
	            disabled:true,
	            queryMode: 'local',
	            hidden: true,
	            listeners: {
	                render: function(combo) {
	                    var store = Ext.create('Academia.store.student.studentprofile.AcademicTopicStore');
	                    combo.bindStore(store);
	                },
                    select:function(obj,record){
                    	var academicTopicId = record[0].get("id");
                    	var form =obj.up('studentacademictopicdownloadform');
                    	form.down('#academicSubTopicItemId').setDisabled(false);
                    	form.down('#academicSubTopicItemId').reset();
                    	
                    	var store = form.down('#academicSubTopicItemId').getStore();
                      	store.proxy.extraParams = {
                      		academicTopicId : academicTopicId
     					};
                      	store.load();
                    }
	            }
	    	},{
	            xtype: 'nestedJsonCombo',
	            fieldLabel: getCommonTranslation('TEMPLATE_SUB_TYPE'),
	            name: 'community',
	            itemId: 'communityNameComboField',
	            valueField: 'id',
	            width: 256,
	            displayField: 'value',
	            store: Ext.create('Academia.store.personinfo.common.services.MappedCommunityByPBSId'),
	            editable: false,
	            hidden:true
	    	},{
	            xtype: 'nestedJsonCombo',
	            fieldLabel: getCommonTranslation('TEMPLATE_SUB_TYPE'),
	            itemId: 'serviceNameComboField',
	            name: 'service',
	            valueField: 'id',
	            width: 256,
	            displayField: 'value',
	            store:'personinfo.common.services.ServiceNameStore',
	            editable: false,
	            hidden:true,
	            allowBlank:false
	    	},{
	            xtype: 'customcombobox',
	            name: 'academicSubTopicId',
	            itemId: 'academicSubTopicItemId',
	            fieldLabel: getPersonModuleTranslation('ACADEMICS_SUB_TOPIC'),
	            editable: false,
	            disabled:true,
                width: 256,
	            valueField: 'id',
	            displayField: 'value',
	            queryMode: 'local',
	            hidden: true,
	            listeners: {
	                render: function(combo) {
	                    var store = Ext.create('Academia.store.student.studentprofile.AcademicSubTopicStore');
	                    combo.bindStore(store);
	                }
	            }
			}]
		},
		{
			xtype : 'fieldcontainer',
			width : '100%',
			itemId:'programBatchContainer',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('INTAKE_YEAR'),
				name : 'INTAKE_YEAR',
				itemId : 'intakeYear',
				displayField:'value',
				valueField:'id',
				width: 256,
				typeAhead:true,
				forceSelection:true,
				hidden:true,
				minChars:3,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.IntakeYearStore');
						combo.bindStore(store)
					}
				}

			},
			{
	            xtype: 'customcombobox',
	            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
	            name: 'ACAD_LOC_ID',
	            itemId:'academyLocationCombo',
	            editable: true,
	            store: 'user.UserAcademyLocationStore',
	            displayField: 'value',
	            valueField: 'id',
	            width: 256,
	            matchFieldWidth:true,
	            allowBlank:false,
	            minChars:3,
	            typeAhead:true,
	            forceSelection :true,
	            hidden : true,
	            queryParam:'qry',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
	        },
			{
				xtype: 'customcombobox',
				width: 256,
                name: 'programId',
                itemId: 'programItemId',
                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
                valueField: 'id',
                displayField: 'valueCode',
                minChars:3,
                allowBlank: false,
	            forceSelection : true,
                queryParam:'programName',
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listeners: {
                    render: function(combo) {
                    	var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
                        combo.bindStore(store);
                    }
                },
                    listConfig: {
    	 				listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	 				loadingText: getCommonTranslation('SEARCHING'),
    	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	 				getInnerTpl: function() {
    	 					return '<div class="search-item">' +
    	 					 '{code} / {value}'+ 
    	 					'</div>';
    	 				}
    	 			}
			},{
				xtype: 'customcombobox',
                name: 'batchId',
                itemId: 'batchItemId',
                fieldLabel: getPersonModuleTranslation('BATCH'),
                disabled:true,
                editable: false,
                width: 256,
                queryMode: 'local',
                displayField: 'value',
                valueField: 'id',
                allowBlank: false,
	            forceSelection : true,
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
                        combo.bindStore(store);
                    }
                }
			},
			{			
				xtype : 'multiselectcombofield',
				cls:'commonAutoHeightMultiselectField',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				autoloadStore: true,
				name : 'multiProgram',
				itemId : 'multiProgramItemId',      	   
				displayField : 'valueCode',
				disabled:true,
				store:Ext.create('Academia.store.program.ProgramConfigured'),
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : true,
				width: 256,
				hidden : true,
				queryMode:'local',
				matchFieldWidth:true,
				/*listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.program.ProgramConfigured');
						combo.bindStore(store);
					}
						},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				}*/
			},
			{
				xtype : 'multiselectcombofield',
				cls:'commonAutoHeightMultiselectField',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				autoloadStore: false,
				name : 'BATCH_NAME',
				itemId : 'batch',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : true,
				maxLength:25000,
				hidden : true,
				width: 256,
				queryMode:'local',
				disabled:true,
				editable: false,
				matchFieldWidth:true,
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.program.ConfiguredBatchListStore');
						combo.bindStore(store);
					}
						},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				}
			},
			{
				xtype : 'multiselectcombofield',
				cls:'commonAutoHeightMultiselectField',
				fieldLabel: getEnquiryTranslation('SEAT_TYPE'),
				autoloadStore: false,
				name: 'SEAT_TYPE',
				itemId:'seatType',
				displayField: 'value',
				valueField: 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : true,
				//maxLength:25000,
				hidden : true,
				width: 256,
				queryMode: 'local',
				disabled:false,
				editable: true,
				matchFieldWidth:true,
				forceSelection : true,
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.program.ConfiguredSeatTypeListStore');
						combo.bindStore(store);
					}
						},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				},
			}]
			},{
				xtype : 'fieldcontainer',
				width: 536,
				layout : 'hbox',
				defaults: {
					labelAlign: 'top'
				},
				items : [{
					xtype: 'customcombobox',
	                name: 'periodId',
	                itemId:'periodItemId',
	                disabled:true,
	                editable: false,
	                width: 256,
	                displayField: 'value',
	                valueField: 'id',
	                queryMode: 'local',
	                fieldLabel: getPersonModuleTranslation('PERIOD'),
	                listeners: {
	                    render: function(combo) {
	                        var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
	                        combo.bindStore(store);
	                    },
	                    select:function(obj,record){
	                    	var periodId = record[0].get("id");
	                    	var  section = obj.nextSibling();
	                    	
	                    	section.setDisabled(false);
	                    	section.reset();
	                    	
	                    	var store = section.getStore();
	                    	
	                      	store.proxy.extraParams = {
	                      			periodId : periodId
	     					};
	                      	store.load();
	                    	
	                    }
	                }
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('SECTION'),
					width: 256,
					labelAlign: 'top',
					name : 'sectionId',
					itemId : 'sectionItemId',
					store:'attendance.SectionAndFacultyByPeriodID',
					displayField : 'sectionCode',
					valueField : 'sectionId',
					typeAhead : true,
					disabled:true,
					forceSelection : true,
				}]
			}]},{
				xtype:'fieldcontainer',
				layout : 'hbox',
				cls: 'customSearchPanelBtnsFieldContainerCls',
				style:{
	    			'margin-left':'-32px !important'
	    		},
				items:[{
		           	 xtype: 'button',
		        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
		             itemId: 'downoladBtnId',
		             hidden:false,
	     			 formBind: true,
		             ui: 'CustomBtnSubmit'
		        },{
	                xtype: 'button',
	                text: getCourseTxCommonTranslation('RESET'),
	                itemId: 'resetBtn',
	                //buttonAlign: 'left',
	                ui: 'CustomBtnCancel',
	                scale: CONSTANTS.BUTTONSIZE
	            }]
			}]
});
