/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.personinfo.student.StudentAcademicTopicUploadForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.studentacademictopicuploadform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items: [{
		xtype:'uploadoptionradiogroup',
		width: 300,
		margin: 0,
		itemId:'studentAcademicTopicUploadOptionRadioGroupItemId',
	},{
		xtype : 'fieldcontainer',
		width : 694,
		itemId:'templateTopicContainer',
		layout : 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items : [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('TEMPLATE_IMPORT_TYPE'),
			itemId: 'templateTypeId',
			name: 'templateType', 
			width: 256,
			store:'student.studentprofile.StudentTemplateTypeStore',
			valueField: 'name',
			displayField: 'value',
			forceSelection: true,
			allowBlank:false						
		},{
			xtype: 'customcombobox',
			name: 'importUtilityMasterId',
			itemId:'moduleName',
			store:'importutility.ModuleName',
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			typeAhead:true,
			readOnly:true,
			forceSelection:true,
			allowBlank:false
		}]
	},{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 536,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		style:{
			'margin-left':'-32px !important'
		},
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'uploadId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
