/**
 * Student Enrollment form with search REsult Grid
 */
Ext.define('Academia.view.personinfo.student.StudentBachelorEnrollmentGenerationForm', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentbachelorenrollmentgenerationform',
	frame: false,
	method : 'POST',
	//cls:'customSearchPanel',
	standardSubmit : false,
    items: [{
        xtype: 'fieldcontainer',
        layout: 'vbox',
        items: [{
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width: 256
        	},
        	items: [{
        		xtype: 'customcombobox',
        		name: 'programId',
        		itemId: 'programId',
        		fieldLabel: getPersonModuleTranslation('PROGRAM'),
        		store:'common.ProgramByAcAndLoIdStore',
        		editable: false,
        		valueField: 'id',
        		displayField: 'value',
        		allowBlank:false
        	},{
        		xtype: 'customcombobox',
        		name: 'batchId',
        		itemId: 'batchId',
        		fieldLabel: getPersonModuleTranslation('BATCH'),
        		store:'program.programbatchdetail.BatchStore',
        		disabled:true,
        		editable: false,
        		queryMode: 'local',
        		displayField: 'value',
        		valueField: 'id',
        		allowBlank:false
        	},{
        		xtype: 'customcombobox',
        		itemId:'periodId',
        		name: 'periodId',
        		fieldLabel: getPersonModuleTranslation('PERIOD'),
        		disabled:true,
        		editable: false,
        		store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
        		displayField: 'value',
        		valueField: 'id',
        		queryMode: 'local',
        		allowBlank:false
        	}]
        }, {
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width: 256
        	},
        	items: [{
        		xtype: 'textfield',
        		name: 'collegeNo',
        		itemId: 'collegeNo',
        		fieldLabel: getPersonModuleTranslation('COLLEGE_NO'),
        		allowBlank:false
        	},{
        		xtype: 'numberfield',
        		name: 'padding',
        		itemId: 'paddingId',
        		fieldLabel: getPersonModuleTranslation('PADDING'),
        		minValue:0,
        		allowBlank:false
        	},{
        		xtype: 'numberfield',
        		name: 'start',
        		itemId: 'generationStartId',
        		fieldLabel: 'Start',
        		minValue:0,
        		allowBlank:false
        	}]
        }, {
        	xtype: 'fieldcontainer',
        	width: '100%',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
        	items: [{
        		xtype: 'button',
        		text: getPersonModuleTranslation('GENERATE_ENROLLMENT'),
        		itemId: 'generateEnrollmentButtonId',
        		buttonAlign: 'right',
        		ui: 'CustomBtnSubmit',
        		scale: CONSTANTS.BUTTONSIZE,
        		formBind: true
        	},{
    			xtype: 'button',
    			itemId: 'resetBtn',
    			text: getCommonTranslation("RESET"),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		}]
        }]
    }]
});