/**
 * @author Amit G
 * This is used to show CONDITIONS_FOR_ADMISSION for Student Profile
 */
Ext.define('Academia.view.personinfo.student.StudentConditionsForAdmission', {
	 extend: 'Ext.form.Panel',
    alias: 'widget.studentconditionsforadmission',
    plugins: "formlabelrequired",  
    //title: getAdmissionTranslation('CONDITIONS_FOR_ADMISSION'),
    autoScroll: true,
    style: {
    	margin: '12px 0 0 8px !important;'
    },
    items: [{
    	xtype: 'form',
    	itemId: 'studentconditionsforadmissionFormId',
    	standardSubmit: false,
    	items:[{
    		xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 256,
    			labelAlign:'top'
    		},
    		items: [{
    			xtype: 'hidden',
    			name: 'id',
    			itemId: 'Id'
    		},{
    			xtype: 'textarea',
    			fieldLabel: getAdmissionTranslation('CONDITIONS_APPLICABLE'),
    			width: 465,
    			name: 'conditionApplicable',
    			itemId: 'conditionApplicableId',
    			style:{'margin-left':'10px'},
    			allowBlank: true
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			labelAlign: 'top',
    			width: 256
    		},items: [{
    			xtype: 'studentconditionsdocumentlist',
    			itemId: 'studentconditionsdocumentlistId',
    			width: 465,
    			isFixHeightGrid: true,
    			isFixWidthColums: true,
    			minHeight: 0,
    			cls: 'no-empty-placeholder-grid',
    			style: {
    				'margin-left': '-22px !important'
    			}
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			labelAlign: 'top',
    			width: 256
    		},items: [{
    			xtype: 'button',
    			text: getCommonTranslation('SAVE'), 
    			itemId: 'btnSave',
    			ui: 'CustomBtnSubmit',
    			style:{'margin-left':'10px'},
    			scale: CONSTANTS.BUTTONSIZE,
    			formBind : true
    		}]
    	}]
    }]
});