/**
 * @author <a href="vyabha.thakur@serosoft.in">Vyabha Thakur</a>
 *
 */
Ext.define('Academia.view.personinfo.student.StudentEthicsClearanceLetterForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentethicsclearanceletterform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
    items: [{
        xtype: 'hidden',
        itemId: 'student_ethics_clearance_letter_hidden_field',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [ {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('APPROVAL_DATE'),
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId: 'approvalDate',
            name: 'approvalDate',
            allowBlank: false,
            vtype : 'daterange',
            listeners: {
          	  render: function(field) {
          		  return dateFormatRender(field);
          	  }
            }
        }, {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('APPROVAL_PERIOD_START_DATE'),
            itemId: 'approvalPeriodStartDate',
            name: 'approvalPeriodStartDate',
            endDateField : 'approvalPeriodEndDate',
            allowBlank: false,
            vtype : 'daterange',
            listeners: {
          	  render: function(field) {
          		  return dateFormatRender(field);
          	  }
            }
        }]
    
    }, {

    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('APPROVAL_PERIOD_END_DATE'),
            itemId: 'approvalPeriodEndDate',
            name: 'approvalPeriodEndDate',
            startDateField : 'approvalPeriodStartDate',
            allowBlank: false,
            vtype : 'daterange',
            listeners: {
          	  render: function(field) {
          		  return dateFormatRender(field);
          	  }
            }
        },{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('CO_INVESTIGATOR_NAME'),
            itemId: 'coInvestigatorName',
            name: 'coInvestigatorName',
            store: 'common.AllUserBySmartSearchFPR',
            allowBlank: true,
            queryParam:'codeOrName',
            triggerAction: 'all',
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            enableKeyEvents  : 'true',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			minChars:3,
			displayField: 'value', 
			valueField: 'id',
			/*displayTpl: new Ext.XTemplate(
             		'<tpl for="."between=" ">',
             		'{[typeof values === "string" ? values : values["code"]]}' +
             		'</tpl>'
            )*/
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        }]
    },{

    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('PROJECT_NUMBERID'),            
            itemId: 'projectNumberID',
            readOnly: false,
            maxLength:10,
            enforceMaxLength :true,
            stripCharsRe: /[^0-9a-zA-Z]/g,
            name: 'projectNumberID',
            allowBlank: false
        },{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('AUDIT_DATE'),
            itemId: 'auditDate',
            name: 'auditDate',
            editable : false,
            startDateField : 'auditDate',
            listeners: {
            	render: function(obj) {
            		obj = dateFormatRender(obj);
            		obj.setValue(new Date());
            	}
            },
            allowBlank: false,
            vtype : 'daterange'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        
        items: [ {
        	xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('AUDIT_ID'),            
            itemId: 'auditId',
            name: 'auditId',
            readOnly : true,
            allowBlank: false
        }]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studentethicsclearanceletterdocumentgrid',
			itemId:'studentethicsclearanceletterdocumentgridId',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },{
			 xtype: 'button',
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadStudentEthicsClearanceLetterItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
