Ext.define('Academia.view.personinfo.student.StudentGraduateCertificateWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.studentgraduatecertificatewindow',
	modal: true,
	frame: true,
	title:getExaminationTranslation('PRINT_GRADUATION_CERTIFICATE'),
	items: [{		
		xtype: 'form',
		standardSubmit: false,
		plugins:"formlabelrequired",    
		items:[ {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype : 'customcombobox',
				name : 'studentAcademyLocation',
				itemId:'studentAcademyLocationId',
				fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
				store:Ext.create('Academia.store.student.studentprofile.StudentsFindByAlStore'),
				valueField : 'id',
				displayField : 'value',
				minChars:3,
				typeAhead : false,
				matchFieldWidth:true,
				forceSelection:true,
				hideTrigger:false,
				allowBlank:false,
				triggerAction: 'all',
				queryParam:'qry',
				//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'PROGRAM',
				store: Ext.create('Academia.store.servicerequest.placementrequest.PlacementPrograms'),
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				itemId :'programId',
				valueField: 'programId',
				displayField: 'valueSecondValue',
				typeAhead: true,
				forceSelection: true,
				triggerAction: 'all',
				queryParam:'programName',
				minChars:3,
				allowBlank:false,
				matchFieldWidth:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				name: 'BATCH',
				editable: false,
				fieldLabel: getCompletionModuleTranslation('BATCH'),
				store: Ext.create('Academia.store.facilitiesresources.resourcebooking.AllBatchesStore'),
				displayField: 'value',
				valueField: 'id',
				itemId :'batchId',
				disabled : true,
				allowBlank:false,
			},/*{
				xtype: 'customcombobox',
				name: 'SECTION',
				store: Ext.create('Academia.store.completion.completionform.SectionByBatch'),
				fieldLabel: getCompletionModuleTranslation('SECTION'),
				editable: false,
				valueField: 'id',
				displayField: 'value',
				itemId :'sectionId',
				disabled : true,
				allowBlank:false,
			}*/]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype: 'button',
				itemId: 'btnDownloadCertificate',
				text : getCommonTranslation('DOWNLOAD_CERTIFICATE'),
				buttonAlign : 'left',
				ui : 'CustomBtnThird',
				scale : CONSTANTS.BUTTONSIZE,
				disabled:true
			}]	
		}]
	}]
});
