/**
 * @Author Priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.student.StudentHoldReportRemoveHoldForm', {
	extend: 'Ext.window.Window',
	alias: 'widget.studentholdreportremoveholdform',
	title: getCommonTranslation('REMOVE_HOLD'),
	frame: true,
	autoScroll:true,
	modal:true,
	layout : {
		type  : 'hbox',
		pack  : 'center',
		align : 'middle'
	},
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'studentholdreportremoveholdform',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256,
		},
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			width: 'auto',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			layout: {
				type: 'hbox'
			},
		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			layout: {
				type: 'hbox'
			},
			items: [ {
				xtype: 'datefield',
				name: 'removaltDateHoldReport',
				itemId:'removaltDateHoldReport',
				fieldLabel: getCommonTranslation('REMOVAL_DATE'),
				allowBlank: false,
				readOnly: false,
	    		  maxValue: new Date(),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);
						obj.setValue(new Date());
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'removalByHoldReport',
				itemId:'removalByHoldReport',
				fieldLabel: getCommonTranslation('REMOVED_BY'),
				store:Ext.create('Academia.store.coursetransaction.sectionmanagement.FacultyIdValueSmartSearch'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				minChars:3,
				allowBlank: false,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}

			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			layout: {
				type: 'hbox'
			},
			items: [{
				xtype: 'textarea',
				name: 'removalReasonHoldReport',
				itemId:'removalReasonHoldReport',
				maxLength : 5000,
				width: 465,
				fieldLabel: getCommonTranslation('REASON_TO_REMOVE_HOLD'),
				allowBlank: false,

			}]
		}, {
			xtype: 'fieldcontainer',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SUBMIT'),
				itemId: 'submitButtonHoldReport',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelButtonHoldReport',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});