/**
 *  Dharmendra.p
 */

Ext.define('Academia.view.personinfo.student.StudentStatusCSMWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.studentstatuscsmwindow',
	modal: true,
	autoScroll:true,
	title: getCommonTranslation('STUDENT_STATUS_CSM'),
	maxHeight:600,
	items: [{
		xtype: 'form',
		method: 'POST',
		autoScroll:true,
		margin: 0,
		bodyPadding: '10 10 10 10',
		layout: 'anchor',
		standardSubmit: false,
		plugins:"formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256,
//			anchor: '100%'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'studentStatus',
			itemId: 'studentStatusItemId',
			store: 'student.studentprofile.StudentStatusCSMStore',
			fieldLabel: getCommonTranslation('STATUS'),
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			forceSelection: true,
			editable: false
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'saveBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'cancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				handler :function(button) {
					button.up('window').close();
				}
			}]	
		}]
	}]
});