/**
 * @author Abhishek Chouhan
 * 
 */
Ext.define('Academia.view.placement.createcompany.CreateCompanyForm', {
	//extend: 'Ext.form.FormPanel',
	extend : 'Academia.view.common.DynamicFieldForm',
	//extend:'Academia.view.common.IdGeneratorCustomForm',
	columns : 2,
	alias : 'widget.createcompanyform',
	formCode : 'companyForm',
	title : getPlacementTranslation('COMPANY'),
	autoScroll : true,
	frame : true,
	modal : true,
	standardSubmit : false,
	method : 'POST',
	style : {
		marginLeft : CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	standardSubmit : false,
	defaults : {
		labelAlign : 'top'
	},
	plugins : "formlabelrequired",
	cls:'x-form-fixed-footer-parent',
	items : [ {

		xtype : 'fieldcontainer',
		layout : 'hbox',
		width : 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [ {
			xtype : 'hidden',
			name : 'academyLocationId',
			itemId : 'academyLocationId',
		},{
		    xtype: 'hidden',
		    name: 'version',
		},{
			xtype : 'hidden',
			name : 'addressId',
			itemId : 'addressId',
		},{
			xtype : 'textfield',
			name : 'companyCode',
			itemId : 'companyCode',
			fieldLabel : getPlacementTranslation('COMPANY_CODE'),
			allowBlank : false,
			enforceMaxLength : true,
			maxLength : 10,
		}, {
			xtype : 'textfield',
			name : 'companyRegistrationNum',
			itemId : 'companyRegistrationNum',
			fieldLabel :  getCommonTranslation('COMPANY_REGISTRATION_NUMBER'),
			enforceMaxLength : true,
			maxLength : 25,
		}, {
			xtype : 'textfield',
			name : 'companyName',
			itemId : 'companyName',
			fieldLabel : getPlacementTranslation('COMPANY_NAME'),
			allowBlank : false,
			enforceMaxLength : true,
			maxLength : 90,
		}]
	},{

		xtype : 'fieldcontainer',
		layout : 'hbox',
		width : 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			name : 'printName',
			itemId : 'printName',
			fieldLabel : getCommonTranslation('PRINT_NAME'),
			allowBlank : false,
			enforceMaxLength : true,
			maxLength : 255,
		} ,{
			xtype : 'textfield',
			name : 'companySkillLevyNum',
			itemId : 'companySkillLevyNum',
			fieldLabel : getCommonTranslation('SKILL_LEVY_NUMBER'),
			enforceMaxLength : true,
			maxLength : 25,
		},,{
			xtype : 'textfield',
			name : 'industryCategoryDes',
			itemId : 'industryCategoryDes',
			fieldLabel :getCommonTranslation('INDUSTRY_CATEGORY_DES'),
			enforceMaxLength : true,
			maxLength : 255,
		},]
	},{
		xtype: 'customcombobox',
		name: 'typeOfAgreement',
		itemId:'typeOfAgreement',
		width: 256,
		fieldLabel: getPlacementTranslation('TYPE_OF_AGREEMENT'),
		store: 'placement.createcompany.TypeOfAgreementStore',
		valueField: 'id',
		displayField: 'value',
		editable:false
	},{
		xtype: 'customcombobox',
		name: 'locationCombo',
		itemId:'locationComboId',
		width : 462,
		fieldLabel: getCommonTranslation('LOCATION_CODE_NAME'),
		store: 'placement.createcompany.LocationStore',
		valueField: 'id',
		displayField: 'valueCode',
		queryParam:'name',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		minChars:3,
		allowBlank : false,
		typeAhead:false,
		forceSelection:true,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		triggerAction: '',
		hideTrigger:false,
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		/*	getInnerTpl: function() {
				return '<div class="search-item">' +
				'{studentCode} / {studentName}' +
				'</div>';
			}*/
		}
		
		
		
	},{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		itemId:'locationCodeOrName',
		width : 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
			
		},
		style:{
			marginTop:'13px'	
		},
		items : [ {
			xtype : 'textfield',
			name : 'locationCode',
			itemId : 'locationCode',
		//	fieldLabel : getPlacementTranslation('Location Code'),
			allowBlank : false,
			enforceMaxLength : true,
			maxLength : 10,
			enableKeyEvents:true,
			emptyText: getCommonTranslation('ENTER_LOCATION_CODE'),
		}, {
			xtype : 'textfield',
			name : 'locationName',
			itemId : 'locationName',
			//fieldLabel : getPlacementTranslation('Location Name'),
			allowBlank : false,
			enforceMaxLength : true,
			maxLength : 100,
			enableKeyEvents:true,
			emptyText: getCommonTranslation('ENTER_LOCATION_NAME'),
		} ]

	}, {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		width : 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [ {
			xtype : 'datefield',
			name : 'startDate',
			itemId : 'startDate',
			allowBlank : false,
			vtype: 'daterange',
			fieldLabel : getPlacementTranslation('START_DATE'),
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			endDateField :'tillDate',

		}, {
			xtype : 'datefield',
			name : 'tillDate',
			itemId : 'tillDate',
			vtype: 'daterange',
			allowBlank : true,
			fieldLabel : getPlacementTranslation('TILL_DATE'),
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			startDateField : 'startDate',

		} ]
	},{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		width : 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'datefield',
			name : 'dateCompanySigned',
			itemId : 'dateCompanySigned',
			vtype: 'daterange',
			fieldLabel : getPlacementTranslation('DATE_COMPANY_SIGNED'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},

		}, {
			xtype : 'datefield',
			name : 'dateFBCSigned',
			itemId : 'dateFBCSigned',
			vtype: 'daterange',
			fieldLabel : getPlacementTranslation('DATE_FBC_SIGNED'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},

		}, ]
	}, {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		width : 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [ {
			xtype : 'customcombobox',
			fieldLabel : getPlacementTranslation('COMPANY_STATUS'),
			value : true,
			allowBlank : false,
			store : 'common.StatusComboStore',
			itemId : 'status',
			name : 'status',
			valueField : 'value',
			forceSelection:true,
            editable:false,
			displayField : 'name',
		},/* {
			style : {

				marginTop : '28px'
			},
			xtype : 'button',
			text : getCommonTranslation('MANAGE_ADDRESS'),
			allowBlank : false,
			itemId : 'personAddressDisplayField4',
			name : 'personAddressDisplayField4',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}*/ ]
	}, {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		width : 'auto',
		defaults : {
			width : 256,
			labelAlign : 'top'
		},
		items : [ {
			xtype : 'photouploadform',
			itemId : 'logoUploadField',
			name : 'path',
			listeners:{
				beforeRender: function(){
					this.down('#photoFileImage').setFieldLabel(getCommonTranslation('UPLOAD_LOGO'));
				}
		    }
		}]
	}, {
		xtype : 'fieldcontainer',
		width : '100%',
		cls:'form-fixed-footer',
		items : [ {
			xtype : 'button',
			action : 'Submit',
			text : getPlacementTranslation('SAVE'),
			formBind : true,
			itemId : 'saveCompanyBtn',
			name : 'saveCompanyBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE
		}, {
			xtype : 'button',
			text : getPlacementTranslation('RESET'),
			ui : 'CustomBtnCancel',
			name : 'CancelBtn',
			itemId : 'CancelBtn',
			scale : CONSTANTS.BUTTONSIZE
		} ]

	} ]

});