/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.placement.createcompany.CreateCompanyGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.createcompanygrid',
	store: 'placement.createcompany.CreateCompanyGridStore',
	title: getPlacementTranslation('LIST_OF_COMPANY'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'placement.createcompany.CreateCompanyGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
    	xtype: 'button',
    	text: getCommonTranslation('ALA_ADD_ADDRESS'),
    	itemId: 'addAddressItemId' 
    },],
	columns: [{
		header:  getPlacementTranslation('COMPANY_CODE'),
		dataIndex: 'companyCode',
		flex:.8,
		sortable:true
	},{
		header:  getPlacementTranslation('COMPANY_NAME'),
		dataIndex: 'companyName',
		flex:1,
		sortable:true
	},{
		header:  getPlacementTranslation('LOCATION_CODE'),
		dataIndex: 'locationCode',
		flex:1,
		sortable:true
	},{
		header:  getPlacementTranslation('LOCATION_NAME'),
		dataIndex: 'locationName',
		flex:1,
		sortable:true
	},{
		header:  getPlacementTranslation('START_DATE'),
		dataIndex: 'startDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getPlacementTranslation('TILL_DATE'),
		dataIndex: 'tillDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getPlacementTranslation('STATUS'),
		dataIndex: 'status',
		flex:1,
		hidden:true,
		sortable:true,
		renderer: function(value,record) {
			if(!isNullOrEmpty(value)) {
				if(value){
					return '<span style="color:green;">' + getCommonTranslation('ACTIVE') + '</span>';
				}else{
					return '<span style="color:red;">' + getCommonTranslation('INACTIVE') + '</span>';
				}
			}
		}
	},{
		header:  getCommonTranslation('COMPANY_REGISTRATION_NUMBER'),
		dataIndex: 'companyRegistrationNum',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header:  getCommonTranslation('SKILL_LEVY_NUMBER'),
		dataIndex: 'companySkillLevyNum',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header:  getCommonTranslation('INDUSTRY_CATEGORY_DES'),
		dataIndex: 'industryCategoryDes',
		flex:1,
		hidden:true,
		sortable:true
	}]
});
