/**
 * Priyanshi Sharma
 */
Ext.define('Academia.view.placement.placementcampus.PlacementCampusFollowUpForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.placementcampusfollowupform',
	autoScroll: true,
	title: getEnquiryTranslation('FOLLOW_UP_DETAIL'),
	cls:'x-form-fixed-footer-parent',
	id:'plcDrivefollowUpDetailFormId',
	//maxHeight: 600,
	items: [{
		xtype: 'form',
		plugins: "formlabelrequired",
		defaults: {
			labelAlign: 'top'
			//width: 256
		},
		items: [{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'nestedJsonCombo',
				name : 'plcDrivefollowupname',
				itemId : 'plcDrivefollowupname',
				fieldLabel : getPlacementTranslation('FOLLOW_UP_NAME'),
				store : 'placement.placementcampus.PlacementFollowupNameStore',
				valueField : 'id',
				displayField : 'value',
				allowBlank : false
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'datefield',
				fieldLabel : getEnquiryTranslation('FOLLOW_UP_DATE'),
				name: 'plcDriveactualFollowUpDate',
				itemId:'plcDriveactualFollowUpDate',
				//endDateField:'plcDriveactualFollowUpDate',
				maxValue:new Date(),
				allowBlank:false,
				listeners: {
				  render: function(obj) {
				   obj = dateFormatRender(obj);
				   obj.setValue(new Date());
				}
				}
			},
				{
					xtype : 'timefield',
					name : 'plcDrivefollowupTime',
					itemId : 'plcDrivefollowupTime',
					editable : true,
					format : 'H:i',
					readOnly : false,
					value : new Date(),
					fieldLabel : getPlacementTranslation('FOLLOW_UP_TIME')
				},
				{
					xtype : 'nestedJsonCombo',
					name : 'plcDrivefollowupuser',
					itemId : 'plcDrivefollowupuser',
					fieldLabel : getEnquiryTranslation('FOLLOW_UP_USER'),
					editable : false,
					readOnly : true
				}]
		},
		{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top',
				regex : /[a-zA-Z0-9]+/
			},
			items : [{
					xtype : 'nestedJsonCombo',
					fieldLabel : getPlacementTranslation('FOLLOW_UP_ACTIVITY'),
					name : 'plcfollowupActivityTo',
					itemId : 'plcfollowupActivityTo',
					store : 'placement.placementcampus.PlacementFollowupActivityToStore',
					valueField : 'id',
					displayField : 'contactName'
					//queryParam:'placementDriveId'
				},
				{
					xtype : 'textfield',
					name : 'plcDriveemailAdress',
					itemId : 'plcDriveemailAdress',
					editable : false,
					vtype : 'email',
					fieldLabel : getCommonTranslation('EMAIL'),
					maxLength : 100,
					enforceMaxLength : true
				},
				{
					xtype : 'fieldcontainer',
					labelSeparator : '',
					fieldLabel : getCommonTranslation('MOBILE_NO'),
					itemId : 'plcDetail_cellNumber',
					name : 'plcDetail_cellNumber',
					editable : false,
					readOnly : true,
					allowBlank : true,
					layout : 'hbox',
					width: 256,
					labelAlign : 'top',
					items : [
							{
								xtype : 'customcombobox',
								valueField : 'isdCode',
								displayField : 'isdCode',
								store:Ext.create('Academia.store.common.CountryStore'),
								name : 'plcDriveellCountryCode',
								itemId : 'plcDriveellCountryCode',
								triggerAction : 'all',
								name : 'phoneCountryCode',
								width : 80,
								typeAhead : true,
								editable : false,
								readOnly : true,
								emptyText : 'Code',
								allowBlank : true,
								minChars : 1
							},
							{
								xtype : 'numberfield',
								name : 'plcDrivemobileNumber',
								itemId : 'plcDrivemobileNumber',
								minLength : 0,
								maxLength : 11,
								width : 150,
								readOnly : true,
								hideTrigger : true,
								
							} ]
				}]
		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
					xtype : 'nestedJsonCombo',
					name : 'plcDrivefollowUpActivityType',
					itemId : 'plcDrivefollowUpActivityType',
					store : 'placement.placementcampus.PlacementFollowupActivityTypeStore',
					fieldLabel : getPlacementTranslation('FOLLOW_UP_ACTIVITY_TYPE'),
					valueField : 'id',
					displayField : 'value',
					allowBlank : false
				},
				{
					xtype: 'textarea',
					width: 455,
					maxLength : 255,
					name : 'plcDriveReasonForFollowUp',
					itemId : 'plcDriveReasonForFollowUp',
					fieldLabel : getPlacementTranslation('REASON_FOR_FOLLOW_UP'),
					allowBlank : false
				}]
		},
		{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype : 'nestedJsonCombo',
				name : 'plcDrivefollowUpStatus',
				itemId : 'plcDrivefollowUpStatus',
				fieldLabel : getPlacementTranslation('FOLLOW_UP_STATUS'),
				store : 'placement.placementcampus.PlacementFollowupStatusStore',
				displayField : 'value',
				valueField : 'id',
				allowBlank : false
			}]
		}, {
			xtype: 'textarea',
			width: 455,
			maxLength : 255,
			name: 'plcDriveremark',
			itemId: 'plcDriveremark',
			fieldLabel: getEnquiryTranslation('FOLLOW_UP_REMARKS'),
		}, {
			xtype: 'checkboxfield',
			boxLabel:getEnquiryTranslation('SCHEDULE_NEXT_FOLLOW_UP'),
			name:'plcDrivewhetherNextFollowUp',
			itemId:'plcDrivewhetherNextFollowUp'
		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'datefield',
				name: 'plcDrivenextFollowUpDate',
				itemId: 'plcDrivenextFollowUpDate',
				vtype: 'daterange',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				fieldLabel: getEnquiryTranslation('NEXT_FOLLOW_UP_DATE'),
			//	allowBlank: false,
				minValue:new Date(),
				hidden:true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}, {
				xtype: 'nestedJsonCombo',
				name: 'plcDriveuserByAssignTo',
				itemId: 'plcDriveuserByAssignTo',
				store: 'placement.placementcampus.PlacementCampusAssignedToStore',
				fieldLabel: getEnquiryTranslation('ASSIGN_TO'),
				valueField: 'id',
				displayField: 'value',
				queryParam: 'name',
				minChars: 3,
			//	allowBlank: false,
				typeAhead: false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection: true,
				hidden:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			cls: 'form-fixed-footer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				itemId: 'plcDrivefollowdetail_savebtn',
				name: 'plcDrivefollowdetail_savebtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}]
		}
		]
	}]
});