/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.placement.placementjob.PlacementJobFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.placementjobfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			
			xtype: 'customcombobox',
			name: 'academyLocation',
			itemId:'academyLocation',
			store:'placement.placementcampus.PlacementJobPostingROStore',
			allowBlank:true,
			fieldLabel: getPlacementTranslation('RECRUITING_ORGANIZATION'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'academyLocationName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width: 256,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
			
		},{
			xtype: 'customcombobox',
			name: 'jobLocation',
			itemId:'jobLocation',
			store:'placement.placementjob.PlacementJobLocationListStore',
			displayField:'value',
    	    emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
			valueField:'id',
			editable: true,	    
			queryParam:'placementJobLocation',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width: 256,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			},
			fieldLabel: getPlacementTranslation('JOB_LOCATIONS'),
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			
			xtype: 'customcombobox',
			name: 'placementcampus',
			itemId:'placementcampusItemId',
			store:'placement.placementcampus.PlacementCampusStore',
			fieldLabel: getPlacementTranslation('PATH_PLACEMENT_CAMPUS_CODE_CAMPUS'),
    	    emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
    	    displayField:'valueCode',
			valueField:'id',
			editable: true,	    
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width: 256,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
			
		},{
			xtype: 'customcombobox',
            name: 'status',
            itemId:'statusItemId',
            store:'common.StatusComboStore',
            displayField:'name',
            valueField:'id',
            forceSelection:true,
            editable:false,
            typeAhead:true,
            fieldLabel:getCommonTranslation('STATUS'),
		}]
		
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true,
			margin: '0 44 0 0'
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
