/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.placement.placementjob.PlacementJobGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementjobgrid',
	store: 'placement.placementjob.PlacementJobGridStore',
	title: getCommonTranslation('PlacementJob'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'placementjobtabstructure':1
		}
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'placement.placementjob.PlacementJobGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[{
			text: getPlacementTranslation('JOB_LOCATIONS'),
			itemId: 'btnJobLocations',
		},{
			text:getPlacementTranslation('CONFIGURE_STAGE'),
			itemId:'btnConfigureStage'
		}],
		 listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [/*{
		header:  getExaminationTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
	},*/{
		header:  getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE'),
		dataIndex: 'jobTitle',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_RECRUITING_ORGANIZTION'),
		dataIndex: 'placementAcademyLocation',
		flex:.1,
		/*renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;
		}*/
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_COORDINATOR'),
		dataIndex: 'placementCordinator',
		flex:.1,
		sortable:true,
		/*renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;
		}*/
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_FROM_DATE'),
		dataIndex: 'dateFrom',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_TO_DATE'),
		dataIndex: 'dateTo',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_DESIGNATION'),
		dataIndex: 'jobTitle',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_NO_OF_POSITIONS'),
		dataIndex: 'noOfPosition',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_NO_OF_LOCATIONS'),
		dataIndex: 'noOfLocation',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_SELECTION_PROCESS'),
		dataIndex: 'slctnProcess',
		flex:.1,
		sortable:true,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;
		}
	},{
        header: getPlacementTranslation('JOB_DESCRIPTION_DOCUMENT'),
        dataIndex: 'jobPostingDocuments',
        flex: .1,
        hidden: true,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (value.length > 0) {
                    return "<a href='#'>" + value.length + "</a>";
                }
            }
            return '0';
        }
    }]
});

