/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.placement.placementjob.PlacementJobLocationForm',{
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.placementjoblocationform',
	autoScroll: false,
	method: 'POST',
	defaults: {
		labelAlign: 'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items : [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			name : 'placementJob',
			itemId:'placementJobItemId',
			fieldLabel : getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE'),
			allowBlank:false
		},{
			xtype: 'customcombobox',
			name: 'placementcampus',
			itemId:'placementcampusItemId',
			store:'placement.placementcampus.PlacementCampusStore',
			fieldLabel: getPlacementTranslation('PATH_PLACEMENT_CAMPUS_CODE_CAMPUS'),
			displayField:'value',
    	    emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
			valueField:'id',
			editable: true,	    
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width: 536,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
			
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'academyLocation',
			itemId:'academyLocation',
			store:'placement.placementcampus.PlacementCampusProgramPeriodALStore',
			allowBlank:true,
			fieldLabel: getPlacementTranslation('RECRUITING_ORGANIZATION'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:false,
			forceSelection:true
		},{
			xtype: 'customcombobox',
    		name:'campusCoordinator',
    		itemId:'campusCoordinator',
    		store: 'placement.placementcampus.placementCampusCoordinatorStore',
    		fieldLabel : getPlacementTranslation('PLACEMENT_CAMPUS_COORDINATOR'),
    		valueField: 'id',
    		displayField: 'value',
    		queryParam:'code',
    		minChars:3,
    		typeAhead:false,
    		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    		enableKeyEvents  : 'true',
    		hideTrigger:false,
    		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    		triggerAction: '',
    		forceSelection:true,
    		allowBlank:true,
    		listConfig: {
    			listeners: {
    				beforeshow: function(picker) {
    					picker.minWidth = picker.up('combobox').getSize().width;
    				}
    			},
    			loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{value}' +
    				'</div>';
    			}
    		}
			
		}]
		
	},{
		
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
    		itemId: 'selectionStageCombo',
    		name:'PROGRAM_SELECTION_PROCESS_STAGE_ID',
            //store: 'Academia.store.admission.selectionStage.SelectionStageFromSeatType',
    		fieldLabel: getAdmissionTranslation('SELECT_STAGE'),
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            width: 256,
            labelAlign: 'top',
            autoload: false,
            allowBlank: true
		},{
			xtype: 'datefield',
			name: 'startDate',
			itemId:'startDate',
			allowBlank:false,
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			fieldLabel:getPlacementTranslation('START_DATE')
		},{
			xtype: 'datefield',
			name: 'endDate',
			itemId:'endDate',
			allowBlank:false,
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
			fieldLabel:getPlacementTranslation('END_DATE')
		}]
		
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
    		itemId: 'selectionStageCombo',
    		name:'PROGRAM_SELECTION_PROCESS_STAGE_ID',
            //store: 'Academia.store.admission.selectionStage.SelectionStageFromSeatType',
    		fieldLabel: getPlacementTranslation('ELIGIBILITY_RULE'),
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            width: 256,
            labelAlign: 'top',
            autoload: false,
            allowBlank: true
		}]
		
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'textarea',
			name:'remarks',
			itemId:'remarks',
			width: 536,
			maxLength : 250,
			fieldLabel: getPlacementTranslation('REMARKS')
		}]
		
		
		
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE') ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			
			xtype: 'button',
			text: getPlacementTranslation('CANCEL'),
			ui: 'CustomBtnCancel',
			itemId: 'CancelBtn',
			scale: CONSTANTS.BUTTONSIZE
			
		}]
	}]
});
