/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.placement.placementjobapplication.PlacementJobApplicationForm',{
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.placementjobapplicationform',
	autoScroll: true,
	//bodyPadding:'10 10 10 10',
	frame:true,
	/*style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},*/
	method: 'POST',
	cls: 'x-form-fixed-footer-parent',
	defaults: {
		labelAlign: 'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items : [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'placementjobapplication',
			itemId:'placementjobapplicationItemId',
			store:'placement.placementcampus.PlacementCampusStore',
			fieldLabel: getPlacementTranslation('PATH_PLACEMENT_CAMPUS_CODE_CAMPUS'),
			allowBlank:false,
			displayField:'valueCode',
			valueField:'id',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width: 256,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
			
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		items : [ {
			xtype : 'button',
			text : getPlacementTranslation('GET_STUDENT_RECORD') ,
			itemId : 'getStudentRecord',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			text : getPlacementTranslation('MANAGE_APPLICATION_STATUS') ,
			itemId : 'manageApplicationStatus',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true,
			style: {
				marginLeft: '8px !important;'
			}
		}]
	},{
			xtype : 'placementjobapplicationapplyjobgrid',
			itemId:'applyjobapplication',
			width:'100%',
			margin:'0px'

	}]	
});
