/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.placement.placementjobapplication.PlacementSelectionProcessWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.placementselectionprocesswindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	height: '50%',
	width: '70%',
	title:getAdmissionTranslation('SELECTION_PROCESS_DETAILS'),
	items: [{
		xtype: 'form',
		method: 'POST',
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype:'fieldcontainer',
			itemId:'fieldcontainerId',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype:'displayfield',
				name : 'jobTitle',
				itemId:'jobTitle',
				fieldLabel:  getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE'),
			},{
				xtype:'displayfield',
				name : 'placementCampus',
				itemId : 'placementCampus',
				fieldLabel:  getPlacementTranslation('PATH_PLACEMENT_CAMPUS'),
			},{
				xtype:'displayfield',
				name : 'recruitingOrgName',
				itemId : 'recruitingOrgName',
				fieldLabel:  getPlacementTranslation('COMPANY'),
			},{
				xtype:'displayfield',
				name : 'selectionProcess',
				itemId : 'selectionProcess',
				fieldLabel:  getAdmissionTranslation('SELECTION_PROCESS'),
			}]
		}]
	},{
		xtype: 'grid',
		itemId : 'placementselectionprocessGrid',
        store:'placement.placementjobapplication.PlacementSelectionProcessStore',
		frame: false,
		border:true,
		autoScroll: true,
		title:getAdmissionTranslation('SELECTION_STAGE'),
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		features: [{
	        ftype: 'summary',
	        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
	    }],
		columns: [{
			header:  getAdmissionTranslation('SELECTIONSTAGE'),
			dataIndex: 'slctnProcessStage',
			flex:.1,
			sortable:true,
			renderer:function(value){
				if(!isNullOrEmpty(value))
					return value.value;
				else 
					return null;

			}	
		},{
			header:  getAdmissionTranslation('ENTRY_CRITERIA'),
			dataIndex: 'entryRule',
			flex:.1,
			sortable:true,
			renderer:function(value){
				if(!isNullOrEmpty(value))
					return value.value;
				else 
					return null;

			}
		},{
			header:  getAdmissionTranslation('MAXIMUM_SEATS'),
			dataIndex: 'maxSeat',
			flex:.1,		
		},{
			header:  getAdmissionTranslation('START_DATE'),
			dataIndex: 'startDate',
			flex:.1,
			renderer:function(date) {
				return dateRender(date);
			}
		},{
			header:  getAdmissionTranslation('END_DATE'),
			dataIndex: 'endDate',
			flex:.1,
			renderer:function(date) {
				return dateRender(date);
			}
		},] 	
	}]
});
