/**
 * @author Amit.Gupta
 */

Ext.define('Academia.view.placement.placementtype.PlacementTypeWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.placementtypewin',
	title:getPlacementTranslation('PLACEMENT_TYPE'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		formCode:'placementtypeForm',
		itemId:'placementtypewin',
		plugins : "formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			height: 65,
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'placementType',
				itemId:'placementType',
				allowBlank:false,
				fieldLabel: getPlacementTranslation('PLACEMENT_TYPE_NAME'),
			},{
				
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					labelAlign: 'top',
					itemId:'whetherCompletionid',
					fieldLabel: getPlacementTranslation('CONSIDER_FOR_PROGRAM_COMPLETION'),
					columns: 2,
					vertical: true,
					items: [{ boxLabel: getPlacementTranslation('YES'), name: 'whetherCompletion', inputValue: true},
					        { boxLabel: getPlacementTranslation('NO'), name: 'whetherCompletion', inputValue: false,checked:true}
					]
				}]
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 512,
				labelAlign: 'top'
			},
			items:[{
				xtype:'panel',
				width: '100%',
				items:[{
					xtype: 'radiogroup',
					labelAlign: 'top',
					itemId:'placementTerm',
					fieldLabel: getPlacementTranslation('PLACEMENT_TERMS'),
					columns: 2,
					vertical: true,
					items: [{ boxLabel: getPlacementTranslation('TEMPORARY_PLACEMENT'), name: 'placementTerm', inputValue: 'TEMPORARY_PLACEMENT'},
					        { boxLabel: getPlacementTranslation('PERMANENT_PLEACEMENT'), name: 'placementTerm', inputValue: 'PERMANENT_PLACEMENT'}
					]
				}]				
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					labelAlign: 'top',
					itemId:'whetherGradedItemId',
					fieldLabel: getPlacementTranslation('WHETHER_GRADED'),
					columns: 2,
					vertical: true,
					items: [{ boxLabel: getPlacementTranslation('YES'), name: 'whetherGraded', inputValue: true},
					        { boxLabel: getPlacementTranslation('NO'), name: 'whetherGraded', inputValue: false,checked:true}
					]
				}]				
			},{
				xtype: 'customcombobox',
				name: 'gradeOrMark',
				itemId:'gradeOrMark',
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.GradeAndMarkData',
				allowBlank:true,
				fieldLabel: getPlacementTranslation('GRADE_MARKS'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				disabled:true,
				forceSelection:true  	
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					labelAlign: 'top',
					itemId:'considerforRanking',
					fieldLabel: getPlacementTranslation('CONSIDER_FOR_RANKING'),
					disabled:true,
					columns: 2,
					vertical: true,
					items: [{ boxLabel: getPlacementTranslation('YES'), name: 'whetherConsiderForRanking', inputValue: true},
					        { boxLabel: getPlacementTranslation('NO'), name: 'whetherConsiderForRanking', inputValue: false,checked:true}
					]
				}]				
			},{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					labelAlign: 'top',
					itemId:'showinMarksheet',
					disabled:true,
					fieldLabel: getPlacementTranslation('SHOW_IN_MARKSHEET'),
					columns: 2,
					vertical: true,
					items: [{ boxLabel: getPlacementTranslation('YES'), name: 'whetherShowInMarksheet', inputValue: true},
					        { boxLabel: getPlacementTranslation('NO'), name: 'whetherShowInMarksheet', inputValue: false,checked:true}
					]
				}]		
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					labelAlign: 'top',
					itemId:'whetherMandatoryid',
					fieldLabel: getPlacementTranslation('WHETHER_MANDATORY'),
					columns: 2,
					vertical: true,
					items: [{ boxLabel: getPlacementTranslation('YES'), name: 'whetherMandatory', inputValue: true},
					        { boxLabel: getPlacementTranslation('NO'), name: 'whetherMandatory', inputValue: false,checked:true}
					]
				}]
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getPlacementTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getPlacementTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});