/**
 * @author Ravi Choudhary
 * 
 */
Ext.define('Academia.view.placement.recruitmentStage.PlacementRecruitmentStageFilters', {
	extend: 'Ext.form.FormPanel',
	alias: 'widget.placementrecruitmentstagefilters',
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			
			xtype: 'customcombobox',
			name: 'placementcampus',
			itemId:'placementcampusItemId',
			store:'placement.placementcampus.PlacementCampusStore',
			fieldLabel: getPlacementTranslation('PATH_PLACEMENT_CAMPUS_CODE_CAMPUS'),
    	    emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
    	    displayField:'valueCode',
			valueField:'id',
			editable: true,	    
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width: 256,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
			
		},{
			
			xtype: 'customcombobox',
			name: 'recruitingOrganization',
			itemId:'recruitingOrganization',
			store:'placement.placementjobapplication.PlacementJobApplicationROStore',
			allowBlank:false,
			fieldLabel: getPlacementTranslation('RECRUITING_ORGANIZATION'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'academyLocationName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width: 256,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
			
			
		},]
	},{	
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'jobtitle',
			itemId:'jobtitle',
			store:'placement.placementjobapplication.PlacementJobApplicationTitleStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			allowBlank : true,
			fieldLabel:getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE')
		},{
			xtype: 'customcombobox',
			name: 'selectionStage',
			itemId:'selectionStage',
			store:'placement.placementjobapplication.PlacementJobApplicationStageStatusStore',
			allowBlank:true,
			fieldLabel: getPlacementTranslation('PLACEMENT_JOB_APPLICATION_SELECTION_STAGE'),
			valueField: 'id',
			displayField: 'value',
			disabled:'true',
			forceSelection:true 
		}]
		},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true,
			margin: '0 44 0 0'
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
