Ext.define('Academia.view.program.CreateEditBasicProgramDetails', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	formCode:'programForm', 
	customFieldEntity:CONSTANTS.PROGRAM_CUSTOM_DATA,
	columns: 1,
    alias: 'widget.createeditbasicprogramdetails',
    title: getCommonTranslation('CREATE_EDIT_BASIC_PROGRAM_DETAILS'),
    //autoScroll: true,
    //frame: true,
    itemId:'createeditbasicprogramdetailsItemId',
    //modal: true,
    autoScroll: true,
	layout:'anchor',
	cls:'horizontalScrollingFixed x-form-fixed-footer-parent',
    frame: false,
	modal: true,
	border:true,
    method: 'POST',
    /*style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },*/
    bodyStyle:{
    	padding: '32px 32px 0 32px !important;'
    },
    /*layout: {
        type: 'vbox'
    },*/
    standardSubmit: false,
    defaults: {
        labelAlign: 'top'
    },
    plugins:"formlabelrequired",
    items: [{
    	 xtype:'hidden',
         name:'programId'  	
     },{
        xtype: 'hidden',
        name: 'id'
    },{
    	xtype:'hidden',
    	name:'programIdCode'
    },{
		xtype:'fieldset',
		title: getCommonTranslation('BASIC_DETAILS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:false,
		width:'100%',
		itemId : 'progrLamBasicDetailsItemId',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	        	xtype:'textfield',
	        	name: 'programCode',
	        	fieldLabel: getCommonTranslation('PROGRAM_CODE'),
	        	width: 256,
	        	emptyText: getCommonTranslation('ID_AUTOGENERATE'),
	        },{
	  			xtype : 'numberfield',
	  			name : 'programSequence',
	  			itemId:'programSequenceId',
	  			fieldLabel: getCommonTranslation('PROGRAM_SEQUENCES'),
	  			maxValue: 100000,
	  			minValue:1,
	  			
	        },{
	        	xtype:'textfield',
	        	name: 'programName',
	        	fieldLabel: getProgramandcourseTranslation('PROGRAM_NAMEE'),
	        	itemId:'programNameItemId',
	        	width: 536,
	        	allowBlank: false
	        }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	        	xtype: 'textfield',
	        	name: 'programShortName',
	        	fieldLabel: getCommonTranslation('PROGRAM_SHORT_NAME'),
	        	itemId:'programShortNameItemId',
	        	allowBlank: true
	        },{
	        xtype: 'textfield',
	        name: 'programNameToBePrint',
	        fieldLabel: getProgramandcourseTranslation('PROGRAM_NAME_TO_BE_PRINTED'),
	        allowBlank: false
	    },{
				xtype : 'customcombobox',
				name : 'academyLocation',
				itemId:'academyId',
				fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
				store:'common.AcademyLocationByName',
				valueField : 'id',
				displayField : 'value',
				width: 536,
				allowBlank : false,
				queryParam:'name',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		 },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	        	xtype: 'textfield',
	        	name: 'printNameInOtherLanguage1',
	        	fieldLabel: getCommonTranslation('PRINT_NAME_IN_OTHER_LANGUAGE_1'),
	        	itemId:'printNameInOtherLanguage1',
    			hidden:true,
	        	allowBlank: true
	          },
               {
	        	xtype: 'textfield',
	        	name: 'printNameInOtherLanguage2',
	        	itemId:'printNameInOtherLanguage2',
	        	fieldLabel: getCommonTranslation('PRINT_NAME_IN_OTHER_LANGUAGE_2'),
    			hidden:true,
	        	allowBlank: true
	     	}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name:'coordinator',
				store: 'common.AllUserBySmartSearch',
				fieldLabel: getProgramandcourseTranslation('PROGRAM_COORDINATOR'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'codeOrName',
				minChars:3,
				allowBlank: false,
				typeAhead:false,
	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	            enableKeyEvents  : 'true',
	            hideTrigger:false,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            triggerAction: '',
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{value}' +
		                    '</div>';
		                }
		            }
			},{
	        	xtype: 'customcombobox',
	            name: 'programGroup',
	            fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
	            store:'program.ProgramGroupStoreForLocalSerach',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            allowBlank: false,
	            typeAhead:false,
				queryMode:'local',
				anyMatch:true
	        }, {
	        	xtype: 'customcombobox',
	            name: 'programCategory',
	            fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
	            store:'program.ProgramCategoryStore',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            allowBlank: false,
	            typeAhead:false,
				queryMode:'local',
				anyMatch:true,
				//minChars:3
	        }, {
	        	xtype: 'customcombobox',
	            name: 'programEndorsement',
	            itemId: 'programEndorsementId',
	            fieldLabel: getCommonTranslation('PROGRAM_ENDORSEMENT'),
	            store: Ext.create('Academia.store.program.ProgramEndorsementStore'),
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            allowBlank: true
	        }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	        	xtype: 'customcombobox',
	            name: 'programPhase',
	            itemId: 'programPhaseItemId',
	            fieldLabel: getCommonTranslation('PROGRAM_PHASE'),
	            store:'common.ProgramPhaseStore',
	            displayField:'value',
	            valueField:'id',
	            allowBlank : true,
	            editable : false,
	        },{
	            xtype: 'customcombobox',
	            name: 'programDepartment',
	            fieldLabel: getCommonTranslation('PROGRAM_DEPARTMENT'),
	            itemId:'programDepartment',
	            store:'department.DepartmentAcademyLocationWiseStore',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            typeAhead:true,
	            allowBlank: false
	        },{
	        	xtype: 'customcombobox',
	            name: 'programSubDepartment',
	            fieldLabel: getCommonTranslation('PROGRAM_SUB_DEPARTMENT'),
	            store:'program.ProgramSubDepartmentStore',
	            displayField:'value',
	            valueField:'id',
	            disabled:true,
	            forceSelection:true
	        },{
    			xtype: 'multiselectcombofield',
    			name: 'areaOfInterest',
    			itemId: 'areaOfInterest',
    			fieldLabel : getCommonTranslation('AREA_OF_INTEREST'),
    			displayField:'value',
    			valueField:'id',
    			//matchFieldWidth:true,
    			maxLength:15000,
    			autoloadStore: false,
    			queryMode:'local',
				cls:'commonAutoHeightMultiselectField',
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}' +
    					'</div>';
    				}
    			},
            	listeners  :{
            		render : function(combo){
            			var store=Ext.create('Academia.store.common.AreaOfInterestStore');
            			combo.bindStore(store);
            			store.load();
            		}
            	}
	        }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	            xtype: 'customcombobox',
	            name: 'programMarks',
	            fieldLabel: getCommonTranslation('PROGRAM_MARK_GRADE'),
	            store: 'program.ProgramMarkGradeStore',
	            displayField: 'value',
	            valueField: 'id',
	            forceSelection:true,
	            allowBlank: false
	        },{
              	xtype: 'customcombobox',
                name: 'programGroupesmCode',
                itemId: 'programGroupesmCode',
                fieldLabel: getProgramandcourseTranslation('PROGRAM_GROUP_CESM'),
                store: Ext.create('Academia.store.program.ProgramGroupCESMStore'),
                displayField:'value',
                valueField:'id',
                editable : false,
                autoloadStore: false
            },{
              	xtype: 'customcombobox',
                name: 'cesmCode',
                itemId: 'cesmCodeId',
                fieldLabel: getProgramandcourseTranslation('PROGRAM_CESM_CODE'),
                store: Ext.create('Academia.store.program.ProgramCESMStore'),
                displayField:'value',
                valueField:'id',
                autoloadStore: false,
                disabled:true,
                editable : false
            },{
              	xtype: 'customcombobox',
                name: 'heqfLevel',
                itemId: 'heqfLevelId',
                fieldLabel: getCommonTranslation('HEQF_LEVEL'),
                store:'common.HEQFLevelStore',
                displayField:'value',
                valueField:'id',
                allowBlank : true,
                editable : false
            }]
		 },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	        	xtype: 'customcombobox',
	            name: 'affiliatedUniversity',
	            itemId: 'affiliatedUniversity',
	            fieldLabel: getCommonTranslation('AFFILIATED_UNIVERSITY'),
	            store:'common.AffiliatedUniversityStore',
	            displayField:'value',
	            valueField:'id',
	            allowBlank : true,
	            forceSelection:true
	        },{
              	xtype: 'customcombobox',
                name: 'modeOfDelivery',
                itemId: 'modeOfDeliveryId',
                fieldLabel: getCommonTranslation('MODE_OF_DELIVERY'),
                store:'common.ModeOfDeliveryStore',
                displayField:'value',
                valueField:'id',
                allowBlank : true,
                editable : false
            },{
              	xtype: 'customcombobox',
                name: 'academicAward',
                itemId: 'academicAwardId',
                fieldLabel: getCommonTranslation('ACADEMIC_AWARD'),
                store:'common.AcademicAwardStore',
                displayField:'value',
                valueField:'id',
                allowBlank : true,
                editable : true,
                typeAhead:false,
				queryMode:'local',
				anyMatch:true,
				//minChars:3
				forceSelection:true
            },{
    			xtype: 'customcombobox',
    			fieldLabel: getCommonTranslation('CERTIFICATE_NAME_TO_BE_PRINTED'), 
    			name: 'graduationCertificateName',
    			itemId: 'graduationCertificateNameId',
    			store:Ext.create('Academia.store.common.GraduationCertificateToBePrintStore'),                 
    			valueField: 'name',
    			displayField: 'value',
    			hidden:true,
    			allowBlank : true,
    			editable : false,
    			listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
            
    		}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
		    	  xtype      : 'radiogroup',
		          fieldLabel : getCommonTranslation('THERE_IS_SUCCEEDING_PROGRAM'),
		          itemId: 'thereIsSucceddingProgm',
		          name:'thereIsSucceddingProgmId',
		          defaults: {
		              flex: 1
		          },
		          layout: 'hbox',
		          items:[{ 
		          	boxLabel: getCommonTranslation('YES'), 
		          	name: 'rb1', 
		          	inputValue: true,
		          	checked:true
		          },{ 
		          	boxLabel: getCommonTranslation('NO'), 
		          	name: 'rb1', 
		          	inputValue: false
		          }]
		      },{
					xtype : 'customcombobox',
					name : 'succeedingAcademyLocation',
					itemId:'succeedingAcademyLocationId',
					fieldLabel : getProgramandcourseTranslation('SUCCEEDING_ACADEMY_LOCATION'),
					store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
					valueField : 'id',
					displayField : 'value',
					allowBlank : false,
					queryParam:'qry',
					minChars : 3,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents : 'true',
					hideTrigger : false,
					forceSelection : true,
					emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig : {
						listeners : {
							beforeshow : function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText : getCommonTranslation('SEARCHING'),
						emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl : function() {
							return '<div class="search-item">' + '{code} / {value}' + '</div>';
						}
					}
				
		},{xtype : 'fieldcontainer',
		width : 'auto',
		width:'100%',
		defaults: {
			width: 465,
			labelAlign: 'top'
		},items : [{
			xtype: 'multiselectcombofield',
			name: 'programCourseGroupMapping',
			itemId: 'courseGroupId',
			fieldLabel : getCommonTranslation('COURSE_GROUP'),
			store:Ext.create('Academia.store.course.CourseGroupCourse'),
			displayField:'valueCode',
			valueField:'id',
			queryParam:'courseGroupName',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			matchFieldWidth:true,
			queryMode:'remote',
			hidden:true,
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							//else
								//Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}

		}]
		}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
		            xtype: 'customcombobox',
		            name: 'programId',
		            itemId:'ceb_spId',
		            fieldLabel: getCommonTranslation('SELECT_SUCCEEDING_PROGRAM'),
		            store:'program.SelectSucceedingProgramStore',
		            displayField:'value',
		            valueField:'id',
		            forceSelection:true,
		            allowBlank: false,
		            disabled:true,
		            queryParam : 'name',
					minChars : 3,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents : 'true',
					hideTrigger : false,
					emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig : {
						listeners : {
							beforeshow : function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText : getCommonTranslation('SEARCHING'),
						emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl : function() {
							return '<div class="search-item">' + '{code} / {value}' + '</div>';
						}
					}
		        },{
		      	  xtype      : 'radiogroup',
		          fieldLabel : getCommonTranslation('IS_SINGLE_COURSE_PROGRAM'),
		          name :'isSingleCourseProgram',
		          itemId: 'isSingle',
		          defaults: {
		              flex: 1
		          },
		          layout: 'hbox',
		          items:[{ 
		          	boxLabel: getCommonTranslation('YES'), 
		          	name: 'isSingleCourseProgram', 
		          	inputValue: true,
		          },{ 
		          	boxLabel: getCommonTranslation('NO'), 
		          	name: 'isSingleCourseProgram', 
		          	inputValue: false,
		          	checked:true
		          }]
		      }]
		
			
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	        	xtype      : 'radiogroup',
	            fieldLabel : getProgramandcourseTranslation('IS_LONG_DISTANCE_PROGRAM'),
	            itemId:'isLongDistanceProgramID',
	            name:'isLongDistanceProgramRadio',
	            defaults: {
	                flex: 1
	            },
	            layout: 'hbox',
	            items: [
	                {
	                    boxLabel  :getCommonTranslation('YES') ,
	                    name      : 'isLongDistanceProgram',
	                    inputValue: true,
	                }, {
	                    boxLabel  : getCommonTranslation('NO'),
	                    name      : 'isLongDistanceProgram',
	                    inputValue: false,
	                    checked:true
	                }
	            ]
	        },{
	        	xtype      : 'radiogroup',
	            fieldLabel : getCommonTranslation('PROGRAM_STATUS'),
	            itemId: 'radioId',
	            name: 'programStatusRadio',
	            defaults: {
	                flex: 1
	            },
	            layout: 'hbox',
	            items: [
	                {
	                    boxLabel  :getProgramandcourseTranslation('ACTIVE'),
	                    name      : 'programStatus',
	                    inputValue: 'O',
	                    checked:true
	                }, {
	                    boxLabel  : getCommonTranslation('INACTIVE'),
	                    name      : 'programStatus',
	                    inputValue: 'C',
	                    
	                }
	            ]
	        },{
	        	xtype: 'datefield',
	            anchor: '100%',
	            fieldLabel: getCommonTranslation('CLOSURE_DATE'),
	            name: 'closureDate',
	            itemId:'closureDate',
	            allowBlank: true,
				vtype : 'daterange',
				hidden:true,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				},
	        }]
		 },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	        	xtype: 'textfield',
	            name: 'closureReason',
	            fieldLabel:getCommonTranslation('CLOSURE_REASON'),
	            itemId:'closureReason',
	            maxLength:100,
	            allowBlank: true,
	            hidden:true,
	        },{
				 xtype:'textfield',
		        	name: 'saqaId',
		        	fieldLabel: getCommonTranslation('SAQA_ID'),
		        	itemId:'saqaId',
		        	maxLength:255
			 }]
		 },{
			 xtype: 'fieldcontainer',
			 layout: 'fit',
			 defaults: {
				 labelAlign: 'top'
			 },
			 height: 'auto',
			 items: [{
				 xtype: 'textarea',
				 name: 'remark',
				 fieldLabel: getCommonTranslation('REMARKS'),
				 width: 536,
				 maxLength:2000,
				resizable: false,
				 listeners:{
					 resize: function( ta, width, height, oldWidth, oldHeight, eOpts ){
						 try{
							 if(ta.getHeight() > 20){
								 var resizeHandlerDiv = Ext.query("#"+ta.id+"-rzwrap-rzproxy")[0];
								 ta.setHeight(resizeHandlerDiv.offsetHeight - 20);
							 }
						 }
						 catch(e){
							 //--
						 }
					 }
				 }
			 }]
		 }]
    },{
		xtype:'fieldset',
		title: getCommonTranslation('OTHER_DETAILS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		width:'100%',
		itemId : 'programOtherDetailsItemId',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	        	xtype:'textfield',
	        	name: 'programNameLanguageOne',
	        	fieldLabel: getProgramandcourseTranslation('PROGRAM_NAME_LANGUAGE_ONE'),
	        	itemId:'programNameLanguageOneItemId',
	        },{
	        	xtype:'textfield',
	        	name: 'programShortNameLanguageOne',
	        	fieldLabel: getProgramandcourseTranslation('PROGRAM_SHORT_NAME_LANGUAGE_ONE'),
	        	itemId:'programShortNameLanguageOneItemId',
	        },
	        {
	        	xtype:'textfield',
	        	name: 'programNameToBePrintLanguageOne',
	        	fieldLabel: getProgramandcourseTranslation('PROGRAM_NAME_TO_BE_PRINT_LANGUAGE_ONE'),
	        	itemId:'programNameToBePrintLanguageOneItemId',
	        }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype:'textfield',
	        	name: 'programNameLanguageTwo',
	        	fieldLabel: getProgramandcourseTranslation('PROGRAM_NAME_LANGUAGE_TWO'),
	        	itemId:'programNameLanguageTwoItemId',
	        },
	        {
	        	xtype:'textfield',
	        	name: 'programShortNameLanguageTwo',
	        	fieldLabel: getProgramandcourseTranslation('PROGRAM_SHORT_NAME_LANGUAGE_TWO'),
	        	itemId:'programShortNameLanguageTwoItemId',
	        },{
	        	xtype:'textfield',
	        	name: 'programNameToBePrintLanguageTwo',
	        	fieldLabel: getProgramandcourseTranslation('PROGRAM_NAME_TO_BE_PRINT_LANGUAGE_TWO'),
	        	itemId:'programNameToBePrintLanguageTwoItemId',
	        }]
		 },{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items: [{
					xtype:'textfield',
		        	name: 'programNameLanguageThree',
		        	fieldLabel: getProgramandcourseTranslation('PROGRAM_NAME_LANGUAGE_THREE'),
		        	itemId:'programNameLanguageThreeItemId',
		        },{
		        	xtype:'textfield',
		        	name: 'programShortNameLanguageThree',
		        	fieldLabel: getProgramandcourseTranslation('PROGRAM_SHORT_NAME_LANGUAGE_THREE'),
		        	itemId:'programShortLanguageThreeItemId',
		        },{
		        	xtype:'textfield',
		        	name: 'programNameToBePrintLanguageThree',
		        	fieldLabel: getProgramandcourseTranslation('PROGRAM_NAME_TO_BE_PRINT_LANGUAGE_THREE'),
		        	itemId:'programNameToBePrintLanguageThreeItemId',
		        }]
			 },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 240,
				labelAlign: 'top'
			},
			items: [{
	        	xtype:'textfield',
	        	name: 'programRegistrationId',
	        	fieldLabel: getProgramandcourseTranslation('PROGRAM_REGISTRATION_ID'),
	        	itemId:'programRegistrationItemId',
	        	width: 256,
	        	maxLength:10
	        },
	        {
	        	xtype:'textfield',
	        	name: 'educationDepartmentProgramCode',
	        	fieldLabel: getProgramandcourseTranslation('EDUCATION_DEPARTMENT_PROGRAM_CODE'),
	        	itemId:'educationDepartmentProgramCodeItemId',
	        	width: 256,
	        },{
	        	xtype: 'datefield',
	            anchor: '100%',
	            fieldLabel: getProgramandcourseTranslation('EDUCATION_DEPARTMENT_REGISTRATION_DATE'),
	            name: 'educationDepartmentRegistrationDate',
	            itemId:'educationDepartmentRegistrationDateItemId',
	            allowBlank: true,
				vtype : 'daterange',
				maxValue:new Date(),
				listeners: {
          		  render: function(field) {
          			  return dateFormatRender(field);
          		  }
          	  	}
				
	        }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
              	xtype: 'customcombobox',
                name: 'registrationType',
                itemId: 'registrationTypeId',
                fieldLabel: getCommonTranslation('REGISTRATION_TYPE'),
                store:'common.RegistrationTypeStore',
                displayField:'value',
                valueField:'id',
                allowBlank : true,
                editable : false
            },{
	        	xtype:'textfield',
	        	name: 'programDesignator',
	        	fieldLabel: getProgramandcourseTranslation('PROGRAM_DESIGNATOR'),
	        	itemId:'programDesignatorItemId',
	        },{
	        	xtype: 'textfield',
	        	name: 'programQualifier',
	            fieldLabel: getProgramandcourseTranslation('PROGRAM_QUALIFIER'),
	            itemId:'programQualifierItemId',
	        }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	        	xtype:'textfield',
	        	name: 'programSecondQualifier',
	        	fieldLabel: getProgramandcourseTranslation('PROGRAM_SECOND_QUALIFIER'),
	        	itemId:'programSecondQualifierItemId',
	        },{
	        	xtype: 'textfield',
	        	name: 'fieldOfStudyLanguageTwo',
	            fieldLabel: getProgramandcourseTranslation('FIELD_OF_STUDY_LANGUAGE_TWO'),
	            itemId:'fieldOfStudyLanguageTwoItemId', 
	            },
	            {
		        	xtype: 'textfield',
		        	name: 'fieldOfStudyOtherLanguage',
		        	maxLength : 100,
		            fieldLabel: getProgramandcourseTranslation('FIELD_OF_STUDY_OTHER_LANGUAGE'),
		            itemId:'fieldOfStudyOtherLanguage', 
		            },{
		            xtype: 'customcombobox',
	                name: 'certificateType',
	                itemId: 'certificateTypeId',
	                fieldLabel: getCBTranslation('certificate_certificateType'),
	                store:'course.CertificateTypeStore',
	                valueField : 'id',
	    			displayField : 'value',
	    			triggerAction : 'all',
	    			editable : true,
	    			allowBlank : true
	            },{
		            xtype: 'customcombobox',
	                name: 'certificateType',
	                itemId: 'certificateTypeId',
	                fieldLabel: getCBTranslation('certificate_certificateType'),
	                store:'course.CertificateTypeStore',
	                valueField : 'id',
	    			displayField : 'value',
	    			triggerAction : 'all',
	    			editable : true,
	    			allowBlank : true
	    			
	                
	        }]
		 },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
		            xtype: 'textfield',
	                name: 'programSubMerchant',
	                itemId: 'programSubMerchantId',
	                fieldLabel: getProgramandcourseTranslation('Program_Sub_MerchantId'),
	    			allowBlank : true,
	    			maxLength:20
	        }]},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items: [{
		            xtype: 'checkboxfield',
		            width: 256,
		            labelAlign: 'right',
		            itemId:'whether_Accreditation',
		            boxLabel: getCommonTranslation('ACCREDATION_OF_PROGRAM'),
		            name: 'whether_Accreditation',
		            inputValue : true,
		            uncheckedValue: false ,
		            style:{
		            	marginTop:'20px !important'
		            }
		        },{
					xtype : 'datefield',
					anchor : '100%',
					fieldLabel : getCommonTranslation('FROM_DATE'),
					name : 'accreditationfromDate',
					itemId : 'accreditationfromDate',
					hidden:true,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype : 'daterange',
					allowBlank:false
				},{
					xtype : 'datefield',
					anchor : '100%',
					fieldLabel : getCommonTranslation('TILL_DATE'),
					name : 'accreditationtillDate',
					itemId : 'accreditationtillDate',
					hidden:true,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype : 'daterange',
					allowBlank:false
				 }]
			 },{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items: [{
	        	xtype:'textfield',
	        	name: 'accreditationprogramAccreditation',
	        	fieldLabel: getCommonTranslation('NAME_OF_ACCREDATION_AGENCY'),
	        	itemId:'accreditationprogramAccreditation',
	        	maxLength:255,
	        	hidden:true,
	        	allowBlank:false
	        }]
			 }]
	
    },{
    	/**
    	* @shivam.joshi
    	* currently we are hiding fieldset for V2D-284790 story.
    	* 
        */
    	
		xtype:'fieldset',
		title: getProgramandcourseTranslation('CATALOGUE_DETAILS'),
		layout:'vbox',
		frame:true,
		collapsible:true,
		collapsed:true,
		width:'100%',
		itemId : 'programCatalogueDetailsItemId',
		hidden: true,
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	        	xtype:'textfield',
	        	name: 'duration',
	        	fieldLabel: getProgramandcourseTranslation('DURATION'),
	        	itemId:'durationItemId',
	        	maxLength:100
	        },{
	        	xtype:'customcombobox',
	        	name: 'presentationLanguage',
	        	itemId:'presentationLanguageItemId',
	        	fieldLabel: getProgramandcourseTranslation('PRESENTATION_LANGUAGE'),
	        	store: 'common.MultiLanguageStore',
	        	valueField:'id',
	            displayField:'value',
	        },{
	        	xtype:'customcombobox',
	        	name: 'fieldOfStudy',
	        	itemId:'fieldOfStudyItemId',
	        	fieldLabel: getProgramandcourseTranslation('FIELD_OF_STUDY'),
	        	displayField:'value',
                valueField:'id',
	        }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	        	xtype:'textfield',
	        	name: 'videoURL',
	        	fieldLabel: getProgramandcourseTranslation('VIDEO_URL'),
	        	itemId:'videoURLItemId',
	        	width: 462,
	        	maxLength:100
	        },{
	        	xtype:'checkbox',
	        	name: 'publishInCatalogue',
	        	boxLabel: getProgramandcourseTranslation('PUBLISH_IN_CATALOGUE'),
	        	itemId:'publishInCatalogueItemId',
	        	inputValue: true,
				uncheckedValue: false,
				style:{marginTop: '20px !important'},
	        }]
		 },{
			 xtype: 'fieldcontainer',
			 width: 'auto',
			 layout: {
				 type: 'hbox'
			 },
			 defaults: {
				 labelAlign: 'top',
				 width: 256
			 },
			 items: [{
					 xtype: 'customcombobox',
					 name: 'programDocumentFileType',
					 itemId: 'programDocumentFileType',
					 fieldLabel: getProgramandcourseTranslation('PC_FILE_TYPE'),
					 store: 'program.ProgramDocumentFileTypeStore',
					 displayField: 'value1',
					 valueField: 'id',
					 forceSelection:true
				 },{
					 xtype: 'button',
					 name: 'programDocument',
					 text:getCommonTranslation('UPLOAD_FILE'),
					 itemId: 'uploadProgramItemId',
					 ui: 'CustomBtnThird',
					 disabled:true,
					 scale : CONSTANTS.BUTTONSIZE,
					 style:{
						 marginTop:'30px'
					 }
				 }]
		 },{
			 xtype: 'fieldcontainer',
			 width: 'auto',
			 layout: {
				 type: 'hbox'
			 },
			 defaults: {
				 labelAlign: 'top',
				 width:400
			 },
			 style:{marginLeft: '-10px!important'},
			 items: [{
				 xtype:'programdocumentgrid'
			 }]
		 },{
				xtype: 'fieldcontainer',
				width: '100%',
				layout: {
					type: 'hbox'
				},
				hidden: true,
				defaults: {
					labelAlign: 'top',
					width: 256
				},
				items: [{
					xtype: 'customcombobox',
					fieldLabel:  getProgramandcourseTranslation('CATALOGUE_CONTENT'),     // select Email or sms           
					name: 'catalogueContent',
					itemId : 'catalogueContent',   
					displayField : 'value',
					valueField:'id',
					store:Ext.create('Academia.store.program.StoPncProgramManageAdmissionReqStore'),
				}]
		 },{
			 xtype: 'fieldcontainer',
			 layout: 'hbox',
			 defaults: {
				 width: 256,
				 labelAlign: 'top'
			 },
			 hidden: true,
			 items: [{
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('FIELD_TYPE'),
				 itemId:'isHtmlContent',
				 name:'isHtmlContent',
				 allowBlank: false,
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items: [
					 {
						 boxLabel  :getCommonTranslation('HTML') ,
						 name      : 'isHtmlContent',
						 inputValue: true,
						 checked:true
					 }, {
						 boxLabel  : getCommonTranslation('TEXTAREA'),
						 name      : 'isHtmlContent',
						 inputValue: false
					 }
				]
			 }]
		 },{
				xtype: 'fieldcontainer',
				itemId:'editorContentArea',
				layout: 'hbox',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				hidden: true,
				//cls:'programTextArea',
				items: [{
					xtype: 'ckeditor',
			        itemId: 'bursaryInformationItemId',
			        name:'bursaryInformation',
			        height: 375,
			        width:700,
			        maxLength: 5000,
			        hidden:true
					
		        	/*xtype:'textarea',
		        	name: 'bursaryInformation',
		        	fieldLabel: getProgramandcourseTranslation('BURSARY_INFORMATION'),
		        	itemId:'bursaryInformationItemId',
		            maxLength:1000,
		            height: 210,*/
		        },{
		        	xtype:'textarea',
		        	name: 'bursaryInformation_txt',
		        	itemId:'bursaryInformationItemId_txt',
			        width:700,
		        	height: 370,
		        	maxLength:5000,
		        	hidden: true
		        },
		        {
		        	xtype: 'ckeditor',
			        itemId: 'admissionRequirementsItemId',
			        name:'admissionRequirements',
			        height: 375,
			        width:700,
			        maxLength: 5000,
			        hidden:true
			        
		        	/*xtype:'textarea',
		        	name: 'admissionRequirements',
		        	fieldLabel: getProgramandcourseTranslation('ADMISSION_REQUIREMENTS'),
		        	itemId:'admissionRequirementsItemId',
		        	maxLength:1000,
		        	height: 210,*/
		        },{
		        	xtype:'textarea',
		        	name: 'admissionRequirements_txt',
		        	itemId:'admissionRequirementsItemId_txt',
		        	height: 370,
			        width:700,
			        maxLength: 5000,
		        	hidden: true
		        },{
		        	xtype: 'ckeditor',
			        itemId: 'selectionCriteriaItemId',
			        name:'selectionCriteria',
			        height: 375,
			        width:700,
			        maxLength: 5000,
			        hidden:true
			        
		        	/*xtype:'textarea',
		        	name: 'selectionCriteria',
		        	fieldLabel: getProgramandcourseTranslation('SELECTION_CRITERIA'),
		        	itemId:'selectionCriteriaItemId',
		        	maxLength:1000,
		        	height: 210,*/
		        },{
		        	xtype:'textarea',
		        	name: 'selectionCriteria_txt',
		        	itemId:'selectionCriteriaItemId_txt',
		        	height: 370,
			        width:700,
			        maxLength: 5000,
		        	hidden: true
		        }]
			 }]
    },{ 
    	/**
    	* @ankush.solanki
    	* currently we are hiding below two field for V2D-121018 story.
    	* 
        */
    	xtype: 'fieldcontainer',
        width: 'auto',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            	width: 256
        },
        items: [{
        	xtype      : 'radiogroup',
            fieldLabel : getCommonTranslation('ADMISSION_ID_FOR_SUCCEEDING_PROGRAM'),
            defaultType: 'radiofield',
            itemId: 'radioId1',
            name: 'admissionIdForSucceedingProgram',
            allowBlank : false,
            disabled:true,
            hidden:true,
            defaults: {
                flex: 1
            },
            layout: 'hbox',
            items:[{ 
            	boxLabel: getCommonTranslation('YES'), 
            	name: 'rb2', 
            	inputValue: true,
            	allowBlank: false,
            	checked:true
            },{ 
            	boxLabel: getCommonTranslation('NO'), 
            	name: 'rb2', 
            	inputValue: false,
            	allowBlank: false
             }]
        },{
        	xtype      : 'radiogroup',
            fieldLabel : getCommonTranslation('WHETHER_PERIOD_TRANSITION_APPLICABLE'),
            defaultType: 'radiofield',
            itemId: 'periodTransitionRadioGroup',
            name: 'periodTransitionRadioId',
            hidden:true,
            allowBlank : false,
            defaults: {
                flex: 1
            },
            layout: 'hbox',
            items:[{ 
            	boxLabel: getCommonTranslation('YES'), 
            	name: 'periodTransitionRadio', 
            	inputValue: true,
            },{ 
            	boxLabel: getCommonTranslation('NO'), 
            	name: 'periodTransitionRadio', 
            	inputValue: false,
            	allowBlank: false,
            	checked : true
             }]
        }] 
    },{
    	xtype:'fieldcontainer',
    	cls: 'form-fixed-footer',
    	width:'100%',
    	layout : {
    		type : 'hbox'
    	},
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SAVE'),
    		itemId: 'programFormSubmitButtonId',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	}, {
    		xtype: 'button',
    		text: getCommonTranslation('RESET'),
    		itemId: 'resetBtn',
    		ui: 'CustomBtnCancel',
    		scale: CONSTANTS.BUTTONSIZE
    		
    	},{
    		xtype: 'button',
    		text: getCommonTranslation('ADD_MORE_DETAILS'),
    		itemId: 'addMoreDetailsButtonId',
    		disabled: true,
    		hidden:true, 
    		ui: 'CustomBtnThird',
    		scale: CONSTANTS.BUTTONSIZE
    	}]
    }]

});