/**
 * @author Dharmendra Goyal
 */
Ext.define('Academia.view.program.lessonplanning.LessonPlanningCopyWindowForm', {
	extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.lessonplanningcopywindowform',
	plugins : "formlabelrequired",
	width : '100%',
	standardSubmit: false,
	items:[{
		xtype : 'fieldcontainer',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'fromAcademyLocation',
			itemId:'fromAcademyLocationId',
			fieldLabel: getProgramandcourseTranslation('FROM_ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			valueField:'id',
			displayField:'value',
			forceSelection:true,
			allowBlank:true,
			triggerAction: 'all',
			queryMode:'local',
			typeAhead : false,
			forceSelection : true,
			anyMatch : true,
			hidden:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},]
	},{
		xtype : 'fieldcontainer',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'fromAcademicTermId',
			itemId:'fromAcademicTermId',
			fieldLabel: getProgramandcourseTranslation('FROM_ACADEMIC_TERM'),
			store:'common.AcademicTermStore',
			valueField:'id',
			displayField:'value',
			forceSelection:true,
			allowBlank:false,
			triggerAction: 'all',
			queryMode:'local',
			typeAhead : false,
			forceSelection : true,
			anyMatch : true,
		},{
			xtype : 'customcombobox',
			name : 'courseItemId',
			itemId : 'courseItemId',
			fieldLabel : getProgramandcourseTranslation('COPY_LESSON_PLANNING_FROM'),
			emptyText: getCommonTranslation('SELECT_COURSE'),
			store : 'lessonplan.CoursesByAcademicTermForLessonPlanStore',
			displayField : 'courseCodeName',
			valueField : 'courseId',
			allowBlank:false,
			forceSelection:true,
			queryMode:'local',
			anyMatch : true,
			disabled: true,
			triggerAction: 'all',
			minChars:3,
			queryParam:'name',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getProgramandcourseTranslation('COURSE_VARIANT'),
			name : 'courseVariantId',
			itemId : 'courseVariantId',
			//store:'course.coursevariants.CourseVariantStore',
			store:Ext.create('Academia.store.course.coursevariants.NewCourseVariantStore'),
			displayField : 'courseVariantCode',
			valueField : 'id',
			allowBlank:true,
			disabled: true,
			forceSelection:true,
			//typeAhead:true
		}]
	},{
		xtype : 'fieldcontainer',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		/*standardSubmit: false,
		plugins:"formlabelrequired",  */
		items : [{
			xtype: 'customcombobox',
			name:'unittitleId',
			itemId: 'unittitleId',
			fieldLabel: getProgramandcourseTranslation('UNIT_TITLE'),
			store:'lessonplan.LessonPlanUnitTitleStore',
			disabled: true,
			valueField:'id',
			displayField:'value',
			allowBlank:true,
			forceSelection:true,
			typeAhead:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
						Ext.defer(function() {
							picker.getEl().dom.style.wordBreak='break-all';
						},200);
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'topics',
			itemId:'topics',
			disabled: true,
			fieldLabel: getProgramandcourseTranslation('TOPICS'),
			store:'lessonplan.LessonPlanTopicStore',
			displayField:'value',
			valueField:'id',
			allowBlank:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
						Ext.defer(function() {
							picker.getEl().dom.style.wordBreak='break-all';
						},200);
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'termId',
			itemId: 'termId',
			disabled: true,
			fieldLabel: getCommonTranslation('TERM'),
			store:'lessonplan.LessonPlanTermStore',
			displayField:'value',
			valueField:'id',
			allowBlank:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
						Ext.defer(function() {
							picker.getEl().dom.style.wordBreak='break-all';
						},200);
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'toAcademyLocation',
			itemId:'toAcademyLocationId',
			fieldLabel: getProgramandcourseTranslation('TO_ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			valueField:'id',
			displayField:'value',
			forceSelection:true,
			allowBlank:true,
			triggerAction: 'all',
			queryMode:'local',
			typeAhead : false,
			forceSelection : true,
			anyMatch : true,
			hidden:true,
			readOnly: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},]
	},{
		xtype : 'fieldcontainer',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		/*standardSubmit: false,
		plugins:"formlabelrequired",  */
		items : [{
			xtype :'customcombobox',
			name: 'toAcademicTermId',
			itemId:'toAcademicTermId',
			fieldLabel: getProgramandcourseTranslation('TO_ACADEMIC_TERM'),
			store:'common.AcademicTermStore',
			valueField:'id',
			displayField:'value',
			forceSelection:true,
			triggerAction: 'all',
			allowBlank:false
		},{
			xtype : 'customcombobox',
			name:'newcourseId',
			itemId:'newcourseId',
			fieldLabel : getProgramandcourseTranslation('NEW_COURSE'),
			emptyText: getCommonTranslation('SELECT_COURSE'),
			//disabled: true,
			store : Ext.create('Academia.store.course.CoursesWithoutLPStore'),
			displayField : 'courseCodeName',
			valueField : 'courseId',
			allowBlank:false,
			queryMode:'local',
			anyMatch : true,
			disabled: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype : 'multiselectcombofield',
			name : 'newcourseVariantId',
			itemId : 'newcourseVariantId',
			fieldLabel : getProgramandcourseTranslation('NEW_COURSE_VARIANTS'),
			disabled: true,
			allowBlank:true,
			store:Ext.create('Academia.store.course.coursevariants.NewCourseVariantStore'),
			displayField : 'courseVariantCode',
			valueField : 'id'
			
		}]
	},{
		xtype : 'fieldcontainer',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		/*standardSubmit: false,
		plugins:"formlabelrequired", */
		items : [{
			xtype: 'multiselectcombofield',
			name:'facultyId',
			itemId:'facultyId',
			//store: 'common.AllUserBySmartSearch',
			fieldLabel: getCommonTranslation('FACULTY'),
			store:'attendance.LessonPlanFacultyStore',
			displayField : 'value',
			valueField : 'id',
			allowBlank:true,
			queryParam:'name',
			disabled: true,
			minChars:3,
			typeAhead:false,
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		},
		{
			xtype: 'textfield',
			name:'newtopics',
			itemId:'newtopics',
			fieldLabel: getProgramandcourseTranslation('TOPICS'),
			maxLength: 255,
			disabled: true,
			allowBlank:true
		},{
			xtype: 'textfield',
			name:'texttermId',
			itemId: 'texttermId',
			fieldLabel: getCommonTranslation('TERM'),
			disabled: true,
			maxLength: 49,
			allowBlank:true
		}]
	},{
		xtype: 'fieldcontainer',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SAVE'),
			itemId: 'btnSubmit',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		},{
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			itemId: 'btnCancel',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getProgramandcourseTranslation('BTN_CONTINUE_MANUALLY'),
			formBind:false,
			itemId: 'btnContinue',
			ui: 'CustomBtnThird',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});
