/**
 * @author Ashutosh.Bhawsar<ashutosh.bhawsar@serosoft.in>
 * 
 */
Ext.define('Academia.view.program.outcomebasededucation.DownloadOutcomeBasedEductionForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadoutcomebasedeductionform',
	plugins : "formlabelrequired",
	frame: false,
	method : 'POST',
	//cls:'customSearchPanel',
	standardSubmit : false,
						items : [ {
						xtype : 'fieldcontainer',
						items : [
								{
									xtype : 'fieldcontainer',
									width : '100%',
									layout : 'hbox',
									defaults : {
										labelAlign : 'top'
									},
									items : [ {
										xtype : 'customcombobox',
										name : 'downloadType',
										width: 256,
										allowBlank : false,
										itemId : 'OBEdownloadTypeItemId',
										fieldLabel : getProgramandcourseTranslation('OBE_TEMPLATE_FOR'),
										store : 'program.OBETemplateTypeStore',
										valueField : 'id',
										displayField : 'value',
										triggerAction : 'all',
										editable : false,
										
									} ]
								},
								{
									xtype:'panel',
									itemId:'panelIdOBE',
									layout : 'vbox',
									width: '100%',
									margin: '0 0 0 -9',
									padding: '0 0 0 0',
									hidden:true,
									style:{
										marginLeft:'0px',
										marginTop:'0px'
									},
									items:[{
									 xtype : 'fieldcontainer',
							       	 layout : 'hbox',
							       	 width: '100%',
							       	 defaults : {
							       		 labelAlign : 'top',
							       	 },
							       	 layout : {
							       		 type : 'hbox'
							       	 },
									margin: '0 0 0 0',
									padding: '0 0 0 0',
									items : [ {
										xtype : 'customcombobox',
										name : 'program',
										itemId : 'program',
										fieldLabel : getProgramandcourseTranslation('OBE_PROGRAM'),
										width: 536,
										valueField : 'id',
										displayField : 'value',
										allowBlank : false,
										minChars : 3,
										typeAhead : true,
										forceSelection : true,
										store : Ext.create('Academia.store.common.ProgramByAcademyLocationStore'),
										queryParam : 'programName',
										emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
										listConfig : {
											listeners : {
												beforeshow : function(picker) {
													picker.minWidth = picker
															.up('combobox')
															.getSize().width;
												}
											},
											loadingText : getCommonTranslation('SEARCHING'),
											emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
											getInnerTpl : function() {
												return '<div class="search-item">'
														+ '{value}' + '</div>';
											}
										}
									}, {
										xtype: 'multiselectcombofield',
										name : 'multiBatch',
										itemId : 'multiBatch',
										fieldLabel : getProgramandcourseTranslation('OBE_BATCH'),
										width: 256,
										allowBlank : false,
										disabled : true,
										editable : false,
										displayField : 'value',
										minChars:3,
										typeAhead : true,
										autoloadStore: false,
										forceSelection : true,
										valueField : 'id',
										cls:'commonAutoHeightMultiselectField',
										store : Ext.create('Academia.store.enquiry.AcademicBatchStore'),
										
										listConfig: {
							  				listeners: {
							 					beforeshow: function(picker) {
							 						picker.minWidth = picker.up('combobox').getSize().width;
							 					}
							 				},
							             }
									},{
										xtype: 'customcombobox',
										name : 'batch',
										itemId : 'batch',
										fieldLabel : getProgramandcourseTranslation('OBE_BATCH'),
										width: 256,
										allowBlank : false,
										disabled : true,
										editable : false,
										displayField : 'value',
										typeAhead : true,
										autoloadStore: false,
										forceSelection : true,
										valueField : 'id',
										store : Ext.create('Academia.store.enquiry.AcademicBatchStore'),
										
										listConfig: {
							  				listeners: {
							 					beforeshow: function(picker) {
							 						picker.minWidth = picker.up('combobox').getSize().width;
							 					}
							 				},
							             }
									},{
										xtype: 'button',
										itemId: 'OBEDetailsBtn',
										cls: 'CustomBodyBtnSettings',
										text: getCommonTranslation('ADDBUTTONTEXT'),
										tooltip: getCommonTranslation('ADD'),
										style:{
											marginTop:'30px'
										}}  ]
									}]},
								{
									xtype : 'fieldcontainer',
									layout : 'hbox',
									width : '100%',
									defaults : {
										labelAlign : 'top'
									},
									
									items : [ {
										xtype: 'multiselectcombofield',
										name : 'period',
										itemId : 'period',
										allowBlank : false,
										disabled : true,
										width: 536,
										editable : false,
										displayField : 'value',
										valueField : 'id',
										autoloadStore: false,
										matchFieldWidth:true,
										cls:'commonAutoHeightMultiselectField',
										store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
										queryMode : 'local',
										fieldLabel : getProgramandcourseTranslation('OBE_PERIOD'),
										
									},{
										xtype : 'customcombobox',
										name : 'programOutcomeType',
										itemId : 'programOutcomeType',
										fieldLabel : getProgramandcourseTranslation('PROGRAM_OUTCOME_TYPE'),
										store:Ext.create('Academia.store.OBECorrelationLevelStore.OBEProgramOutcomeTypeStore'),
										// translationKey: 'PROGRAM',
										width: 256,
										valueField : 'id',
										allowBlank : false,
										editable : false,
										disabled : true,
										displayField : 'value',
										minChars : 3,
										queryParam : 'programOutcome',

									} ]
								},
								{
									xtype : 'fieldcontainer',
									layout : 'hbox',
									width : '100%',
									defaults : {
										labelAlign : 'top'
									},
									items : [
											{
												xtype: 'multiselectcombofield',
												fieldLabel : getProgramandcourseTranslation('OBE_COURSE_CODE_NAME'),
												name : 'obeCourse',
												itemId : 'obeCourse',
												width: 536,
												allowBlank : false,
												store : Ext.create('Academia.store.OBECorrelationLevelStore.OBECourseStore'),
												displayField : 'value',
												valueField : 'id',
												typeAhead : true,
												forceSelection : true,
												queryParam : 'name',
												minChars : 3,
												cls:'commonAutoHeightMultiselectField',
												triggerCls : Ext.baseCSSPrefix
														+ 'x-form-trigger',
												enableKeyEvents : 'true',
												hideTrigger : false,
												
												listConfig : {
													listeners : {
														beforeshow : function(
																picker) {
															picker.minWidth = picker
																	.up(
																			'combobox')
																	.getSize().width + 50;
														}
													},
													loadingText : getCommonTranslation('SEARCHING'),
													emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
													getInnerTpl : function() {
														return '<div class="search-item">'
																+ '{code}'
																+ '</div>';
													}
												}
											},
											{
												xtype: 'multiselectcombofield',
												fieldLabel : getProgramandcourseTranslation('OBE_COURSE_CODE_NAME'),
												name : 'course',
												itemId : 'course',
												width: 536,
												allowBlank : false,
												store:Ext.create('Academia.store.attendance.CoursesForCourseOutcomeStore'),
												valueField: 'id',
												displayField: 'courseCodeName',
												typeAhead : true,
												forceSelection : true,
												queryParam : 'qry',
												minChars : 3,
												cls:'commonAutoHeightMultiselectField',
												triggerCls : Ext.baseCSSPrefix
														+ 'x-form-trigger',
												enableKeyEvents : 'true',
												hideTrigger : false,
												listConfig : {
													listeners : {
														beforeshow : function(
																picker) {
															picker.minWidth = picker
																	.up(
																			'combobox')
																	.getSize().width + 50;
														},
														
													},
													loadingText : getCommonTranslation('SEARCHING'),
													emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
													getInnerTpl : function() {
														return '<div class="search-item">'
																+ '{code}'
																+ '</div>';
													}
												}
											}]
								},
								{
									
									xtype : 'fieldcontainer',
									layout: 'hbox',
									cls: 'customSearchPanelBtnsFieldContainerCls',
									items : [
											{
												xtype : 'button',
												text : getProgramandcourseTranslation('OBE_DOWNLOAD_TEMPLATE'),
												itemId : 'obeDownoladBtnId',
												formBind : true,
												ui : 'CustomBtnSubmit'
											},
											{
												xtype : 'button',
												text : getCourseTxCommonTranslation('RESET'),
												itemId : 'resetBtn',
												//buttonAlign : 'left',
												ui : 'CustomBtnCancel',
												scale : CONSTANTS.BUTTONSIZE
											} ]
								} ]
					}]
});
