/**
 * @author Ankush Solanki
 * 
 */
Ext.define('Academia.view.program.outcomebasededucation.ExamEventQuestionDetailsMapStructure', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.exameventquestiondetailsmapstructure',
	autoScroll: true,
	items : [{
		xtype:'form',
		itemId:'examEventQuestionDetailsMapFrom',
		plugins:"formlabelrequired",
		border:true,
		items:[{
			xtype:'fieldcontainer',
			border:'2px',
			style :{marginLeft: '10px'},
			layout:'hbox',
			defaults: {
				width: 270,
				labelAlign: 'top'
			},
			items:[{
				xtype:'hidden',
				name:'addEditButton',
				itemId:'addEditButton'
			},{
				xtype:'hidden',
				name:'courseId',
				itemId:'courseId'
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTerm',
				itemId : 'academicTermId',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : false,
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.AcademicTermStore');
						combo.bindStore(store)
					}
				}
			},{
				xtype: 'customcombobox',
				name:'courseId',
				itemId:'courseItemId',
				store:Ext.create('Academia.store.attendance.CoursesForVariantMapping'),
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				width: 550,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				allowBlank : false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			style :{marginLeft: '10px'},
			defaults: {
				labelAlign: 'top',
				width: 270
			},
			items: [{
				xtype: 'customcombobox',
				name:'evaluationplanno',
				itemId:'evalautionPlanId',
				store:Ext.create('Academia.store.examinationcenters.evaluation.EvaluationPlanByCriteria'),
				fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'evaluationPlanNumber',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				},
				allowBlank : false,
			},{
				xtype: 'customcombobox',
				name: 'detailSequence',
				itemId:'detailSequenceItemId',
				store:Ext.create('Academia.store.examinationcenters.manageEvaluation.EvaluationEventByEvalPlan'),
				displayField:'value',
				valueField:'id',
				editable:false,
				queryMode: 'local',
				fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
				disabled:true,
				allowBlank : false,
			},{
		        xtype: 'numberfield',
		        anchor: '100%',
		        name: 'eventMaxMarks',
				itemId:'eventMaxMarksItemId',
		        fieldLabel:getExaminationTranslation('MAXIMUM_PASSING_MARKS'),
		        hidden:true,
		    }] 
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			style :{marginLeft: '10px'},
			defaults: {
				labelAlign: 'top',
				width: 270
			},
			items: [{
				 xtype : 'radiogroup',
				 itemId:'cutOffTypeRadio',
				 fieldLabel:getExaminationTranslation('CUT_OFF_TYPE'),
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('PERCENTAGE'), 
					 name: 'cutOffType', 
					 inputValue: "PERCENTAGE",
					 checked:true
				 },{ 
					 boxLabel: getExaminationTranslation('AVERAGE_MARKS'), 
					 name: 'cutOffType', 
					 inputValue: "AVERAGE_MARKS"
				 }]
			 },{
		        xtype: 'numberfield',
		        anchor: '100%',
		        name: 'cutOffPercentage',
				itemId:'cutOffPercentageItemId',
				maxValue: 100,
				minValue: 0,
		        maxLength : 3,
				allowBlank : false,
		        fieldLabel:getExaminationTranslation('CUT_OFF_PERCENTAGE'),
		    },{
				xtype: 'customcombobox',
				name: 'attainmentRule',
				itemId:'attainmentRuleItemId',
				store:Ext.create('Academia.store.examinationOBEAttainment.AttainmentRuleFindAllStore'),
				displayField:'value',
				valueField:'id',
				editable:false,
				fieldLabel:getExaminationTranslation('ATTAINMENT_RULE'),
				allowBlank : false,
			}] 
		}],
	},{
		 xtype :'createexameventdetailsmapgrid',
		 itemId:'createexameventdetailsmapgrid',
	},{
		 xtype: 'button',
		 action: 'Submit',
		 style :{marginLeft: '10px'},
		 text: getCommonTranslation('SAVE'),
		 itemId: 'submitButtonId',
		 ui: 'CustomBtnSubmit',
		 formBind :true,
		 scale: CONSTANTS.BUTTONSIZE
	 }],
	
});