/**
 * @author Amit G
 */
Ext.define('Academia.view.program.outcomebasededucation.VWPncProgramCourseOutcomeForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.vwpncprogramcourseoutcomeform',
	autoScroll: true,
	frame: true,
	method: 'POST',
	standardSubmit: false,
	title: getCommonTranslation('PROGRAM_COURSE_OUTCOME_FORM'),
	plugins : "formlabelrequired",
	layout:'anchor',
	cls:'horizontalScrollingFixed x-form-fixed-footer-parent', 
	items: [{
		xtype: 'hidden',
		name: 'id'
	},{
		xtype: 'hidden',
		name: 'status',
		value:'O'
	},{
		xtype: 'hidden',
		name: 'addEditType',
		itemId: 'addEditType',
	},{
		 xtype:'fieldcontainer',
		 layout:'hbox',
		 width:'100%',
		 defaults: {
			 labelAlign: 'top'
		 },
		 items:[{
			 xtype      : 'radiogroup',
			 itemId:'vwpncprogramcourseoutcomeformradioGroup',
			/* defaults: {
				 flex: 1
			 },*/
			 layout: 'hbox',
			 width:'100%',
			 items:[{ 
				 boxLabel: getCommonTranslation('MAP_COURSE_AND_PROGRAM_OUTCOMES'), 
				 name: 'pncWhetherCourseProgramMap', 
				 itemId:'pncWhetherCourseProgramMap',
				 inputValue: "MapCourseAndProgramOutcomes",
				 checked:true
			 },{ 
				 boxLabel: getCommonTranslation('MAP_COURSE_OUTCOMES_AND_PROGRAM_OUTCOMES'), 
				 name: 'pncWhetherCourseProgramMap', 
				 itemId:'pncWhetherCourseAndProgramMap',
				 inputValue: "MapCourseOutcomesAndProgramOutcomes",
				 inputValue: false
			 }]
		 }
		 ]
	  },{	
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name:'PROGRAM_NAME',
			store:'common.ProgramStore',
			itemId:'programId',
			fieldLabel: getCommonTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'programName',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
			width: 536,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}

		},{
            xtype: 'customcombobox',
            name: 'BATCH_NAME',
            itemId: 'batchId',
           // store:'common.CurrentBatchStore',
            fieldLabel: getPersonModuleTranslation('BATCH'),
            disabled:true,
            editable: false,
            allowBlank: false,
            valueField: 'id',
			displayField: 'value',
			typeAhead:false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.CurrentBatchStore');
                    combo.bindStore(store);
                }
            }
        }]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top',
		},
		items:[{
			xtype: 'multiselectcombofield',
			width: 536,
			name:'PERIOD_NAME',
			itemId: 'periodId',
			disabled:true,
			fieldLabel: getPersonModuleTranslation('PERIOD'),
			displayField:'value',
			valueField:'id',
			typeAhead:false,
			forceSelection:true,
			autoloadStore: false,
			allowBlank: false,
			queryMode:'local',
			cls:'commonAutoHeightMultiselectField',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                    combo.bindStore(store);
                }
            }
        },{
            xtype: 'customcombobox',
            itemId:'pncProgramOutComeTypeItemId',
            editable: false,
            allowBlank: false,
            displayField: 'code',
            disabled:true,
            valueField: 'id',
            fieldLabel: getProgramandcourseTranslation('PROGRAM_OUTCOME_TYPE'),
            name: 'pncProgramOutComeTypeName',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.program.StoPncProgramOutComeTypeMapCourse');
                    combo.bindStore(store);
                }
            }
        }]  

	},{

		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top',
		},
		items:[{
			xtype: 'multiselectcombofield',
			itemId:'courseItemId',
			name:'COURSE_Name',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			width: 536,
			disabled:true,
			displayField:'value',
			valueField:'id',
			typeAhead:false,
			forceSelection:true,
			autoloadStore: false,
			queryMode:'local',
			cls:'commonAutoHeightMultiselectField',
//            listeners: {
//                render: function(combo) {
//                    var store = Ext.create('Academia.store.course.OBEMappingCourseStore');
//                    combo.bindStore(store);
//                }
//            }
        }]  
	},{
		 xtype: 'panel',
		 width:'100%',
		 cls: 'panelNoSpace',
		 items: [{
			 xtype : 'vwpncprogramcourseoutcomegrid',
			 margin: '8 0 25 0'
		 }]
	 },{
		 xtype:'fieldcontainer',
		 width:'auto',
		 layout: {
			 type: 'hbox'
		 },
		 cls:'form-fixed-footer',
		 items: [{

			 xtype: 'button',
			 action: 'Submit',
			 text: getCommonTranslation('SAVE'),
			 formBind: true,
			 itemId: 'pncMapCPSubmitButtonId',
			 ui: 'CustomBtnSubmit',
			 scale: CONSTANTS.BUTTONSIZE
		 },{
			 xtype: 'button',
			 text: getCommonTranslation('RESET'),
			 ui: 'CustomBtnCancel',
			 itemId:'pncMapCPCancelbuttonId',
			 scale: CONSTANTS.BUTTONSIZE

		 }]
	 }]
});
