/**
 * Anand Verma
 */
Ext.define('Academia.view.program.programDetails.programBatchDetails.courseParameters.CourseParameterAssignGrid', {//extend : 'Ext.form.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.courseparameterassigngrid',
	title:getCommonTranslation('TITLE_ASSIGN_COURSES'),
	store:'program.programDetails.programBatches.courseParameter.ProgramCourseAssign',
	collapsed:false,
	width: '100%',
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'program.programDetails.programBatches.courseParameter.ProgramCourseAssign',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		disabled:true,
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},
	// as discussed, commenting update functionality bcoz logic of variant creation on update
	// Akshay Sharma :- as discussed, un commited code for edit min and max capacity
	{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
		//text : getCommonTranslation('EDIT')
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
		//text : getCommonTranslation('DELETE')
	},{
		xtype : 'button',				
		itemId : 'addFacultyBtnItemId',
		tooltip :getCommonTranslation('ADD'),
		text : getCommonTranslation('ADD_FACULTY')
	},{
        xtype : 'button',                
        itemId : 'updateCourseParameterBtnItemId',
        text : getCommonTranslation('UPDATE_REGULAR_COURSE_PARAMETER'),
        hidden: true
    }],
	columns : [/*{
		header : 'ID',
		hidden : true,
		dataIndex:'id'
	},*/{
		header : getCommonTranslation('COURSE_VARIANT'),
//		translationKey:'COURSE_VARIANT',
		dataIndex : 'courseVariantCode',
		flex : .3

	}, {
		header : getCommonTranslation('PERIODS'),
		dataIndex : 'programPeriodName',
		flex : .2
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : .2

	},{
		header : getCourseTxCommonTranslation('ASSIGNED_FACULTIES'),
		dataIndex : 'facultyAssignmentCount',
		flex : .2,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('REGULAR_COURSE_PARAMETER'),
		dataIndex : 'whetherRegularCourse',
		flex : .2,
		renderer:function(value){
			if(value == true){
				return  'Yes';
			}else{
				return 'No';
			}
		}
	},
	{
		header : getCommonTranslation('SECTION_MIN_ENROLLMENT'),
		dataIndex : 'minSectionEnrollment',
		hidden : true,
		flex : .2
	},{
		header : getCommonTranslation('SECTION_MAX_ENROLLMENT'),
		dataIndex : 'maxSectionEnrollment',
		hidden : true,
		flex : .2
	}]
});