/**
 * Anand Verma
 */
Ext.define('Academia.view.program.programDetails.programBatchDetails.courseParameters.CourseParameterGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.courseparametergrid',
   // xtype:'grid',
    collapsible:true,
    title:getCommonTranslation('COURSES'),
//    translationKey: 'COURSES',
    cls:'horizontal-scrolling-fix', 
    store:'program.programDetails.programBatches.courseParameter.ProgramCourseParameter',
    border:true,
    frame:false,
    selType :'checkboxmodel',
	itemId: 'StudentSearchResultGrid',
	isFixHeightGrid: true,
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	maxHeight: 600,
	style: {
		'position': 'relative !important',
		maxHeight: 600
	},
    viewConfig : {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [{
    	xtype: 'toolbar',
    	dock: 'bottom',
    	items: [{
    		xtype: 'custompagingtoolbar',
    		plugins:['pagesize'],
    		store : 'program.programDetails.programBatches.courseParameter.ProgramCourseParameter',
    		emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
    		displayInfo: true
    	}]
    }],
    initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns : [{
	    header :getCommonTranslation('COURSE_CODE_NAME'),
//	    translationKey: 'COURSE_CODE_NAME',
	    dataIndex:'courseCode',
	    flex:.3,
	    sortable : true,
	    renderer:function(value, e, rec){
	    	if(rec.data) {
	    		return rec.data.courseCode +"/"+ rec.data.courseName;
	    	}
	    }
	},{
	    header : getProgramandcourseTranslation('PERIOD'),
	    dataIndex : 'programPeriodName',
	    flex:.2,
	    sortable : true
	},{
	    header : getCommonTranslation('SECTION'),
	    dataIndex : 'sectionName',
	    flex:.2,
	    sortable : true
	},{
	    header :getCommonTranslation('FACULTY') ,
	    dataIndex : 'faculty',
	    flex:.2,
	    sortable : true
	},{
	    header :getCourseTxCommonTranslation('ALTERNATE_FACULTY') ,
	    dataIndex : 'alternateFaculty',
	    flex:.2,
	    sortable : true
	},{
	    header : getProgramandcourseTranslation('SECTION_TYPE'),
	    dataIndex : 'assignSectionType',
	    flex:.2,
	    sortable : true
	},{
	    header :getCommonTranslation('OPTIONAL_MANDATORY') ,
	    dataIndex : 'whetherOptional',
	    flex:.2,
	    sortable : true,
	    renderer:function(v){
	    	if(v){
	    		return getCommonTranslation('OPTIONAL');
	    	}else{
	    		return getCommonTranslation('MANDATORY');
	    	}
	    }
	},{
        header : getCommonTranslation('REGULAR_COURSE_PARAMETER'),
        dataIndex : 'whetherRegularCourse',
        flex : .2,
        renderer:function(value){
            if(value == true){
                return  'Yes';
            }else{
                return 'No';
            }
        }
    },{
	    header : getCommonTranslation('INDEPENDENT_GROUP'),
	    dataIndex : 'courseGroupName',
	    flex:.2,
	    sortable : true,
	    hidden : true,
	    renderer:function(v){
	    	if(v!=null){
	    		return getCommonTranslation('GROUP');
	    	}else{
	    		return getCommonTranslation('INDEPENDENT');
	    	}
	    }
	},{
	    header :getCommonTranslation('COURSE_GROUP_NAME') ,
//	    translationKey: 'COURSE_GROUP_NAME',
	    dataIndex : 'courseGroupName',
	    flex:.2,
	    hidden : true,
	    sortable : true
	}, {
		header : getCommonTranslation('SECTION_MIN_ENROLLMENT'),
		dataIndex : 'minSectionEnrollment',
		hidden : true,
		flex : .2,
		sortable : true
	},{
		header : getCommonTranslation('SECTION_MAX_ENROLLMENT'),
		dataIndex : 'maxSectionEnrollment',
		hidden : true,
		flex : .2,
		sortable : true
	},{
		header : getCommonTranslation("COURSE_SEQUENCE"),
		dataIndex: 'courseSequence',
		hidden: true,
		flex: .2,
		sortable: true
	}]
   });