/**
 * @ Raghavendra.Soni
 */
Ext.define('Academia.view.program.programDetails.programBatchDetails.periods.PeriodActivityDatesList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.periodactivitydateslist',
	store : 'program.programDetails.programBatches.programPeriod.PeriodActivityDatesStore',
	title: getCommonTranslation('LIST_OF_PERIOD_ACTIVITY'),
	cls: 'periodActivityDateListCls',
	border: true,
	overflowY: 'auto',
	height: 500,
	viewConfig : {
		stripeRows :  CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
	},
	columns: [
		{
			xtype: 'rownumberer',
			sortable:false,
			header: getCommonTranslation('S_NO'),
			width: 50
		},
		{
			dataIndex: 'periodEventNameId',
			sortable:false,
			header: getCommonTranslation('EVENT_NAME'),
			flex:1,
			renderer:function(value, meta, record) {
				if(isNullOrEmpty(value)){
					meta.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return record.data.periodEventName.value;
				}
			},
			editor: {
				xtype: 'customcombobox',
				name:'eventName',
				itemId:'eventName',
				store:'program.programDetails.programBatches.programPeriod.PeriodActivityEventStore',
				valueField:'id',
				displayField:'value',
				editable:false,
				listeners: {
	                change:function(field, newValue, oldValue){ 
						var grid = field.up('grid');
						var record = grid.getSelectionModel().getSelection()[0];
						record.get('periodEventName').id = newValue;
						record.get('periodEventName').value = field.getDisplayValue();
					}
	            }
			}
		},
		{
		    dataIndex: 'adminStartDate',
		    sortable: false,
		    header: getCommonTranslation('START_DATE'),
		    flex: 1,
		    editor: {
		        xtype: 'datefield',
		        name: 'adminStartDate',
		        itemId: 'adminStartDateId',
		        listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
					},
					change:function(field, newValue, oldValue){
						var me = this;
						var grid = field.up('grid');
						var record = grid.getSelectionModel().getSelection()[0];
						
						setTimeout(function(){
							if(newValue){
								record.set('startDate',newValue.getTime());
							}
							else if(oldValue){
								record.set('startDate',oldValue.getTime());
							}
							else{
								record.set('startDate','');
							}
						},10);
					}
		        }
		    },
		    renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
	        	var dateVal = dateRender(val);
	        	if(dateVal == "NaN-NaN-0NaN"){
	        		return val;	
	        	}else if(!isNullOrEmpty(val)){
	        		var date = moment(new Date(val), "DD/MM/YYYY").format("DD-MM-Y");
	        		if(date == "Invalid date"){
	        			date = moment(new Date(val), "MM/DD/YYYY").format("DD-MM-Y");
	        		}
	        		return date;
	        	}
	        	else{
	        		rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
	        }
		},
		{
		    dataIndex: 'adminEndDate',
		    sortable: false,
		    header: getCommonTranslation('END_DATE'),
		    flex: 1,
		    editor: {
		        xtype: 'datefield',
		        name: 'adminEndDate',
		        itemId: 'adminEndDateId',
		        listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
					},
					change:function(field, newValue, oldValue){
						var me = this;
						var grid = field.up('grid');
						var record = grid.getSelectionModel().getSelection()[0];
						
						if(newValue){
							record.set('endDate',newValue.getTime());
						}
						else if(oldValue){
							record.set('endDate',oldValue.getTime());
						}
						else{
							record.set('endDate','');
						}
					}
		        }
		    },
		    renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
	        	var dateVal = dateRender(val);
	        	if(dateVal == "NaN-NaN-0NaN"){
	        		return val;	
	        	}else if(!isNullOrEmpty(val)){
	        		var date = moment(new Date(val), "DD/MM/YYYY").format("DD-MM-Y");
	        		if(date == "Invalid date"){
	        			date = moment(new Date(val), "MM/DD/YYYY").format("DD-MM-Y");
	        		}
	        		return date;
	        	}
	        	else{
	        		rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
	        }
		},
		{
			dataIndex: '',
			header: getCommonTranslation('ADD'),
			sortable:false,
			flex:1,
			renderer: function(value, meta, record) {
				return "<div class='addButtonClsForGridActionCls' data-qtip='Add' style='marginRight: 20 auto !important'></div>";
			}
		},
		{
			dataIndex: '',
			header: getCommonTranslation('DELETE'),
			sortable:false,
			flex:1,
			renderer: function(value, meta, record) {
				//if(meta.recordIndex != 0){
					return "<div class='deleteButtonClsForGridActionCls' data-qtip='Delete' style='marginRight: 20 auto !important'></div>";
				/*}else{
					return '';
				}*/
			}
		}
	],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
            beforeedit: function(ed,e){
            	var record = e.record;
            	var fieldName = e.field;
            	if(fieldName == 'adminStartDate'){
            		var adminEndDate = record.get('adminEndDate');
            		var startDateEditor = e.column.getEditor(record);
            		startDateEditor.setMinValue(false);
            		if(adminEndDate){
                		startDateEditor.setMaxValue(Ext.Date.format(adminEndDate, 'Y-m-d'));
            		}
            		else{
                		startDateEditor.setMaxValue(false);
            		}
            	}
            	else if(fieldName == 'adminEndDate'){
            		var adminStartDate = record.get('adminStartDate');
            		var endDateEditor = e.column.getEditor(record);
            		endDateEditor.setMaxValue(false);
            		if(adminStartDate){
            			endDateEditor.setMinValue(Ext.Date.format(adminStartDate, 'Y-m-d'));
            		}
            		else{
            			endDateEditor.setMinValue(false);
            		}
            	}
            	e.grid.getSelectionModel().deselectAll();
            	e.grid.getView().refresh();
            }
        }
	}]
});